/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.kdf.table.AbstractTableTravelPolicy;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTCellIndex;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;

public final class DataBlockJumpByRow
extends AbstractTableTravelPolicy {
    private KDTCellIndex cellIndex = new KDTCellIndex();
    KDTSelectManager sman = this.table.getSelectManager();

    public DataBlockJumpByRow(KDTable table) {
        super(table);
    }

    @Override
    public KDTCellIndex nextCellIndex(int rowIndex, int colIndex) {
        if (this.table.getRow(rowIndex) == null) {
            return null;
        }
        this.cellIndex.setRowIndex(rowIndex);
        int maxColIndex = this.table.getColumnCount() - 1;
        boolean flag = this.isNullCell(rowIndex, colIndex);
        int nextColIndex = this.sman.nextColIndex(rowIndex, colIndex);
        if (nextColIndex < maxColIndex) {
            if (flag) {
                while (colIndex < maxColIndex && this.isNullCell(rowIndex, colIndex)) {
                    colIndex = this.sman.nextColIndex(rowIndex, colIndex);
                }
            } else if (this.isNullCell(rowIndex, nextColIndex)) {
                colIndex = nextColIndex + 1;
                while (colIndex < maxColIndex && this.isNullCell(rowIndex, colIndex)) {
                    colIndex = this.sman.nextColIndex(rowIndex, colIndex);
                }
            } else {
                colIndex = nextColIndex + 1;
                while (colIndex < maxColIndex) {
                    if (this.isNullCell(rowIndex, colIndex)) {
                        --colIndex;
                        break;
                    }
                    colIndex = this.sman.nextColIndex(rowIndex, colIndex);
                }
            }
        } else {
            colIndex = nextColIndex;
        }
        if (colIndex > maxColIndex) {
            colIndex = maxColIndex;
        }
        this.cellIndex.setColIndex(colIndex);
        return this.cellIndex;
    }

    @Override
    public KDTCellIndex previousCellIndex(int rowIndex, int colIndex) {
        if (this.table.getRow(rowIndex) == null) {
            return null;
        }
        this.cellIndex.setRowIndex(rowIndex);
        boolean flag = this.isNullCell(rowIndex, colIndex);
        int preColIndex = this.sman.previousColIndex(rowIndex, colIndex);
        if (preColIndex > 0) {
            if (flag) {
                while (colIndex > 0 && this.isNullCell(rowIndex, colIndex)) {
                    colIndex = this.sman.previousColIndex(rowIndex, colIndex);
                }
            } else if (this.isNullCell(rowIndex, preColIndex)) {
                colIndex = preColIndex - 1;
                while (colIndex > 0 && this.isNullCell(rowIndex, colIndex)) {
                    colIndex = this.sman.previousColIndex(rowIndex, colIndex);
                }
            } else {
                colIndex = preColIndex - 1;
                while (colIndex > 0) {
                    if (this.isNullCell(rowIndex, colIndex)) {
                        ++colIndex;
                        break;
                    }
                    colIndex = this.sman.previousColIndex(rowIndex, colIndex);
                }
            }
        } else {
            colIndex = preColIndex;
        }
        if (colIndex < 0) {
            colIndex = 0;
        }
        this.cellIndex.setColIndex(colIndex);
        return this.cellIndex;
    }

    private boolean isNullCell(int rowIndex, int colIndex) {
        ICell cell = this.table.getRow(rowIndex).getCell(colIndex);
        if (cell.getMergeBlock() == null) {
            return null == this.table.getRow(rowIndex).getCell(colIndex).getValue();
        }
        KDTMergeBlock block = cell.getMergeBlock();
        return null == this.table.getRow(block.getTop()).getCell(block.getLeft()).getValue();
    }
}

