/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import java.util.ArrayList;
import java.util.List;

public class KDTColumns {
    private ArrayList columns;
    private KDTable table;

    public KDTColumns(KDTable table) {
        this.table = table;
        this.columns = new ArrayList();
    }

    public int size() {
        return this.columns.size();
    }

    public void addColumn(KDTColumn column) {
        this.columns.add(column);
    }

    public void addColumn(int colIndex, KDTColumn column) {
        this.columns.add(colIndex, column);
    }

    public void setColumn(int colIndex, KDTColumn col) {
        if (colIndex < 0 || colIndex >= this.size()) {
            return;
        }
        this.columns.set(colIndex, col);
    }

    public KDTColumn removeColumn(int colIndex) {
        return (KDTColumn)this.columns.remove(colIndex);
    }

    public void removeColumns() {
        this.columns.clear();
    }

    public KDTColumn getColumn(int colIndex) {
        if (colIndex < 0 || colIndex >= this.columns.size()) {
            return null;
        }
        return (KDTColumn)this.columns.get(colIndex);
    }

    public int getColumnWidth(int colIndex) {
        if (colIndex >= 0 && colIndex < this.size()) {
            KDTColumn column = this.getColumn(colIndex);
            if (column.getStyle().isHided()) {
                return 0;
            }
            int width = column.getWidth();
            if (width == -1) {
                width = this.table.getDefaultColumnWidth();
            }
            return width;
        }
        return -1;
    }

    public void setColumnWidth(int colIndex, int width) {
        if (colIndex >= 0 && colIndex < this.size()) {
            this.getColumn(colIndex).setWidth(width);
        }
    }

    public String getColumnKey(int colIndex) {
        if (colIndex >= 0 && colIndex < this.size()) {
            return this.getColumn(colIndex).getKey();
        }
        return null;
    }

    public int getColumnIndex(String key) {
        for (int i = 0; i < this.size(); ++i) {
            String colKey = this.getColumn(i).getKey();
            if (colKey == null || !colKey.equals(key)) continue;
            return i;
        }
        return -1;
    }

    public int getWidth(int left, int right) {
        if (left < 0) {
            left = 0;
        }
        if (right >= this.size()) {
            right = this.size() - 1;
        }
        int width = 0;
        for (int i = left; i <= right; ++i) {
            width += this.getColumnWidth(i);
        }
        return width;
    }

    public int getWidth() {
        int width = 0;
        for (int i = 0; i < this.size(); ++i) {
            width += this.getColumnWidth(i);
        }
        return width;
    }

    public List getColumns() {
        return this.columns;
    }

    public void exchangeColumn(int from, int to) {
        KDTColumn fromCell = this.getColumn(from);
        KDTColumn toCell = this.getColumn(to);
        this.setColumn(from, toCell);
        this.setColumn(to, fromCell);
    }

    public void moveColumn(int from, int to) {
        KDTColumn fromCell = this.getColumn(from);
        this.removeColumn(from);
        if (from > to) {
            this.addColumn(to, fromCell);
        } else {
            this.addColumn(to - 1, fromCell);
        }
    }

    public boolean autoFitColumnWidth(int colIndex) {
        return KDTableHelper.autoFitColumnWidth(this.table, colIndex);
    }

    public boolean autoFitColumnWidth(int colIndex, int extend) {
        return KDTableHelper.autoFitColumnWidth(this.table, colIndex, extend);
    }
}

