/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.kdf.table.DataTable;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTBody;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTCellIndex;
import com.kingdee.bos.ctrl.kdf.table.KDTFindParameter;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTReplaceParameter;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTTransferAction;
import com.kingdee.bos.ctrl.kdf.table.KDTTransferHandle;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.StringTable;
import com.kingdee.bos.ctrl.kdf.table.event.DataActionEvent;
import com.kingdee.bos.ctrl.kdf.util.file.IDObject;
import com.kingdee.bos.ctrl.kdf.util.file.IXmlTrans;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Point;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Element;

public class KDTEditHelper {
    private KDTable table;
    private KDTTransferHandle th;
    private static final String RANGE_SIZE_INVALIDATE_TIP = "\u533a\u57df\u8fc7\u5927\u65e0\u6cd5\u590d\u5236\u8bf7\u4f7f\u7528\u5bfc\u51fa\u529f\u80fd\u3002";
    private static final String RANGE_SIZE_INVALIDATE_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DocRoot xmlns:c=\"http://www.kingdee.com/Common\" xmlns:f=\"http://www.kingdee.com/Form\" xmlns:t=\"http://www.kingdee.com/Table\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" version=\"0.0\">\n    <DocInfo>\n        <c:Author>null</c:Author>\n        <c:Created>Mon Jun 20 16:55:23 CST 2022</c:Created>\n        <c:Company>kingdee.com</c:Company>\n        <c:LastModified>Mon Jun 20 16:55:23 CST 2022</c:LastModified>\n    </DocInfo>\n    <DataSources />\n    <DataObjects />\n    <Styles version=\"1.0\">\n        <c:Style id=\"0\">\n            <c:Font fontName=\"Dialog.plain\" size=\"9\" />\n            <c:Interior color=\"#ffffff00\" />\n            <c:Alignment horizontal=\"left\" />\n        </c:Style>\n    </Styles>\n    <Table t:id=\"clipboard\" t:clipboardMode=\"1\" t:clipboardContent=\"15\">\n        <t:Sheet t:name=\"NotSupportedInThisVersion\">\n            <t:Table>\n                <t:ColumnGroup>\n                    <t:Column />\n                </t:ColumnGroup>\n                <t:Body>\n                    <t:Row>\n                        <t:Cell t:styleID=\"0\">\n                            <t:Value t:type=\"string\">\u533a\u57df\u8fc7\u5927\u65e0\u6cd5\u590d\u5236\u8bf7\u4f7f\u7528\u5bfc\u51fa\u529f\u80fd\u3002</t:Value>\n                        </t:Cell>\n                    </t:Row>\n                </t:Body>\n            </t:Table>\n            <t:SheetOptions>\n                <t:MergeBlocks />\n            </t:SheetOptions>\n        </t:Sheet>\n    </Table>\n</DocRoot>";
    public static final int ALL = 15;
    public static final int STYLE = 1;
    public static final int VALUE = 2;
    public static final int FORMULA = 4;
    public static final int USEROBJECT = 8;
    public static final int FID = 22;
    public static final int DISPLAYVALUE = 50;
    public static final int MAX_COPY_CELLS = 5000;
    public static final int DELETE_ALL = 15;
    public static final int DELETE_CONTENT = 14;
    public static final int DELETE_STYLE = 1;
    public static final int DELETE_VALUE = 2;
    public static final int DELETE_FORMULA = 4;
    public static final int DELETE_USEROBJECT = 8;

    public KDTEditHelper(KDTable table) {
        this.table = table;
    }

    public Point find(KDTFindParameter para) {
        return null;
    }

    public Point[] findAll(KDTFindParameter para) {
        ArrayList result = new ArrayList();
        this.findInRange(para, result, false);
        int length = result.size();
        Point[] ps = new Point[length];
        result.toArray(ps);
        return ps;
    }

    public Point[] replaceAll(KDTReplaceParameter para) {
        ArrayList result = new ArrayList();
        this.findInRange(para, result, true);
        int length = result.size();
        Point[] ps = new Point[length];
        result.toArray(ps);
        return ps;
    }

    private void findInRange(KDTFindParameter para, List result, boolean replace) {
        KDTRange range = para.getRange();
        if (range == null) {
            range = new KDTRange();
            KDTBlock block = new KDTBlock();
            block.setMode(8);
            range.add(block);
        }
        int blockCount = range.size();
        for (int i = 0; i < blockCount; ++i) {
            IBlock block = (IBlock)range.get(i);
            this.findInBlock(para, block, result, replace);
        }
    }

    private void findInBlock(KDTFindParameter para, IBlock block, List result, boolean replace) {
        KDTRow row;
        switch (block.getMode()) {
            case 8: {
                block.setTop(0);
                block.setLeft(0);
                block.setBottom(this.table.getRowCount3() - 1);
                block.setRight(this.table.getColumnCount() - 1);
                break;
            }
            case 4: {
                block.setTop(0);
                block.setBottom(this.table.getRowCount3() - 1);
                break;
            }
            case 2: {
                block.setLeft(0);
                block.setRight(this.table.getColumnCount() - 1);
                break;
            }
        }
        int top = block.getTop();
        int left = block.getLeft();
        int bottom = block.getBottom();
        int right = block.getRight();
        KDTBody rows = this.table.getBody();
        if (!(para instanceof KDTReplaceParameter)) {
            replace = false;
        }
        for (int i = top; i <= bottom && (row = rows.getRow(i)) != null; ++i) {
            for (int j = left; j <= right; ++j) {
                KDTCell cell = row.getCell(j);
                if (!this.checkCell(cell, para)) continue;
                result.add(new Point(j, i));
                if (!replace) continue;
                KDTReplaceParameter rPara = (KDTReplaceParameter)para;
                this.setCellContent(cell, rPara.getItem(), rPara.getNewContent());
            }
        }
    }

    private boolean checkCell(KDTCell cell, KDTFindParameter para) {
        if (cell == null) {
            return false;
        }
        Object value = this.getCellContent(cell, para.getItem());
        if (value == null) {
            return false;
        }
        return value.equals(para.getContent());
    }

    private Object getCellContent(KDTCell cell, int item) {
        Object value = null;
        if ((item & 1) == 1) {
            value = cell.getValue();
        } else if ((item & 2) == 2) {
            value = cell.getExpressions();
        } else if ((item & 4) == 4) {
            value = cell.getUserObject();
        }
        return value;
    }

    private void setCellContent(KDTCell cell, int item, Object content) {
        if ((item & 1) == 1) {
            cell.setValue(content);
        } else if ((item & 2) == 2) {
            cell.setExpressions(content.toString());
        } else if ((item & 4) == 4) {
            cell.setUserObject(content);
        }
    }

    KDTTransferHandle getTransferHandle() {
        if (this.th == null) {
            this.th = new KDTTransferHandle(this.table);
        }
        return this.th;
    }

    public void copy() {
        this.copy(15);
    }

    public void copy(int mark) {
        if (!this.table.excuteBeforeAction(4, new Integer(mark))) {
            return;
        }
        KDTTransferHandle th = this.getTransferHandle();
        if (mark == 22) {
            th.setMark(15);
            this.table.setCopyFID(true);
        } else if (mark == 50) {
            th.setMark(50);
            this.table.setCopyFID(false);
        } else {
            th.setMark(mark);
            this.table.setCopyFID(false);
        }
        th.exportToClipboard();
        this.table.excuteAfterAction(4, new Integer(mark));
    }

    public void paste() {
        this.paste(15);
    }

    public void paste(int mark) {
        if (!this.table.excuteBeforeAction(5, new Integer(mark))) {
            return;
        }
        KDTTransferHandle th = this.getTransferHandle();
        th.setMark(mark);
        th.importFromClipboard();
        this.table.excuteAfterAction(5, new Integer(mark));
    }

    public KDTSelectBlock prePaste() {
        KDTTransferHandle th = this.getTransferHandle();
        th.setMark(15);
        return th.preImportFromClipboard();
    }

    public boolean isPastable() {
        return this.getTransferHandle().isClipboardDataAvailable();
    }

    public void cut() {
        this.cut(15);
    }

    public void cut(int mark) {
        if (!this.table.excuteBeforeAction(6, new Integer(mark))) {
            return;
        }
        this.copy(mark);
        KDTRange range = this.table.getSelectManager().toRange();
        this.delete(range.getSequenceRange(), mark);
        this.table.excuteAfterAction(6, new Integer(mark));
    }

    private boolean checkRangeSize(KDTRange range) {
        int total = 0;
        for (Object b : range) {
            IBlock block = (IBlock)b;
            if ((total += Math.abs(block.getBottom() - block.getTop()) * Math.abs(block.getRight() - block.getLeft())) <= 5000) continue;
            return false;
        }
        return true;
    }

    String getXmlForClipboard(DataTable datTable) {
        if (!this.checkRangeSize(this.table.getSelectManager().toRange())) {
            return RANGE_SIZE_INVALIDATE_XML;
        }
        HashMap<String, Object> xmlParamMap = new HashMap<String, Object>();
        xmlParamMap.put("destination", "clipboard");
        xmlParamMap.put("type", "xml");
        xmlParamMap.put("dataTable", datTable);
        this.table.fireExportEvent(new DataActionEvent(this, 0, xmlParamMap));
        KDF kdf = new KDF();
        StringWriter writer = new StringWriter();
        kdf.setTableTrans((IXmlTrans)new ClipboardXmlTranse(datTable));
        kdf.addTable((IDObject)this.table);
        kdf.save((Writer)writer);
        this.table.fireExportEvent(new DataActionEvent(this, 1, xmlParamMap));
        return ((Object)writer).toString();
    }

    String getStringForClipboard(DataTable datTable) {
        if (!this.checkRangeSize(this.table.getSelectManager().toRange())) {
            return RANGE_SIZE_INVALIDATE_TIP;
        }
        StringTable st = new StringTable();
        HashMap<String, Object> strParamMap = new HashMap<String, Object>();
        strParamMap.put("destination", "clipboard");
        strParamMap.put("type", "string");
        strParamMap.put("stringTable", st);
        this.table.fireExportEvent(new DataActionEvent(this, 0, strParamMap));
        st.load(datTable, this.table);
        StringWriter writer = new StringWriter();
        st.save(writer);
        this.table.fireExportEvent(new DataActionEvent(this, 1, strParamMap));
        return ((Object)writer).toString();
    }

    void parseXmlFromClipboard(String xml, int mark) {
        boolean refresh = this.table.isRefresh();
        this.table.setRefresh(false);
        DataTable dt = new DataTable(mark);
        HashMap<String, Object> xmlParamMap = new HashMap<String, Object>();
        xmlParamMap.put("destination", "clipboard");
        xmlParamMap.put("type", "xml");
        xmlParamMap.put("dataTable", dt);
        this.table.fireImportEvent(new DataActionEvent(this, 0, xmlParamMap));
        dt.load(new StringReader(xml));
        dt.save(this.table, this.table.getSelectManager().toRange());
        this.table.fireImportEvent(new DataActionEvent(this, 1, xmlParamMap));
        this.table.setRefresh(refresh);
        this.table.repaint();
    }

    public void parseStringFromClipboard(String str) {
        boolean refresh = this.table.isRefresh();
        this.table.setRefresh(false);
        StringTable st = new StringTable();
        HashMap<String, Object> strParamMap = new HashMap<String, Object>();
        strParamMap.put("destination", "clipboard");
        strParamMap.put("type", "string");
        strParamMap.put("stringTable", st);
        this.table.fireImportEvent(new DataActionEvent(this, 0, strParamMap));
        st.load(str);
        KDTSelectManager sm = this.table.getSelectManager();
        KDTSelectBlock block = sm.get();
        if (block != null) {
            st.save(this.table, block.getTop(), block.getLeft());
        }
        this.table.fireImportEvent(new DataActionEvent(this, 1, strParamMap));
        this.table.setRefresh(refresh);
        this.table.repaint();
    }

    public KDTSelectBlock preParseStringFromClipboard(String str) {
        StringTable st = new StringTable();
        st.load(str);
        KDTSelectManager sm = this.table.getSelectManager();
        return st.preSave(this.table, sm.getActiveRowIndex(), sm.getActiveColumnIndex());
    }

    public static boolean isAll(int mark) {
        return mark == 15;
    }

    public static boolean isDisplayValue(int mark) {
        return mark == 50;
    }

    public static boolean isStyle(int mark) {
        return (mark & 1) == 1;
    }

    public static boolean isValue(int mark) {
        return (mark & 2) == 2;
    }

    public static boolean isFormula(int mark) {
        return (mark & 4) == 4;
    }

    public static boolean isUserObject(int mark) {
        return (mark & 8) == 8;
    }

    public int delete() {
        return this.delete(this.table.getSelectManager().toRange());
    }

    public int delete(int mark) {
        return this.delete(this.table.getSelectManager().toRange(), mark);
    }

    public int delete(KDTRange range) {
        return this.delete(range, 14);
    }

    public int delete(KDTRange range, int mark) {
        if (!this.table.excuteBeforeAction(7, new Integer(mark))) {
            return 0;
        }
        if (range == null) {
            return 0;
        }
        int size = range.size();
        if (size <= 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < size; ++i) {
            IBlock block = (IBlock)range.get(i);
            int top = 0;
            int left = 0;
            int bottom = 0;
            int right = 0;
            switch (block.getMode()) {
                case 8: {
                    top = 0;
                    left = 0;
                    bottom = this.table.getRowCount3() - 1;
                    right = this.table.getColumnCount() - 1;
                    break;
                }
                case 4: {
                    top = 0;
                    left = block.getLeft();
                    bottom = this.table.getRowCount3() - 1;
                    right = block.getRight();
                    break;
                }
                case 2: {
                    top = block.getTop();
                    left = 0;
                    bottom = block.getBottom();
                    right = this.table.getColumnCount() - 1;
                    break;
                }
                case 1: {
                    top = block.getTop();
                    left = block.getLeft();
                    bottom = block.getBottom();
                    right = block.getRight();
                    break;
                }
                default: {
                    return 0;
                }
            }
            for (int j = top; j <= bottom; ++j) {
                for (int k = left; k <= right; ++k) {
                    if (!this.deleteCell2(j, k, mark)) continue;
                    ++count;
                }
            }
        }
        if (count > 0) {
            this.table.repaint();
        }
        this.table.excuteAfterAction(7, new Integer(mark));
        return count;
    }

    public ICell deleteCell(int rowIndex, int colIndex) {
        return this.deleteCell(rowIndex, colIndex, 14);
    }

    public ICell deleteCell(int rowIndex, int colIndex, int mark) {
        if (colIndex >= this.table.getColumnCount()) {
            return null;
        }
        ICell cell = this.table.getRow(rowIndex).getCell(colIndex);
        this.deleteCell2(rowIndex, colIndex, mark);
        this.table.repaint();
        return cell;
    }

    boolean deleteCell2(int rowIndex, int colIndex, int mark) {
        KDTRow row = this.table.getBody().getRow(rowIndex);
        if (row != null) {
            KDTCell cell = row.getCell(colIndex);
            if (cell == null) {
                return false;
            }
            if (cell.getStyle().isLocked()) {
                return false;
            }
            if (KDTEditHelper.isAll(mark)) {
                this.splitMergeBlock(cell);
                Object oldValue = cell.getValue();
                row.setCell(colIndex, null);
                if (oldValue != null) {
                    KDTCellIndex index = new KDTCellIndex();
                    index.setRowIndex(rowIndex);
                    index.setColIndex(colIndex);
                    index.setType(1);
                    this.table.fireCellPropertyChange("cellValue", oldValue, null, index);
                }
            } else {
                if (KDTEditHelper.isValue(mark)) {
                    Object oldValue = cell.getValue();
                    if (oldValue != null) {
                        KDTCellIndex index = new KDTCellIndex();
                        index.setRowIndex(rowIndex);
                        index.setColIndex(colIndex);
                        index.setType(1);
                        this.table.fireCellPropertyChange("cellValue", oldValue, null, index);
                    }
                    cell.setValue(null);
                }
                if (KDTEditHelper.isStyle(mark)) {
                    this.splitMergeBlock(cell);
                    ShareStyleAttributes ssaRow = row.getSSA();
                    ShareStyleAttributes ssaCol = this.table.getColumns().getColumn(colIndex).getSSA();
                    ShareStyleAttributes ssa = Styles.getEmptySSA();
                    Style style = this.table.getBlankCellStyle(ssaRow, ssaCol);
                    cell.setSSA(ssa);
                    cell.setStyle(style);
                }
                if (KDTEditHelper.isFormula(mark)) {
                    cell.setExpressions(null);
                }
                if (KDTEditHelper.isUserObject(mark)) {
                    cell.setUserObject(null);
                }
            }
            if (this.table.scriptManager != null) {
                this.table.scriptManager.cellPropertyChanged(rowIndex, colIndex);
            }
            return true;
        }
        return false;
    }

    void splitMergeBlock(KDTCell cell) {
        KDTMergeBlock block = cell.getMergeBlock();
        if (block != null) {
            this.table.getMergeManager().splitBlock(block.getTop(), block.getLeft(), block.getBottom(), block.getRight());
        }
    }

    public KDTSelectBlock preParseXmlFromClipboard(String xml, int mark) {
        DataTable dt = new DataTable(mark);
        dt.load(new StringReader(xml));
        return dt.preSave(this.table, this.table.getSelectManager().toRange());
    }

    public void setCoypMode(int mode) {
        if (mode == 15 || mode == 1 || mode == 2 || mode == 4 || mode == 8) {
            KDTTransferAction copyAction = (KDTTransferAction)this.table.getActionMap().get("Copy");
            copyAction.setCopyMode(mode);
        }
    }

    public int getCopyMode() {
        return ((KDTTransferAction)this.table.getActionMap().get("Copy")).getCopyMode();
    }

    class ClipboardXmlTranse
    implements IXmlTrans {
        private DataTable datTable;

        public ClipboardXmlTranse(DataTable datTable) {
            this.datTable = datTable;
        }

        public Object readFromNode(Element ele, KDF kdf) {
            return null;
        }

        public Element writeToNode(Object obj, KDF kdf) {
            if (!(obj instanceof KDTable)) {
                throw new IllegalArgumentException("support KDTable only");
            }
            KDTable table = (KDTable)obj;
            this.datTable.load(table, table.getSelectManager().toRange());
            return this.datTable.out(table, kdf);
        }
    }
}

