/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.ScrollTip;
import javax.swing.JScrollBar;

public class KDTLayoutInfo {
    public static final int NONE = 0;
    public static final int SPLITBAR = 1;
    public static final int SPLITLINE = 2;
    protected KDTable table;
    protected int index;
    protected int start;
    protected int span;
    protected int firstInAll = -1;
    protected int lastInAll = -1;
    protected int first = 0;
    protected int last = -1;
    protected int last2 = -1;
    protected boolean scrollable = false;
    protected JScrollBar scrollBar;
    protected ScrollTip toolTip;
    private boolean trackable = false;
    private int splitType = 0;
    protected boolean lockScroll = false;

    public KDTLayoutInfo(KDTable table) {
        this(table, false);
    }

    public KDTLayoutInfo(KDTable table, boolean scrollable) {
        this.scrollable = scrollable;
        this.table = table;
    }

    public JScrollBar getScrollBar() {
        return this.scrollBar;
    }

    public void setScrollBar(JScrollBar scrollBar) {
        if (this.scrollBar != null) {
            this.table.remove(this.scrollBar);
        }
        this.scrollBar = scrollBar;
        this.table.add(this.scrollBar);
        this.scrollBar.setVisible(false);
        this.scrollBar.setFocusable(false);
    }

    public boolean isTrackable() {
        return this.trackable;
    }

    public void setTrackable(boolean trackable) {
        this.trackable = trackable;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getSpan() {
        return this.span;
    }

    public void setSpan(int span) {
        this.span = span;
        this.invalidateLast();
    }

    public int getFirst() {
        return this.first;
    }

    public void setFirst(int first) {
        if (this.lockScroll) {
            return;
        }
        this.first = first;
        this.invalidateLast();
        this.refresh();
        JScrollBar sb = this.getScrollBar();
        if (sb != null && sb.getValue() != first) {
            sb.setValue(first);
        }
    }

    public void setLock(boolean bool) {
        this.lockScroll = bool;
    }

    public int getLast() {
        return this.last;
    }

    public boolean isCanRefresh() {
        return this.table == null || this.table.getDataRequestManager() == null || !this.table.getDataRequestManager().isExporting();
    }

    public int getLast2() {
        return this.last2;
    }

    public void invalidate() {
        this.setFirst(0);
        if (this.scrollBar != null) {
            this.scrollBar.setValue(0);
            this.scrollBar.setMaximum(0);
        }
    }

    public void invalidateLast() {
        this.last = -1;
        this.last2 = -1;
    }

    protected void refresh() {
    }

    boolean isEnable() {
        if (this.scrollBar != null) {
            return this.scrollBar.isEnabled();
        }
        return true;
    }

    void setScrollBarBounds(int x, int y, int width, int height) {
        if (this.scrollBar != null) {
            if (this.scrollBar.isEnabled()) {
                this.scrollBar.setBounds(x, y, width, height);
            } else {
                this.scrollBar.setBounds(x, y, 0, 0);
            }
        }
    }

    void setScrollBarValue(int value) {
        if (this.scrollBar != null && this.scrollBar.getValue() != value) {
            this.scrollBar.setValue(value);
        }
    }

    void setScrollBarMax(int max) {
        if (this.scrollBar != null && this.scrollBar.getMaximum() != max) {
            this.scrollBar.setMaximum(max);
        }
    }

    void setScrollBarBlock(int block) {
        if (this.scrollBar != null && this.scrollBar.getVisibleAmount() != block) {
            this.scrollBar.setBlockIncrement(block);
            this.scrollBar.setVisibleAmount(block);
        }
    }

    protected int getVisibleAmount() {
        return this.getLast2() - this.getFirst();
    }

    protected int getBlockIncrement() {
        return this.getLast2() - this.getFirst();
    }

    protected void adjustScrollBar(int pos) {
        int block;
        int visibleAmount;
        if (this.scrollBar == null) {
            return;
        }
        int firstInAll = this.getFirstInAll();
        int lastInAll = this.getLastInAll();
        if (lastInAll < 0) {
            lastInAll = 0;
        }
        if (this.scrollBar.getMinimum() != firstInAll) {
            this.scrollBar.setMinimum(firstInAll);
        }
        if (this.scrollBar.getMaximum() != lastInAll + 1) {
            this.scrollBar.setMaximum(lastInAll + 1);
        }
        if ((visibleAmount = this.getVisibleAmount()) != this.scrollBar.getVisibleAmount()) {
            this.scrollBar.setVisibleAmount(visibleAmount);
        }
        if ((block = this.getBlockIncrement()) != this.scrollBar.getBlockIncrement()) {
            block = block == 0 ? 1 : block;
            this.scrollBar.setBlockIncrement(block);
        }
        this.scrollBar.invalidate();
    }

    public int getSplitType() {
        return this.splitType;
    }

    public void setSplitType(int splitType) {
        this.splitType = splitType;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("======================");
        sb.append("index:" + this.index + "\n");
        sb.append("start:" + this.start + "\n");
        sb.append("span" + this.span + "\n");
        if (this.scrollBar == null) {
            sb.append("scrollBar:null\n");
        } else {
            sb.append("enable:" + this.scrollBar.isEnabled() + "  " + this.scrollBar.toString());
        }
        return sb.toString();
    }

    public Object clone() {
        return null;
    }

    public static JScrollBar createScrollBar(Class cls, int orientation) {
        JScrollBar sb = null;
        try {
            sb = (JScrollBar)cls.newInstance();
            sb.setOrientation(orientation);
        }
        catch (InstantiationException e) {
            sb = null;
        }
        catch (IllegalAccessException e) {
            sb = null;
        }
        return sb;
    }

    public ScrollTip getToolTip() {
        if (this.toolTip == null) {
            this.toolTip = new ScrollTip();
            this.toolTip.setParentComponent(this.table);
        }
        return this.toolTip;
    }

    public void setToolTip(ScrollTip toolTip) {
        this.toolTip = toolTip;
    }

    public int getFirstInAll() {
        return this.firstInAll;
    }

    public void setFirstInAll(int firstInAll) {
        this.firstInAll = firstInAll;
    }

    public int getLastInAll() {
        return this.lastInAll;
    }

    public void setLastInAll(int lastInAll) {
        this.lastInAll = lastInAll;
    }
}

