/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.kdf.table.BasicView;
import com.kingdee.bos.ctrl.kdf.table.KDTHorizon;
import com.kingdee.bos.ctrl.kdf.table.KDTLayoutInfo;
import com.kingdee.bos.ctrl.kdf.table.KDTVertical;
import com.kingdee.bos.ctrl.kdf.table.KDTViewManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.command.ICommand;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JScrollBar;

public class KDTLayoutManager
implements LayoutManager {
    private KDTable table;
    private Rectangle vSplitButtonRect = new Rectangle();
    private Rectangle hSplitButtonRect = new Rectangle();
    private Rectangle movingSplitBarRect;
    private boolean vSplitButtonVisible = true;
    private boolean hSplitButtonVisible = true;
    private ArrayList verticals = new ArrayList();
    private ArrayList horizons = new ArrayList();
    ArrayList commandList;
    boolean inCommandIterator = false;
    private boolean toolTipVisible = true;

    public KDTLayoutManager(KDTable table) {
        this.table = table;
    }

    public void addVertical(int vIndex, KDTVertical vertical) {
        vertical.setIndex(vIndex);
        this.verticals.add(vIndex, vertical);
        for (int i = vIndex + 1; i < this.verticals.size(); ++i) {
            ((KDTVertical)this.verticals.get(i)).setIndex(i);
        }
    }

    public void removeVertical(int vIndex) {
        KDTLayoutInfo info = (KDTLayoutInfo)this.verticals.remove(vIndex);
        this.table.remove(info.getScrollBar());
        for (int i = vIndex; i < this.verticals.size(); ++i) {
            ((KDTLayoutInfo)this.verticals.get(i)).setIndex(i);
        }
    }

    public void addHorizon(int hIndex, KDTHorizon horizon) {
        horizon.setIndex(hIndex);
        this.horizons.add(hIndex, horizon);
        for (int i = hIndex + 1; i < this.horizons.size(); ++i) {
            ((KDTHorizon)this.horizons.get(i)).setIndex(i);
        }
    }

    public void removeHorizon(int hIndex) {
        KDTLayoutInfo info = (KDTLayoutInfo)this.horizons.remove(hIndex);
        this.table.remove(info.getScrollBar());
        for (int i = hIndex; i < this.horizons.size(); ++i) {
            ((KDTLayoutInfo)this.horizons.get(i)).setIndex(i);
        }
    }

    public KDTVertical getVertical(int vIndex) {
        if (vIndex >= this.verticals.size()) {
            return null;
        }
        return (KDTVertical)this.verticals.get(vIndex);
    }

    public KDTHorizon getHorizon(int hIndex) {
        if (hIndex >= this.horizons.size()) {
            return null;
        }
        return (KDTHorizon)this.horizons.get(hIndex);
    }

    void invalidateHorizon() {
        for (int i = this.horizons.size() - 1; i >= 0; --i) {
            ((KDTHorizon)this.horizons.get(i)).invalidate();
        }
    }

    void invalidateHorizonLast() {
        for (int i = this.horizons.size() - 1; i >= 0; --i) {
            ((KDTHorizon)this.horizons.get(i)).invalidateLast();
        }
    }

    void invalidateVertical() {
        for (int i = this.verticals.size() - 1; i >= 0; --i) {
            ((KDTVertical)this.verticals.get(i)).invalidate();
        }
    }

    void invalidateVerticalLast() {
        for (int i = this.verticals.size() - 1; i >= 0; --i) {
            ((KDTVertical)this.verticals.get(i)).invalidateLast();
        }
    }

    void doUILayout() {
        int i;
        KDTLayoutInfo info;
        int vCount = this.table.getVerticalCount();
        int hCount = this.table.getHorizonCount();
        int start = 0;
        int span = 0;
        Rectangle rect = this.getContentBounds();
        boolean hasFoot = this.table.isHasFoot();
        if (hasFoot) {
            info = this.getVertical(vCount - 1);
            span = this.table.getFootManager().getFoot().getHeight();
            start = rect.height - span + rect.y - 1;
            if (info != null) {
                info.setStart(start);
                info.setSpan(span);
            }
            rect.height -= span;
            --vCount;
        }
        for (i = 0; i < vCount; ++i) {
            info = this.getVertical(i);
            if (i == 0) {
                start = rect.y;
                span = this.table.getHead().getHeight();
            } else {
                switch (this.getVertical(i - 1).getSplitType()) {
                    case 0: {
                        start += span;
                        if (info == null) break;
                        span = info.getSpan();
                        break;
                    }
                    case 1: {
                        start = start + span + 6;
                        if (info == null) break;
                        span = info.getSpan();
                        break;
                    }
                    case 2: {
                        start = start + span + 1;
                        if (info == null) break;
                        span = info.getSpan();
                    }
                }
            }
            if (i == vCount - 1 && start < rect.height) {
                span = rect.height - start;
            }
            if (info == null) continue;
            info.setStart(start);
            info.setSpan(span);
        }
        for (i = 0; i < hCount; ++i) {
            info = this.getHorizon(i);
            if (i == 0) {
                start = rect.x;
                span = this.table.getTreeColumn().getWidth();
            } else if (i == 1) {
                start += span;
                span = this.table.getIndexColumn().getWidth();
            } else {
                switch (this.getHorizon(i - 1).getSplitType()) {
                    case 0: {
                        start += span;
                        if (info == null) break;
                        span = info.getSpan();
                        break;
                    }
                    case 1: {
                        start = start + span + 6;
                        if (info == null) break;
                        span = info.getSpan();
                        break;
                    }
                    case 2: {
                        start = start + span + 1;
                        if (info == null) break;
                        span = info.getSpan();
                    }
                }
            }
            if (i == hCount - 1 && start < rect.width) {
                span = rect.width - start;
            }
            if (span < 0) {
                span = 0;
            }
            if (info == null) continue;
            info.setStart(start);
            info.setSpan(span);
        }
    }

    private Rectangle getContentBounds() {
        Rectangle rect = new Rectangle();
        Insets insets = this.table.getInsets();
        rect.y = insets.top;
        rect.x = insets.left;
        rect.height = this.table.getHeight() - insets.bottom;
        rect.width = this.table.getWidth() - insets.right;
        return rect;
    }

    private int getVerticalState() {
        int state = 0;
        switch (this.table.getScrollStateVertical()) {
            case 0: {
                state = this.getVerticalAutoState();
                break;
            }
            case 1: {
                state = 0;
                break;
            }
            case 2: {
                state = 1;
                break;
            }
        }
        return state;
    }

    private int getHorizonState() {
        int state = 0;
        switch (this.table.getScrollStateVertical()) {
            case 0: {
                state = this.getHorizonAutoState();
                break;
            }
            case 1: {
                state = 0;
                break;
            }
            case 2: {
                state = 1;
                break;
            }
        }
        return state;
    }

    private boolean isOutofVView(int szView, int beginRow) {
        int rowCount = this.table.getRowCount();
        if (rowCount == -1) {
            return true;
        }
        int szData = 0;
        for (int i = beginRow; i < rowCount; ++i) {
            int height = this.table.getBody().getRowHeight(i);
            if (height == -1) {
                return false;
            }
            if ((szData += height) <= szView) continue;
            return true;
        }
        return false;
    }

    private boolean isNoCols() {
        int colCount = this.table.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            if (this.table.getColumn(i).getStyleAttributes().isHided()) continue;
            return false;
        }
        return true;
    }

    private boolean isOutofHView(int szView, int beginCol) {
        int colCount = this.table.getColumnCount();
        int szData = 0;
        for (int i = beginCol; i < colCount; ++i) {
            int width = this.table.getColumns().getColumnWidth(i);
            if (width == -1) {
                return false;
            }
            if ((szData += width) <= szView) continue;
            return true;
        }
        return false;
    }

    private int getVerticalAutoState() {
        int vCount = this.table.getVerticalCount();
        int szView = 0;
        if (this.table.getViewManager().isFreeze()) {
            int row = this.table.getViewManager().getFreezeRow();
            try {
                KDTVertical ver = this.getVertical(1);
                if (ver != null) {
                    int freezeView = ver.getSpan();
                    int s = this.getHorizonAutoState();
                    if (s == 1) {
                        freezeView -= 17;
                    }
                    if (ver.getFirst() > row || this.isOutofVView(freezeView, row)) {
                        return 1;
                    }
                    return 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.table.isHasFoot()) {
            --vCount;
        }
        for (int i = 1; i < vCount; ++i) {
            if (this.getVertical(i).getFirst() > 0) {
                return 1;
            }
            szView = this.getVertical(i).getSpan();
            if (!this.isOutofVView(szView, 0)) continue;
            return 1;
        }
        if (this.isOutofVView(szView - 17, 0)) {
            return 2;
        }
        return 0;
    }

    private int getHorizonAutoState() {
        int hCount = this.table.getHorizonCount();
        int szView = 0;
        if (this.table.getViewManager().isFreeze()) {
            int col = this.table.getViewManager().getFreezeCol();
            try {
                KDTHorizon hori = this.getHorizon(3);
                if (hori != null) {
                    int freezeView = hori.getSpan();
                    if (hori.getFirst() > col || this.isOutofHView(freezeView, col)) {
                        return 1;
                    }
                    return 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (int i = 2; i < hCount; ++i) {
            if (this.isNoCols()) {
                return 0;
            }
            if (this.getHorizon(i).getFirst() > 0) {
                return 1;
            }
            szView = this.getHorizon(i).getSpan();
            if (!this.isOutofHView(szView, 0)) continue;
            return 1;
        }
        if (this.isOutofHView(szView - 17, 0)) {
            return 2;
        }
        return 0;
    }

    void adjustScrollBar() {
        int vs = this.getVerticalState();
        int hs = this.getHorizonState();
        if (!(vs == 1 && hs == 0 || vs == 0 && hs == 1)) {
            if (vs == 1 && hs != 0 || hs == 1 && vs != 0) {
                vs = 1;
                hs = 1;
            } else {
                vs = 0;
                hs = 0;
            }
        }
        this.adjustVScrollBar(vs);
        this.adjustHScrollBar(hs);
    }

    void adjustVScrollBar(int state) {
        if (0 == state) {
            this.setVScrollBarVisible(false);
        } else {
            int hCount = this.table.getHorizonCount();
            KDTHorizon info = this.getHorizon(hCount - 1);
            if (info != null) {
                int span = info.getSpan() - 17;
                info.setSpan(span);
            }
            this.setVScrollBarVisible(true);
        }
    }

    void adjustHScrollBar(int state) {
        if (0 == state) {
            this.setHScrollBarVisible(false);
        } else {
            int vCount = this.table.getVerticalCount();
            boolean hasFoot = this.table.isHasFoot();
            if (hasFoot) {
                KDTVertical info = this.getVertical(vCount - 2);
                if (info == null) {
                    return;
                }
                int span = info.getSpan() - 17;
                info.setSpan(span);
                info = this.getVertical(vCount - 1);
                int start = info.getStart() - 17;
                info.setStart(start);
            } else {
                KDTVertical info = this.getVertical(vCount - 1);
                if (info == null) {
                    return;
                }
                int span = info.getSpan() - 17;
                info.setSpan(span);
            }
            this.setHScrollBarVisible(true);
        }
    }

    void setVScrollBarVisible(boolean visible) {
        int vCount = this.table.getVerticalCount();
        for (int i = 1; i < vCount; ++i) {
            JScrollBar bar;
            KDTVertical info = this.getVertical(i);
            if (info == null || (bar = info.getScrollBar()) == null) continue;
            bar.setVisible(visible);
        }
    }

    void setHScrollBarVisible(boolean visible) {
        if (this.table.isAutoResize()) {
            visible = false;
        }
        int hCount = this.table.getHorizonCount();
        for (int i = 2; i < hCount; ++i) {
            JScrollBar bar;
            KDTHorizon info = this.getHorizon(i);
            if (info == null || (bar = info.getScrollBar()) == null) continue;
            bar.setVisible(visible);
        }
    }

    public void layout() {
        if (!this.table.enableRepaint) {
            return;
        }
        this.table.getRow(0);
        this.doUILayout();
        this.adjustScrollBar();
        int vCount = this.table.getVerticalCount();
        int hCount = this.table.getHorizonCount();
        KDTViewManager viewManager = this.table.getViewManager();
        int vStart = 0;
        int vSpan = 0;
        int hStart = 0;
        int hSpan = 0;
        int hStart2 = 0;
        int vStart2 = 0;
        for (int vIndex = 0; vIndex < vCount; ++vIndex) {
            KDTVertical vertical = this.getVertical(vIndex);
            if (vertical != null) {
                vStart = vertical.getStart();
                vSpan = vertical.getSpan();
            }
            for (int hIndex = 0; hIndex < hCount; ++hIndex) {
                Rectangle rect;
                int width;
                int left;
                int height;
                int top;
                KDTHorizon horizon = this.getHorizon(hIndex);
                if (horizon != null) {
                    hStart = horizon.getStart();
                    hSpan = horizon.getSpan();
                }
                BasicView view = viewManager.getView(vIndex, hIndex);
                view.setBounds(hStart, vStart, hSpan, vSpan);
                if (hIndex == hCount - 1) {
                    top = vStart;
                    height = vSpan;
                    left = hStart + hSpan;
                    width = 17;
                    if (vIndex == 1) {
                        top = this.table.getInsets().top;
                        height = vSpan + this.getVertical(0).getSpan();
                        if (this.isVSplitButtonVisible()) {
                            this.vSplitButtonRect.x = left;
                            this.vSplitButtonRect.y = top;
                            this.vSplitButtonRect.height = 6;
                            this.vSplitButtonRect.width = 17;
                            top += 6;
                            height -= 6;
                        } else {
                            this.vSplitButtonRect.x = 0;
                            this.vSplitButtonRect.y = 0;
                            this.vSplitButtonRect.width = 0;
                            this.vSplitButtonRect.height = 0;
                        }
                    }
                    if (vIndex == vCount - 2 && this.table.isHasFoot()) {
                        height += this.getVertical(vCount - 1).getSpan();
                    }
                    if (vertical != null && vertical.isEnable()) {
                        if (vStart2 != 0) {
                            height += top - vStart2;
                            top = vStart2;
                        }
                        if (this.table.getViewManager().isFreeze()) {
                            int col;
                            int row = this.table.getViewManager().getFreezeRow();
                            if (row > 0) {
                                height = this.getContentBounds().height;
                            }
                            if (this.getHorizonAutoState() == 1 && row > 0) {
                                height -= 17;
                            }
                            if ((col = this.table.getViewManager().getFreezeCol()) > 0) {
                                rect = this.getContentBounds();
                                left = rect.x + this.getContentBounds().width - 17;
                            }
                        }
                        vertical.setScrollBarBounds(left, top, width, height);
                        vStart2 = 0;
                    } else {
                        if (vStart2 == 0) {
                            vStart2 = top;
                        }
                        if (vertical != null) {
                            vertical.setScrollBarBounds(left, top, width, height);
                        }
                    }
                }
                if (vIndex != vCount - 1) continue;
                top = vStart + vSpan;
                height = 17;
                left = hStart;
                width = hSpan;
                if (hIndex == 2) {
                    width = hSpan + this.getHorizon(0).getSpan() + this.getHorizon(1).getSpan();
                    left = this.table.getInsets().left;
                }
                if (hIndex == hCount - 1) {
                    if (this.isHSplitButtonVisible()) {
                        this.hSplitButtonRect.x = hStart + hSpan - 6;
                        this.hSplitButtonRect.y = top;
                        this.hSplitButtonRect.height = 17;
                        this.hSplitButtonRect.width = 6;
                        width -= 6;
                    } else {
                        this.hSplitButtonRect.x = 0;
                        this.hSplitButtonRect.y = 0;
                        this.hSplitButtonRect.width = 0;
                        this.hSplitButtonRect.height = 0;
                    }
                }
                if (horizon != null && horizon.isEnable()) {
                    if (hStart2 != 0) {
                        width += left - hStart2;
                        left = hStart2;
                    }
                    if (this.table.getViewManager().isFreeze()) {
                        int row;
                        int col = this.table.getViewManager().getFreezeCol();
                        if (col > 0) {
                            width = this.getContentBounds().width;
                        }
                        if (this.getVerticalAutoState() == 1 && col > 0) {
                            width -= 17;
                        }
                        if ((row = this.table.getViewManager().getFreezeRow()) > 0) {
                            rect = this.getContentBounds();
                            top = rect.y + this.getContentBounds().height - 17;
                        }
                    }
                    horizon.setScrollBarBounds(left, top, width, height);
                    hStart2 = 0;
                    continue;
                }
                if (hStart2 == 0) {
                    hStart2 = left;
                }
                if (horizon == null) continue;
                horizon.setScrollBarBounds(left, top, width, height);
            }
        }
        this.doAfterLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAfterLayout() {
        if (this.commandList == null || this.commandList.isEmpty()) {
            return;
        }
        if (this.inCommandIterator) {
            return;
        }
        this.inCommandIterator = true;
        ArrayList arrayList = this.commandList;
        synchronized (arrayList) {
            for (ICommand command : this.commandList) {
                command.execute();
            }
            Iterator iter = null;
            this.commandList.clear();
        }
        this.inCommandIterator = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(ICommand command) {
        if (this.commandList == null) {
            this.commandList = new ArrayList();
        }
        ArrayList arrayList = this.commandList;
        synchronized (arrayList) {
            if (!this.commandList.contains(command)) {
                this.commandList.add(command);
            }
        }
    }

    public void layout_backup() {
        this.table.getRow(0);
        this.doUILayout();
        this.adjustScrollBar();
        int vCount = this.table.getVerticalCount();
        int hCount = this.table.getHorizonCount();
        KDTViewManager viewManager = this.table.getViewManager();
        for (int vIndex = 0; vIndex < vCount; ++vIndex) {
            KDTVertical vertical = this.getVertical(vIndex);
            int vStart = vertical.getStart();
            int vSpan = vertical.getSpan();
            for (int hIndex = 0; hIndex < hCount; ++hIndex) {
                int width;
                int left;
                int height;
                int top;
                KDTHorizon horizon = this.getHorizon(hIndex);
                int hStart = horizon.getStart();
                int hSpan = horizon.getSpan();
                BasicView view = viewManager.getView(vIndex, hIndex);
                view.setBounds(hStart, vStart, hSpan, vSpan);
                if (hIndex == hCount - 1) {
                    top = vStart;
                    height = vSpan;
                    left = hStart + hSpan;
                    width = 17;
                    if (vIndex == 1) {
                        top = this.table.getInsets().top;
                        height = vSpan + this.getVertical(0).getSpan();
                        if (this.isVSplitButtonVisible()) {
                            this.vSplitButtonRect.x = left;
                            this.vSplitButtonRect.y = top;
                            this.vSplitButtonRect.height = 6;
                            this.vSplitButtonRect.width = 17;
                            top += 6;
                            height -= 6;
                        } else {
                            this.vSplitButtonRect.x = 0;
                            this.vSplitButtonRect.y = 0;
                            this.vSplitButtonRect.width = 0;
                            this.vSplitButtonRect.height = 0;
                        }
                    }
                    vertical.setScrollBarBounds(left, top, width, height);
                }
                if (vIndex != vCount - 1) continue;
                top = vStart + vSpan;
                height = 17;
                left = hStart;
                width = hSpan;
                if (hIndex == 2) {
                    width = hSpan + this.getHorizon(0).getSpan() + this.getHorizon(1).getSpan();
                    left = this.table.getInsets().left;
                }
                if (hIndex == hCount - 1) {
                    if (this.isHSplitButtonVisible()) {
                        this.hSplitButtonRect.x = hStart + hSpan - 6;
                        this.hSplitButtonRect.y = top;
                        this.hSplitButtonRect.height = 17;
                        this.hSplitButtonRect.width = 6;
                        width -= 6;
                    } else {
                        this.hSplitButtonRect.x = 0;
                        this.hSplitButtonRect.y = 0;
                        this.hSplitButtonRect.width = 0;
                        this.hSplitButtonRect.height = 0;
                    }
                }
                horizon.setScrollBarBounds(left, top, width, height);
            }
        }
    }

    public void scrollToShow(int rowIndex, int colIndex) {
        this.scrollToShow(this.table.getViewManager().getDefaultActiveViewIndex(), rowIndex, colIndex);
    }

    public void scrollToShow(int viewIndex, int rowIndex, int colIndex) {
        int vIndex = this.table.getViewManager().getVerticalIndex(viewIndex);
        int hIndex = this.table.getViewManager().getHorizonIndex(viewIndex);
        KDTVertical vertical = this.getVertical(vIndex);
        vertical.scrollToShowRow(rowIndex);
        KDTHorizon horizon = this.getHorizon(hIndex);
        horizon.scrollToShowCol(colIndex);
    }

    public void scrollColToShow(int colIndex, int viewIndex) {
        int hIndex = this.table.getViewManager().getHorizonIndex(viewIndex);
        KDTHorizon horizon = this.getHorizon(hIndex);
        horizon.scrollToShowCol(colIndex);
    }

    public void scrollColToShow(int colIndex) {
        this.scrollColToShow(colIndex, this.table.getViewManager().getDefaultActiveViewIndex());
    }

    public void scrollRowToShow(int rowIndex, int viewIndex) {
        int vIndex = this.table.getViewManager().getVerticalIndex(viewIndex);
        KDTVertical vertical = this.getVertical(vIndex);
        vertical.scrollToShowRow(rowIndex);
    }

    public void scrollRowToShow(int rowIndex) {
        this.scrollRowToShow(rowIndex, this.table.getViewManager().getDefaultActiveViewIndex());
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int hHead = this.table.getHead().getHeight();
        int hBody = this.table.getBody().getHeight();
        int wBody = this.table.getColumns().getWidth();
        int height = 0;
        int width = 0;
        if (hHead <= 0 && hBody <= 0) {
            height = 0;
        } else {
            if (hBody <= 0) {
                hBody = this.table.getDefaultRowHeight();
            }
            if (hHead <= 0) {
                hHead = 0;
            }
            int hInset = this.table.getInsets().top;
            int hScrollBar = 17;
            height = hInset + hHead + hBody + hScrollBar;
        }
        if (wBody <= 0) {
            width = 0;
        } else {
            int wInset = this.table.getInsets().left;
            int wIndex = this.table.getIndexColumn().getWidth();
            int wScrollBar = 17;
            width = wInset + wIndex + wBody + wScrollBar;
        }
        return new Dimension(width, height);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.layout();
    }

    public Rectangle getHSplitButtonRect() {
        return this.hSplitButtonRect;
    }

    public Rectangle getVSplitButtonRect() {
        return this.vSplitButtonRect;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("vertical:\n");
        for (i = 0; i < this.verticals.size(); ++i) {
            sb.append(this.verticals.get(i).toString());
        }
        sb.append("horizon:\n");
        for (i = 0; i < this.horizons.size(); ++i) {
            sb.append(this.horizons.get(i).toString());
        }
        return sb.toString();
    }

    public boolean isHSplitButtonVisible() {
        return this.hSplitButtonVisible;
    }

    public void setHSplitButtonVisible(boolean splitButtonVisible) {
        if (this.hSplitButtonVisible != splitButtonVisible) {
            this.hSplitButtonVisible = splitButtonVisible;
            this.table.reLayoutAndPaint();
        }
    }

    public boolean isVSplitButtonVisible() {
        return this.vSplitButtonVisible;
    }

    public void setVSplitButtonVisible(boolean splitButtonVisible) {
        if (this.vSplitButtonVisible != splitButtonVisible) {
            this.vSplitButtonVisible = splitButtonVisible;
            this.table.reLayoutAndPaint();
        }
    }

    public Rectangle getMovingSplitBarRect() {
        return this.movingSplitBarRect;
    }

    public void setMovingSplitBarRect(Rectangle movingSplitBarRect) {
        this.movingSplitBarRect = movingSplitBarRect;
    }

    public void setVerticalScrollBar(JScrollBar sb) {
        KDTVertical info = this.getVertical(1);
        ((KDTLayoutInfo)info).setScrollBar(sb);
        this.table.repaint();
    }

    public void setHorizonScrollBar(JScrollBar sb) {
        KDTHorizon info = this.getHorizon(2);
        ((KDTLayoutInfo)info).setScrollBar(sb);
        this.table.repaint();
    }

    public void setToolTipVisible(boolean b) {
        this.toolTipVisible = b;
    }

    public boolean isToolTipVisible() {
        return this.toolTipVisible;
    }
}

