/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.export.POIXlsExporter;
import com.kingdee.bos.ctrl.kdf.table.DataTable;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IDataConvert;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellValueParse;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.io.Writer;
import java.math.BigDecimal;

public class StringTable {
    protected String content = null;
    private static String booleanValueTrue = LanguageManager.getLangMessage((String)"BooleanValueTrue", POIXlsExporter.class, (String)"true");
    private static String booleanValueFalse = LanguageManager.getLangMessage((String)"BooleanValueFalse", POIXlsExporter.class, (String)"false");
    private IDataConvert<Object, Object> loadCellConvert;
    private IDataConvert<String, Object> saveCellConvert;
    private KDTable table;

    public void save(Writer charStream) {
        try {
            charStream.write(this.content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean load(DataTable datTable, int mode) {
        this.content = null;
        if (datTable == null) {
            return false;
        }
        int nRow = datTable.getRowCount();
        int nCol = datTable.getColCount();
        StringBuffer buf = new StringBuffer(nRow * nCol * 3);
        for (int r = 0; r < nRow; ++r) {
            KDTRow kr = datTable.getRow(r);
            for (int c = 0; c < nCol; ++c) {
                KDTCell kc = kr.getCell(c);
                Object value = this.convertLoadCell(this.getCellValueByMode(kc, mode), r, c);
                if (value instanceof Boolean) {
                    Object object = value = (Boolean)value != false ? booleanValueTrue : booleanValueFalse;
                }
                if (this.table.getIsDesensitization() && kc != null) {
                    value = this.table.desensitizationCell(kc.getIndex().getColIndex(), value);
                }
                buf.append(value);
                if (c == nCol - 1) continue;
                buf.append('\t');
            }
            buf.append('\n');
        }
        if (buf.length() > 0) {
            this.content = buf.toString().substring(0, buf.lastIndexOf("\n"));
        }
        return true;
    }

    public boolean load(DataTable datTable, KDTable table) {
        this.table = table;
        return this.load(datTable, table.getCellDisplayMode());
    }

    public void load(String str) {
        this.content = (String)this.convertLoadCell(str, -1, -1);
    }

    private Object getCellValueByMode(KDTCell cell, int mode) {
        Object res = null;
        if (cell != null) {
            switch (mode) {
                case 1: {
                    res = cell.getExpressions();
                    if (res != null) break;
                    res = this.getCellFormattedValue(cell);
                    break;
                }
                case 0: {
                    res = this.getCellFormattedValue(cell);
                    break;
                }
                case 2: {
                    res = cell.getExpressions();
                    break;
                }
                default: {
                    res = this.getCellFormattedValue(cell);
                    if (res != null) break;
                    res = cell.getExpressions();
                }
            }
        }
        if (res == null) {
            res = "";
        }
        return res;
    }

    private Object getCellFormattedValue(KDTCell cell) {
        Object value = cell.getFormattedValue();
        if (value == null) {
            value = cell.getValue();
        }
        return value;
    }

    public boolean save(KDTable table, int startRow, int startCol) {
        if (this.content == null || table == null || startRow < 0 || startCol < 0) {
            return false;
        }
        int row = startRow;
        int col = startCol;
        TableWalker tw = new TableWalker(table);
        StringWalker sw = new StringWalker(this.content);
        ICellEditor editor = table.getCellEditor(row, col);
        boolean isNumberEditor = editor != null && editor.getComponent() instanceof KDFormattedTextField;
        boolean isInBracket = false;
        while (sw.hasNext()) {
            char ch = sw.nextChar();
            if (ch == '\t') {
                isInBracket = false;
                tw.setValueAt(row, col, this.convertSaveCell(sw.separate(false, isNumberEditor), row, col));
                ++col;
                continue;
            }
            if (ch == '\n') {
                if (!isInBracket) {
                    tw.setValueAt(row, col, this.convertSaveCell(sw.separate(false, isNumberEditor), row, col));
                    ++row;
                    col = startCol;
                    continue;
                }
                sw.setAdvancedMod(true);
                continue;
            }
            if (sw.isEnd()) {
                tw.setValueAt(row, col, this.convertSaveCell(sw.separate(true, isNumberEditor), row, col));
                continue;
            }
            if (ch != '\"') continue;
            isInBracket = !isInBracket;
        }
        sw.cleanup();
        tw.cleanup();
        return true;
    }

    public KDTSelectBlock preSave(KDTable table, int startRow, int startCol) {
        int col;
        if (this.content == null || table == null || startRow < 0 || startCol < 0) {
            return null;
        }
        int row = startRow;
        int maxCol = col = startCol;
        TableWalker tw = new TableWalker(table);
        StringWalker sw = new StringWalker(this.content);
        boolean isInBracket = false;
        while (sw.hasNext()) {
            char ch = sw.nextChar();
            if (ch == '\t') {
                isInBracket = false;
                maxCol = ++col;
                continue;
            }
            if (ch == '\n') {
                if (!isInBracket) {
                    ++row;
                    col = startCol;
                    continue;
                }
                sw.setAdvancedMod(true);
                continue;
            }
            if (sw.isEnd() || ch != '\"') continue;
            isInBracket = !isInBracket;
        }
        sw.cleanup();
        tw.cleanup();
        KDTSelectBlock block = new KDTSelectBlock(startRow, startCol, row, maxCol);
        return block;
    }

    private static String parserNumberString(String source) {
        if (StringUtil.isEmptyString((String)source)) {
            return source;
        }
        String number = source.trim();
        if (StringUtil.isEmptyString((String)number)) {
            return source;
        }
        if (number.charAt(0) == '(' && number.charAt(number.length() - 1) == ')') {
            if ((number = number.substring(1, number.length() - 1)).length() > 1 && number.charAt(0) != '-') {
                number = "-" + number;
            } else {
                return source;
            }
        }
        if ((number = number.trim()).lastIndexOf(",") == -1) {
            if (number.lastIndexOf("E") == -1) {
                try {
                    new BigDecimal(number);
                }
                catch (NumberFormatException e) {
                    return source;
                }
                return number;
            }
            BigDecimal bd = null;
            try {
                bd = new BigDecimal(number);
            }
            catch (NumberFormatException e) {
                return source;
            }
            if (bd != null) {
                number = CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)bd);
            }
            return number;
        }
        number = number.replaceAll(",", "");
        try {
            new BigDecimal(number);
        }
        catch (NumberFormatException e) {
            return source;
        }
        int pos0 = number.lastIndexOf(".");
        String sub = number;
        if (pos0 == -1) {
            pos0 = 0;
        } else {
            sub = number.substring(0, pos0);
        }
        char[] chars = sub.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[chars.length - i - 1];
            if (c != ',' || (i + 1) % 4 == 0) continue;
            return source;
        }
        return number;
    }

    public static String parserKilobitSeparator(String res) {
        if (res.lastIndexOf(",") == -1) {
            String number = res.trim();
            try {
                new BigDecimal(number);
            }
            catch (NumberFormatException e) {
                return res;
            }
            return number;
        }
        String number = res.replaceAll(",", "").trim();
        try {
            new BigDecimal(number);
        }
        catch (NumberFormatException e) {
            return res;
        }
        int pos0 = res.lastIndexOf(".");
        String sub = res;
        if (pos0 == -1) {
            pos0 = 0;
        } else {
            sub = res.substring(0, pos0);
        }
        char[] chars = sub.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[chars.length - i - 1];
            if (c != ',' || (i + 1) % 4 == 0) continue;
            return res;
        }
        return number;
    }

    public void setSaveConverter(IDataConvert<String, Object> converter) {
        this.saveCellConvert = converter;
    }

    public void setLoadConverter(IDataConvert<Object, Object> converter) {
        this.loadCellConvert = converter;
    }

    public Object convertLoadCell(Object obj, int row, int col) {
        if (null != this.loadCellConvert) {
            return this.loadCellConvert.convert(obj, row, col);
        }
        return obj;
    }

    public Object convertSaveCell(String obj, int row, int col) {
        if (null != this.saveCellConvert) {
            return this.saveCellConvert.convert(obj, row, col);
        }
        return obj;
    }

    class TableWalker {
        private KDTable table;
        private int curRow;
        private int curCol;
        private IRow curIRow;
        private ICell curICell;

        public TableWalker(KDTable tbl) {
            this.cleanup();
            this.table = tbl;
        }

        public ICell goTo(int row, int col) {
            if (this.curRow != row || this.curIRow == null) {
                this.curRow = row;
                this.curICell = null;
                this.curIRow = this.table.getRow(this.curRow);
            }
            if (this.curIRow == null) {
                this.curICell = null;
            } else if (this.curCol != col || this.curICell == null) {
                this.curCol = col;
                this.curICell = this.curIRow.getCell(this.curCol);
            }
            return this.curICell;
        }

        public boolean setValueAt(int row, int col, Object value) {
            ICell ic = this.goTo(row, col);
            if (ic != null && !ic.getStyle().isLocked()) {
                String sv;
                if (value != null && (sv = value.toString().trim()).length() > 1 && sv.charAt(0) == '=' && sv.charAt(1) != '=') {
                    ic.setExpressions(sv);
                    return true;
                }
                ICellEditor editor = this.table.getCellEditor(row, col);
                Object newValue = null;
                if (editor instanceof ICellValueParse) {
                    boolean onlyreturn = false;
                    boolean flag = false;
                    if (editor.getComponent() instanceof KDPromptBox) {
                        flag = true;
                        onlyreturn = ((KDBizPromptBox)editor.getComponent()).isOnlyReturn();
                        ((KDBizPromptBox)editor.getComponent()).setOnlyReturn(true);
                    }
                    Object result = ((ICellValueParse)((Object)editor)).parseValue(value);
                    if (flag) {
                        ((KDBizPromptBox)editor.getComponent()).setOnlyReturn(onlyreturn);
                    }
                    if (result == ICellValueParse.ParseError) {
                        return false;
                    }
                    newValue = result;
                } else {
                    newValue = value;
                }
                Object oldValue = ic.getValue();
                if (null != editor.getComponent()) {
                    if (this.table.isPasteF7Block()) {
                        ic.setValue(newValue instanceof Object[] ? ((Object[])newValue)[0] : newValue);
                    } else {
                        ic.setValue(newValue);
                    }
                    int type = ((KDTable.XCell)ic).index.getType();
                    KDTEditEvent editEvent = new KDTEditEvent(this.table, oldValue, newValue, row, col, false, type);
                    this.fireEditStopped(editEvent);
                } else {
                    ic.setValue(newValue);
                }
                return true;
            }
            return false;
        }

        public void fireEditStopped(KDTEditEvent e) {
            Object[] listeners = this.table.getListenerList().getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != KDTEditListener.class) continue;
                ((KDTEditListener)listeners[i + 1]).editStopped(e);
            }
        }

        public void cleanup() {
            this.table = null;
            this.curRow = -1;
            this.curCol = -1;
            this.curIRow = null;
            this.curICell = null;
        }
    }

    class StringWalker {
        private char[] stringValue;
        private int lastPos;
        private int curPos;
        private int len;
        private boolean isAdvancedMod;

        public StringWalker(String target) {
            this.cleanup();
            this.stringValue = target.toCharArray();
            this.len = this.stringValue.length;
        }

        public void cleanup() {
            this.stringValue = null;
            this.lastPos = 0;
            this.curPos = 0;
            this.len = 0;
            this.isAdvancedMod = false;
        }

        public void setAdvancedMod(boolean isAdvance) {
            this.isAdvancedMod = isAdvance;
        }

        public boolean hasNext() {
            return this.curPos < this.len;
        }

        public boolean isEnd() {
            return this.curPos == this.len;
        }

        public char nextChar() {
            return this.stringValue[this.curPos++];
        }

        public char previousChar() {
            return this.stringValue[--this.curPos];
        }

        public String separate(boolean isIncludeTail, boolean isNumberEditor) {
            int endPos;
            String res = null;
            int n = endPos = isIncludeTail ? this.curPos : this.curPos - 1;
            if (this.isAdvancedMod && this.stringValue[this.lastPos] == '\"' && this.stringValue[endPos - 1] == '\"') {
                ++this.lastPos;
                StringBuffer buf = new StringBuffer(--endPos - this.lastPos);
                while (this.lastPos < endPos) {
                    char ch;
                    if ((ch = this.stringValue[this.lastPos++]) == '\"' && this.lastPos < endPos && this.stringValue[this.lastPos++] != '\"') {
                        --this.lastPos;
                    }
                    buf.append(ch);
                }
                res = buf.toString();
            } else {
                res = new String(this.stringValue, this.lastPos, endPos - this.lastPos);
            }
            this.lastPos = this.curPos;
            this.isAdvancedMod = false;
            if (isNumberEditor) {
                res = StringTable.parserNumberString(res);
            }
            return res;
        }
    }
}

