/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.util;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteTreeCtrl;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteDistributionUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class NoteRoleUseUtil {
    public static final String USE_ENABLED_ROLES = "user_enabled_roles";

    private static HashMap getMapAttr(IBizContent bizCtn, String absPathText) throws KDRSException {
        HashMap attrs = bizCtn.getAttributes(absPathText, new String[]{USE_ENABLED_ROLES});
        return attrs;
    }

    private static String getStringAttr(HashMap attrs) {
        String strUsers = (String)attrs.get(USE_ENABLED_ROLES);
        return strUsers;
    }

    public static void modifyAttr(NoteTreeCtrl noteTreeCtrl, String absPathText, String[] targetRoles, boolean isToAdd) throws KDRSException {
        IBizContent bizCtn = noteTreeCtrl.getBizContent();
        HashMap attrs = NoteRoleUseUtil.getMapAttr(bizCtn, absPathText);
        String strUsers = NoteRoleUseUtil.getStringAttr(attrs);
        HashSet<String> sets = new HashSet<String>();
        if (!CtrlUtil.Str.isEmptyString((String)strUsers)) {
            String[] users = CtrlUtil.Str.splitString((String)strUsers, (String)",");
            for (int i = 0; i < users.length; ++i) {
                sets.add(users[i]);
            }
        }
        for (int i = 0; i < targetRoles.length; ++i) {
            if (isToAdd) {
                if (StringUtil.isEmptyString((String)targetRoles[i])) continue;
                sets.add(targetRoles[i]);
                continue;
            }
            sets.remove(targetRoles[i]);
        }
        Object[] users = new String[sets.size()];
        sets.toArray(users);
        strUsers = CtrlUtil.Array.objectArray2String((Object[])users, (String)",");
        attrs.put(USE_ENABLED_ROLES, strUsers);
        bizCtn.setAttributes(absPathText, attrs);
    }

    public static String getStringAttr(IBizContent bizCtn, String absPathText) throws KDRSException {
        HashMap attrs = NoteRoleUseUtil.getMapAttr(bizCtn, absPathText);
        return NoteRoleUseUtil.getStringAttr(attrs);
    }

    public static void removeDistributed(NoteTreeCtrl noteTreeCtrl, String absPathText, String targetUser) throws KDRSException {
        NoteRoleUseUtil.modifyAttr(noteTreeCtrl, absPathText, targetUser, false);
    }

    public static void removeAllDistributed(NoteTreeCtrl noteTreeCtrl, String absPathText) throws KDRSException {
        IBizContent bizCtn = noteTreeCtrl.getBizContent();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put(USE_ENABLED_ROLES, null);
        bizCtn.setAttributes(absPathText, attrs);
    }

    private static void modifyAttr(NoteTreeCtrl noteTreeCtrl, String absPathText, String targetUser, boolean isToAdd) throws KDRSException {
        NoteRoleUseUtil.modifyAttr(noteTreeCtrl, absPathText, new String[]{targetUser}, isToAdd);
    }

    public static boolean isCanUse(IBizContent bizCtn, String absPathText) throws KDRSException {
        HashMap attrs = NoteRoleUseUtil.getMapAttr(bizCtn, absPathText);
        String currentUser = NoteUtil.getUser();
        String roles = (String)attrs.get(USE_ENABLED_ROLES);
        if (StringUtil.isEmptyString((String)roles)) {
            return true;
        }
        Set usersSet = NoteDistributionUtil.usersStr2Set(roles);
        return usersSet.contains(currentUser);
    }

    public static boolean isCanPrint(Component parentCtrl, IBizContent bizCtn, String templatePath) throws KDRSException {
        String absDir = PathUtil.makeChildPath((String)"/EAS_Note.kdrs", (String)templatePath);
        if (!NoteRoleUseUtil.isCanUse(bizCtn, absDir)) {
            HashMap attrs = bizCtn.getAttributes(absDir, new String[]{"alias", "name"});
            String alias = (String)attrs.get("alias");
            String templatName = (String)attrs.get("name");
            if (!StringUtil.isEmptyString((String)alias)) {
                templatName = alias + "\uff08" + templatName + "\uff09";
            }
            WindowUtil.msgboxWarning((Object)(MultiLanguageUtil.getMLS("util.NoteUseUtil.cantPrintInfo1") + templatName + MultiLanguageUtil.getMLS("util.NoteUseUtil.cantPrintInfo2") + StringUtil.RETURN + MultiLanguageUtil.getMLS("util.NoteUseUtil.cantPrintInfo3")), (String)MultiLanguageUtil.getMLS("util.NoteUseUtil.title"), (Component)parentCtrl);
            return false;
        }
        return true;
    }
}

