/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.integrate;

import com.kingdee.bos.ctrl.common.restype.def.ResTypeDef;
import com.kingdee.bos.ctrl.common.ui.tree.INodeFilter;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUI;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteTreeCtrl;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteDataUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IBizContext;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IContextSupplier;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.RuntimeModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class TemplatesTree {
    public static final Logger log = LogUtil.getPackageLogger(TemplatesTree.class);
    public static final String ModelChanged = "ModelChanged";
    private EventListenerList _listenerList = new EventListenerList();
    protected NoteTreeCtrl _tree;
    private IBizContent _bizContent;
    private String _lastTemplatePath;

    public JComponent getCtrl() {
        return this._tree.getTreeUI();
    }

    public void setContext(IBizContext bizCtx) throws KDRSException {
        this._bizContent = bizCtx.getBizContent();
        this.createTreeCtrl(bizCtx);
    }

    protected void createTreeCtrl(final IBizContext bizCtx) throws KDRSException {
        IContextSupplier supplier = new IContextSupplier(){

            public IBizContext getContext() {
                return bizCtx;
            }
        };
        this._tree = new NoteTreeCtrl(supplier, null, true);
        this._tree.setRelativeRoot("/EAS_Note.kdrs");
        this._tree.setNodeFitler(new FileFilter());
        TreeUI ui = this._tree.getTreeUI();
        ui.setRealtimeSelect(true);
        ui.addTreeSelectionListener((TreeSelectionListener)new TreeSelectionHandler());
    }

    public void setNoteType(String noteType) {
        this._tree.setPathTextToShow(noteType);
        this.expandPath(noteType);
        this._tree.getTreeUI().setSelectionPathText(noteType);
    }

    private void expandPath(String noteType) {
        this._tree.getTreeUI().expandRoot();
        TreeUINode treeUINode = this._tree.getTreeUI().getRootNode();
        String[] pathNodeNames = PathUtil.splitPath((String)noteType);
        block0: for (int i = 0; i < pathNodeNames.length; ++i) {
            int c = treeUINode.getChildCount();
            for (int j = 0; j < c; ++j) {
                TreeUINode childNode = (TreeUINode)treeUINode.getChildAt(j);
                if (!StringUtil.equals((String)childNode.getName(), (String)pathNodeNames[i])) continue;
                treeUINode = childNode;
                this._tree.getTreeUI().expand(new TreePath(treeUINode.getPath()));
                continue block0;
            }
        }
    }

    public String getCurrentTemplatePathText() {
        return this._lastTemplatePath;
    }

    private String getSelectionPathText() {
        return this._tree.getTreeUI().getSelectionPathText();
    }

    private String getSelectionAbsPathText() {
        return PathUtil.makeChildPath((String)this._tree.getRelativeRoot(), (String)this._tree.getTreeUI().getSelectionPathText());
    }

    void addPropertyChangeListener(PropertyChangeListener l) {
        this._listenerList.add(PropertyChangeListener.class, l);
    }

    void removePropertyChangeListener(PropertyChangeListener l) {
        this._listenerList.remove(PropertyChangeListener.class, l);
    }

    protected void firePropertyChange(RuntimeModel runtimeModel) {
        PropertyChangeEvent event = null;
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 1; i >= 0; i -= 2) {
            if (listeners[i - 1] != PropertyChangeListener.class) continue;
            if (event == null) {
                event = new PropertyChangeEvent(this, ModelChanged, null, runtimeModel);
            }
            PropertyChangeListener l = (PropertyChangeListener)listeners[i];
            l.propertyChange(event);
        }
    }

    private static class FileFilter
    implements INodeFilter {
        private FileFilter() {
        }

        public boolean isVisibleCategory(Object category) {
            boolean isFolder = StringUtil.equals((String)"folder", (String)category.toString());
            boolean isTargetFile = StringUtil.equals((String)"r1-print", (String)category.toString());
            return isFolder || isTargetFile;
        }

        public boolean isVisibleText(String text) {
            return true;
        }
    }

    private class TreeSelectionHandler
    implements TreeSelectionListener {
        private TreeSelectionHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            RuntimeModel runtimeModel;
            long t = System.currentTimeMillis();
            TreeUINode stn = (TreeUINode)e.getPath().getLastPathComponent();
            String category = ((ResTypeDef)stn.getCategory()).getName();
            if (!StringUtil.equals((String)"r1-print", (String)category)) {
                return;
            }
            TemplatesTree.this._lastTemplatePath = TemplatesTree.this.getSelectionPathText();
            byte[] bytes = null;
            String path = TemplatesTree.this.getSelectionAbsPathText();
            try {
                bytes = TemplatesTree.this._bizContent.readTemplate(path);
            }
            catch (KDRSException e1) {
                log.error((Object)"\u8bfb\u53d6\u6a21\u677f\u5931\u8d25", (Throwable)e1);
            }
            if (bytes == null || bytes.length == 0) {
                return;
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            NoteDataUtil.R1RuntimeDsInfoCreator rtDsInfoCreator = new NoteDataUtil.R1RuntimeDsInfoCreator(new NoteDataUtil.DefaultReferenceResourceLoader(TemplatesTree.this._bizContent), TemplatesTree.this.getSelectionPathText());
            try {
                runtimeModel = KDNoteHelper.loadR1Model(inputStream, null, rtDsInfoCreator);
            }
            catch (R1Exception e1) {
                log.error((Object)"\u89e3\u6790\u6a21\u677f\u5931\u8d25", (Throwable)e1);
                return;
            }
            TemplatesTree.this.firePropertyChange(runtimeModel);
            if (log.isDebugEnabled()) {
                log.debug((Object)("token:" + (System.currentTimeMillis() - t)));
            }
        }
    }
}

