/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.preview;

import com.kingdee.bos.ctrl.print.KDPreview;
import com.kingdee.bos.ctrl.print.resource.Resources;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFrame;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class PreviewWindow
extends WindowAdapter {
    KDPreview preview;
    private Window display;

    public PreviewWindow(KDPreview preview) {
        this.preview = preview;
    }

    public void showFrame(KDPreview previewUI, String title, Image icon) {
        this.display = new PreviewFrame(PreviewWindow.toTitle(title));
        Image tIcon = PreviewWindow.toIcon(icon);
        if (tIcon != null) {
            ((JFrame)this.display).setIconImage(icon);
        }
        ((PreviewFrame)((Object)this.display)).addWindowStateListener(this);
        ((PreviewFrame)((Object)this.display)).addWindowListener(this);
        ((JFrame)this.display).setDefaultCloseOperation(2);
        ((JFrame)this.display).setExtendedState(6);
        ((PreviewFrame)((Object)this.display)).addToolBar((JToolBar)previewUI.getPreviewBar().getToolBar());
        ((PreviewFrame)((Object)this.display)).setPreviewContent(previewUI.getPreviewBody());
        ((PreviewFrame)((Object)this.display)).setStatusBar(previewUI.getStatusBar());
        ((PreviewFrame)((Object)this.display)).showPreviewWindow();
        previewUI.firstShow();
    }

    public void showFrame(KDPreview ui, String title) {
        this.showFrame(ui, title, null);
    }

    public void showDialog(KDPreview previewUI, Component parent, String title, boolean modal) {
        Window temp = null;
        if (parent instanceof Frame) {
            temp = (Frame)parent;
        } else if (parent instanceof Dialog) {
            temp = (Dialog)parent;
        } else if (parent instanceof JComponent) {
            temp = SwingUtilities.getWindowAncestor(parent);
        }
        if (temp == null) {
            this.display = new PreviewDialog();
            ((PreviewDialog)((Object)this.display)).setTitle(PreviewWindow.toTitle(title));
        } else if (temp instanceof Frame) {
            this.display = new PreviewDialog((Frame)temp, PreviewWindow.toTitle(title), modal);
        } else if (temp instanceof Dialog) {
            this.display = new PreviewDialog((Dialog)temp, PreviewWindow.toTitle(title), modal);
        }
        ((PreviewDialog)((Object)this.display)).setDefaultCloseOperation(2);
        ((PreviewDialog)((Object)this.display)).addWindowStateListener(this);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(temp.getGraphicsConfiguration());
        Rectangle desktopBounds = new Rectangle(screenInsets.left, screenInsets.top, screenSize.width - screenInsets.left - screenInsets.right, screenSize.height - screenInsets.top - screenInsets.bottom);
        ((PreviewDialog)((Object)this.display)).addWindowListener(this);
        ((PreviewDialog)((Object)this.display)).addToolBar((JToolBar)previewUI.getPreviewBar().getToolBar());
        ((PreviewDialog)((Object)this.display)).setPreviewContent(previewUI.getPreviewBody());
        ((PreviewDialog)((Object)this.display)).setStatusBar(previewUI.getStatusBar());
        Dimension dim = new Dimension(desktopBounds.width, desktopBounds.height);
        ((PreviewDialog)((Object)this.display)).setSize(dim.width, dim.height);
        ((PreviewDialog)((Object)this.display)).setLocation(desktopBounds.x, desktopBounds.y);
        ((PreviewDialog)((Object)this.display)).setResizable(true);
        previewUI.firstShow();
        ((PreviewDialog)((Object)this.display)).showPreviewWindow();
    }

    public void showDialog(KDPreview ui, Component parent, String title) {
        this.showDialog(ui, parent, title, true);
    }

    private static String toTitle(String title) {
        if (title != null && title.length() > 0) {
            return title;
        }
        return Resources.getMsg("dialog.printpreview");
    }

    private static Image toIcon(Image icon) {
        if (icon != null) {
            return icon;
        }
        return null;
    }

    public void dispose() {
        if (this.display != null) {
            this.display.dispose();
            this.display = null;
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.preview.getPrinter().closePreview();
    }

    static class PreviewDialog
    extends KDDialog
    implements IPreviewWindow {
        private static final long serialVersionUID = 1592908557559406521L;

        public PreviewDialog() {
        }

        public PreviewDialog(Dialog owner) {
            super(owner);
        }

        public PreviewDialog(Dialog owner, boolean modal) {
            super(owner, modal);
        }

        public PreviewDialog(Dialog owner, String title) {
            super(owner, title);
        }

        public PreviewDialog(Dialog owner, String title, boolean modal) {
            super(owner, title, modal);
        }

        public PreviewDialog(Frame owner) {
            super(owner);
        }

        public PreviewDialog(Frame owner, boolean modal) {
            super(owner, modal);
        }

        public PreviewDialog(Frame owner, String title) {
            super(owner, title);
        }

        public PreviewDialog(Frame owner, String title, boolean modal) {
            super(owner, title, modal);
        }

        @Override
        public void showPreviewWindow() {
            this.show();
        }

        @Override
        public void setPreviewContent(JComponent p) {
            this.setContentPane(p);
        }
    }

    static class PreviewFrame
    extends KDFrame
    implements IPreviewWindow {
        private static final long serialVersionUID = 1617043190863011400L;

        @Override
        public void showPreviewWindow() {
            this.show();
        }

        public PreviewFrame() {
        }

        public PreviewFrame(String title) {
            super(title);
        }

        @Override
        public void setPreviewContent(JComponent p) {
            this.setContentPane(p);
        }
    }

    static interface IPreviewWindow {
        public void showPreviewWindow();

        public void setPreviewContent(JComponent var1);
    }
}

