/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.printjob;

import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.config.extendui.ImageSetupModel;
import com.kingdee.bos.ctrl.print.control.PaperInfo;
import com.kingdee.bos.ctrl.print.printjob.AbstractPrintJob;
import com.kingdee.bos.ctrl.print.ui.component.DimensionFloat;
import com.kingdee.bos.ctrl.print.ui.component.ImageCell;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ImagePrintJob
extends AbstractPrintJob {
    ImageSetupModel configmodel;
    private Image[] images;

    public ImagePrintJob(ImageSetupModel configmodel, Image[] images) {
        this.setConfigModel(configmodel);
        this.setImages(images);
    }

    public void setImages(Image[] images) {
        this.images = images;
    }

    public void setConfigModel(ImageSetupModel model) {
        this.configmodel = model;
    }

    @Override
    public boolean isEmpty() {
        return this.images == null || this.images.length == 0;
    }

    @Override
    public void rePagination() {
        super.rePagination();
        this.preparePagination();
    }

    @Override
    public void preparePagination() {
        super.preparePagination();
        this.calculatePageCount(this.getPaperInfo());
    }

    @Override
    public Paper getPaper(int index) {
        return this.createPaper(index);
    }

    @Override
    public Page getPage(int index) {
        Page page = super.getPage(index);
        if (page == null && index < this.pageCount) {
            page = new Page();
            ImageCell cell = null;
            DimensionFloat size = this.getPaperInfo().getPaintableSize();
            int mode = this.configmodel.getMode();
            int hAlign = this.configmodel.getHorizontalAlignment();
            int vAlign = this.configmodel.getVerticalAlignment();
            if (mode == 0 || mode == 1) {
                cell = this.createPageByImage(index, size, mode, hAlign, vAlign);
            } else if (mode == 2) {
                cell = this.cutPageByImage(index, page, size);
            }
            cell.setPainterBounds(0.0f, 0.0f, size.width, size.height);
            StyleAttributes sa = Styles.getEmptySA();
            sa.setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((int)(hAlign + 1)));
            sa.setVerticalAlign(Styles.VerticalAlignment.getAlignment((int)(vAlign + 1)));
            cell.setStyle(Styles.getStyle((ShareStyleAttributes)sa));
            page.setWidth(size.width);
            page.setHeight(size.height);
            page.addPainter(cell);
        }
        if (page != null) {
            page.setIndex(index);
        }
        return page;
    }

    private ImageCell cutPageByImage(int index, Page page, DimensionFloat size) {
        ImageCell cell = null;
        int width = (int)size.width;
        int height = (int)size.height;
        int m = -1;
        for (int i = 0; i < this.images.length; ++i) {
            int count = this.imageCutCount(this.images[i], width, height);
            if (m + count >= index) {
                int n = index - m - 1;
                Image image = this.getPageByImage(n, i, width, height);
                cell = new ImageCell(image);
                break;
            }
            m += count;
        }
        return cell;
    }

    private Image getPageByImage(int n, int i, int width, int height) {
        Image image = this.images[i];
        int count = this.imageCutCount(image, width, height);
        if (count == 1) {
            return image;
        }
        int iWidth = image.getWidth(null);
        int iHeight = image.getHeight(null);
        int wCount = (int)Math.ceil((float)iWidth / (float)width);
        int hCount = (int)Math.ceil((float)iHeight / (float)height);
        int x = 0;
        int y = 0;
        int sWidth = 0;
        int sHeight = 0;
        int index = 0;
        for (int m = 0; m < hCount; ++m) {
            boolean isFound = false;
            for (int h = 0; h < wCount; ++h) {
                if (n == index) {
                    sWidth = x + width + 1 > iWidth ? iWidth - x : width;
                    sHeight = y + height + 1 > iHeight ? iHeight - y : height;
                    isFound = true;
                    break;
                }
                ++index;
                x += width;
            }
            if (isFound) break;
            x = 0;
            y += height;
        }
        BufferedImage newimage = new BufferedImage(sWidth, sHeight, 1);
        newimage.getGraphics().drawImage(image, 0, 0, sWidth, sHeight, x, y, x + sWidth, y + sHeight, null);
        return newimage;
    }

    private int imageCutCount(Image image, float width, float height) {
        int iWidth = image.getWidth(null);
        int iHeight = image.getHeight(null);
        int wCount = (int)Math.ceil((float)iWidth / width);
        int hCount = (int)Math.ceil((float)iHeight / height);
        return wCount * hCount;
    }

    private ImageCell createPageByImage(int index, DimensionFloat size, int mode, int hAlign, int vAlign) {
        ImageCell cell = new ImageCell(this.images[index]);
        int imageWidth = this.images[index].getWidth(null);
        int imageHeight = this.images[index].getHeight(null);
        if (mode == 0 && ((float)imageWidth > size.width || (float)imageHeight > size.height)) {
            cell.setScale(3);
        }
        return cell;
    }

    private void calculatePageCount(PaperInfo paperInfo) {
        int mode = this.configmodel.getMode();
        if (mode == 0 || mode == 1) {
            this.setPageCount(this.images.length);
        } else {
            DimensionFloat size = this.getPaperInfo().getPaintableSize();
            int width = (int)size.width;
            int height = (int)size.height;
            int count = 0;
            for (int i = 0; i < this.images.length; ++i) {
                count += this.imageCutCount(this.images[i], width, height);
            }
            this.setPageCount(count);
        }
    }
}

