/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.xls.output;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.util.render.CellImageRender;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ctrl.print.xls.exobject.APaper;
import com.kingdee.bos.ctrl.print.xls.exobject.BasicCell;
import com.kingdee.bos.ctrl.print.xls.output.LinesList;
import com.kingdee.bos.ctrl.print.xls.output.Location;
import com.kingdee.bos.ctrl.print.xls.output.StyleHelper;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public class XlsHelper {
    private Drawing drawing = null;
    private Sheet _sheet;
    public final int MaxRowSize = 65536;
    private static final double MTP = 25.39999918;
    private HashMap _imageCache;
    private MessageDigest _digest;
    private Logger _log = LogUtil.getLogger(XlsHelper.class);
    Map conStyleMap;

    public void updateSheet(Sheet sheet, Map poiConStyleMap) {
        this._sheet = sheet;
        this.drawing = null;
        this.conStyleMap = poiConStyleMap;
    }

    public void initRows(int offset, float topMargin, float bottomMargin, float hReduce, APaper paper, LinesList horizonLines) {
        Iterator iter = horizonLines.iterator();
        Location start = null;
        Location end = (Location)iter.next();
        int i = offset;
        this._sheet.createRow(i).setHeight(XlsHelper.getRowHeight(topMargin));
        ++i;
        while (iter.hasNext()) {
            start = end;
            end = (Location)iter.next();
            Row row = this._sheet.createRow(i);
            double height = end.getValue() - start.getValue();
            row.setHeight(XlsHelper.getRowHeight(height, hReduce));
            ++i;
        }
        this._sheet.createRow(i).setHeight(XlsHelper.getRowHeight(bottomMargin));
        this._sheet.setRowBreak(i);
    }

    public void initCols(float leftMargin, float rightMargin, float wReduce, LinesList verticalLines) {
        Iterator iter = verticalLines.iterator();
        Location start = null;
        Location end = (Location)iter.next();
        int i = 1;
        this._sheet.setColumnWidth(0, XlsHelper.getColWidth(leftMargin));
        while (iter.hasNext()) {
            start = end;
            end = (Location)iter.next();
            double width = end.getValue() - start.getValue();
            this._sheet.setColumnWidth(i, XlsHelper.getColWidth(width, wReduce));
            ++i;
        }
    }

    public void outputCell(BasicCell cell, boolean[][] map, int offset, int Xstart, int Ystart) {
        if (!cell.isValid()) {
            return;
        }
        int index = cell.getY1() + offset + Ystart + 1;
        Row row = this._sheet.getRow(index);
        Cell xlsCell = row.getCell(cell.getX1() + Xstart + 1);
        if (xlsCell == null) {
            xlsCell = row.createCell(cell.getX1() + Xstart + 1);
        }
        switch (cell.getType()) {
            case 0: {
                this.setLabelCellStyle(xlsCell, cell);
                xlsCell.setCellValue(cell.getText());
                break;
            }
            case 2: 
            case 3: {
                this.setContainerStyle(xlsCell, cell, offset, Xstart, Ystart);
                return;
            }
            case 1: {
                this.setLabelCellStyle(xlsCell, cell);
                this.outputImg(cell, offset, Xstart, Ystart);
            }
        }
        try {
            this.mergeCells(cell, map, offset, Xstart, Ystart);
        }
        catch (Exception e) {
            this._log.error((Object)("\u5355\u5143\u683c\u91cd\u53e0:" + cell.getText()));
        }
    }

    private void outputImg(BasicCell cell, int offset, int Xstart, int Ystart) {
        Image img = cell.getImage();
        if (img == null) {
            return;
        }
        byte[] bytes = null;
        Rectangle cellRect = new Rectangle(cell.getX1(), cell.getY1(), (int)cell.getWidth(), (int)cell.getHeight());
        img = this.scaleImage(img, cellRect, cell.getScaleModel());
        Point position = this.caculatePos(img, cellRect, cell);
        BufferedImage image = new BufferedImage((int)cell.getWidth(), (int)cell.getHeight(), 2);
        Graphics2D g2 = image.createGraphics();
        g2.drawImage(img, position.x, position.y, null);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", bos);
            bytes = bos.toByteArray();
            bos.close();
        }
        catch (IOException e) {
            this._log.error((Object)(cell.getId() + "\u521b\u5efa\u56fe\u7247\u5931\u8d25"), (Throwable)e);
        }
        int pictureIdx = this.drawImage(bytes);
        if (this.drawing == null) {
            this.drawing = this._sheet.createDrawingPatriarch();
        }
        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 1023, 255, (short)(cell.getX1() + Xstart + 1), cell.getY1() + offset + Ystart + 1, (short)(cell.getX2() + Xstart), cell.getY2() + offset + Ystart);
        this.drawing.createPicture((ClientAnchor)anchor, pictureIdx);
    }

    private int drawImage(byte[] data) {
        Integer num = null;
        byte[] keys = this.getDigest().digest(data);
        ByteBuffer bytes = ByteBuffer.wrap(keys);
        Charset converter = Charset.forName("ASCII");
        String key = converter.decode(bytes).toString();
        num = (Integer)this.getImageCache().get(key);
        if (num == null) {
            int index = this._sheet.getWorkbook().addPicture(data, 5);
            this.getImageCache().put(key, new Integer(index));
            num = new Integer(index);
        }
        return num;
    }

    private void mergeCells(BasicCell cell, boolean[][] map, int offset, int Xstart, int Ystart) throws Exception {
        if (cell.getX2() - cell.getX1() <= 1 && cell.getY2() - cell.getY1() <= 1) {
            return;
        }
        for (int r = cell.getY1(); r < cell.getY2(); ++r) {
            for (int c = cell.getX1(); c < cell.getX2(); ++c) {
                if (map[r][c]) {
                    for (int c2 = c; c2 >= 0; --c2) {
                        map[r][c2] = false;
                    }
                    for (int r2 = r; r2 >= 0; --r2) {
                        for (int c2 = cell.getX2(); c2 >= 0; --c2) {
                            map[r][c2] = false;
                        }
                    }
                    throw new Exception("\u5185\u5bb9\u4e3a\uff1a" + cell.getText() + "\u7684\u5355\u5143\u4e0e\u5176\u5b83\u5355\u5143\u683c\u91cd\u53e0\uff0c\u8fd9\u53ef\u80fd\u662f\u6a21\u677f\u8bbe\u8ba1\u5f15\u8d77\u7684");
                }
                map[r][c] = true;
            }
        }
        int firstRow = cell.getY1() + offset + Ystart + 1;
        int lastRow = cell.getY2() + offset + Ystart;
        int firstCol = cell.getX1() + Xstart + 1;
        int lastCol = cell.getX2() + Xstart;
        try {
            this._sheet.addMergedRegion(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
        }
        catch (Exception e) {
            this._log.error((Object)"\u6dfb\u52a0\u5355\u5143\u683c\u878d\u5408\u51fa\u9519");
        }
        CellStyle cellStyle = cell.getStyle();
        for (int r = firstRow; r <= lastRow; ++r) {
            for (int c = firstCol; c <= lastCol; ++c) {
                if (r == firstRow && c == firstCol) continue;
                Cell mergeCell = this._sheet.getRow(r).getCell(c);
                if (mergeCell == null) {
                    mergeCell = this._sheet.getRow(r).createCell(c);
                }
                CellStyle mergeCellStyle = mergeCell.getCellStyle();
                if (this.isNullStyle(cellStyle)) {
                    this.setStyle(mergeCellStyle, cellStyle);
                    continue;
                }
                mergeCell.setCellStyle(cellStyle);
            }
        }
    }

    private void setLabelCellStyle(Cell xlsCell, BasicCell cell) {
        CellStyle cellStyle = cell.getStyle();
        CellStyle xlsCellStyle = xlsCell.getCellStyle();
        if (this.isNullStyle(xlsCellStyle)) {
            xlsCell.setCellStyle(cellStyle);
        } else if (this.isNullStyle(cellStyle)) {
            this.setStyle(xlsCellStyle, cellStyle);
        } else {
            this.setStyle(xlsCellStyle, cellStyle);
            if (cellStyle.getBorderLeft() != BorderStyle.NONE) {
                xlsCellStyle.setBorderLeft(cellStyle.getBorderLeft());
                xlsCellStyle.setLeftBorderColor(cellStyle.getLeftBorderColor());
            }
            if (cellStyle.getBorderRight() != BorderStyle.NONE) {
                xlsCellStyle.setBorderRight(cellStyle.getBorderRight());
                xlsCellStyle.setRightBorderColor(cellStyle.getRightBorderColor());
            }
            if (cellStyle.getBorderTop() != BorderStyle.NONE) {
                xlsCellStyle.setBorderTop(cellStyle.getBorderTop());
                xlsCellStyle.setTopBorderColor(cellStyle.getTopBorderColor());
            }
            if (cellStyle.getBorderBottom() != BorderStyle.NONE) {
                xlsCellStyle.setBorderBottom(cellStyle.getBorderBottom());
                xlsCellStyle.setBottomBorderColor(cellStyle.getBottomBorderColor());
            }
            if (cellStyle.getFillPattern() != FillPatternType.NO_FILL) {
                xlsCellStyle.setFillPattern(cellStyle.getFillPattern());
                xlsCellStyle.setFillForegroundColor(cellStyle.getFillForegroundColor());
            }
            cell.setStyle(xlsCellStyle);
        }
    }

    private void setStyle(CellStyle newStyle, CellStyle cellStyle) {
        HSSFCellStyle hNewStyle = (HSSFCellStyle)newStyle;
        HSSFCellStyle hCellStyle = (HSSFCellStyle)cellStyle;
        hNewStyle.setAlignment(hCellStyle.getAlignment());
        hNewStyle.setFont(hCellStyle.getFont(this._sheet.getWorkbook()));
        hNewStyle.setVerticalAlignment(hCellStyle.getVerticalAlignment());
        hNewStyle.setWrapText(hCellStyle.getWrapText());
        hNewStyle.setIndention(hCellStyle.getIndention());
    }

    private void setContainerStyle(Cell xlsCell, BasicCell cell, int offset, int Xstart, int Ystart) {
        CellStyle cellStyle = cell.getStyle();
        if (this.isNullStyle(cellStyle)) {
            return;
        }
        BorderStyle borderLeft = cellStyle.getBorderLeft();
        short borderLeftColor = cellStyle.getLeftBorderColor();
        BorderStyle borderRight = cellStyle.getBorderRight();
        short borderRightColor = cellStyle.getRightBorderColor();
        BorderStyle borderTop = cellStyle.getBorderTop();
        short borderTopColor = cellStyle.getTopBorderColor();
        BorderStyle borderBottom = cellStyle.getBorderBottom();
        short borderBottomColor = cellStyle.getBottomBorderColor();
        int firstRow = cell.getY1() + offset + Ystart + 1;
        int lastRow = cell.getY2() + offset + Ystart;
        int firstCol = cell.getX1() + Xstart + 1;
        int lastCol = cell.getX2() + Xstart;
        for (int r = firstRow; r <= lastRow; ++r) {
            for (int c = firstCol; c <= lastCol; ++c) {
                String key;
                CellStyle cStyle;
                boolean newCreate = false;
                Cell poiCell = this._sheet.getRow(r).getCell(c);
                if (poiCell == null) {
                    poiCell = this._sheet.getRow(r).createCell(c);
                    newCreate = true;
                }
                if ((cStyle = (CellStyle)this.conStyleMap.get(key = StyleHelper.getContainerKey(poiCell, cell, firstRow, firstCol, r, c))) != null) {
                    poiCell.setCellStyle(cStyle);
                    continue;
                }
                CellStyle poiCellStyle = this._sheet.getWorkbook().createCellStyle();
                CellStyle poiStyle = poiCell.getCellStyle();
                if (!newCreate) {
                    poiCellStyle.setBorderTop(poiStyle.getBorderTop());
                    poiCellStyle.setTopBorderColor(poiStyle.getTopBorderColor());
                    poiCellStyle.setBorderLeft(poiStyle.getBorderLeft());
                    poiCellStyle.setLeftBorderColor(poiStyle.getLeftBorderColor());
                    poiCellStyle.setBorderRight(poiStyle.getBorderRight());
                    poiCellStyle.setRightBorderColor(poiStyle.getRightBorderColor());
                    poiCellStyle.setBorderBottom(poiStyle.getBorderBottom());
                    poiCellStyle.setBottomBorderColor(poiStyle.getBottomBorderColor());
                }
                if (r == firstRow && borderTop != BorderStyle.NONE) {
                    poiCellStyle.setBorderTop(borderTop);
                    poiCellStyle.setTopBorderColor(borderTopColor);
                }
                if (r == lastRow && borderBottom != BorderStyle.NONE) {
                    poiCellStyle.setBorderBottom(borderBottom);
                    poiCellStyle.setBottomBorderColor(borderBottomColor);
                }
                if (c == firstCol && borderLeft != BorderStyle.NONE) {
                    poiCellStyle.setBorderLeft(borderLeft);
                    poiCellStyle.setLeftBorderColor(borderLeftColor);
                }
                if (c == lastCol && borderRight != BorderStyle.NONE) {
                    poiCellStyle.setBorderRight(borderRight);
                    poiCellStyle.setRightBorderColor(borderRightColor);
                }
                if (cellStyle.getFillPattern() == FillPatternType.NO_FILL) {
                    poiCellStyle.setFillForegroundColor(poiStyle.getFillForegroundColor());
                    poiCellStyle.setFillPattern(poiStyle.getFillPattern());
                } else {
                    poiCellStyle.setFillForegroundColor(cellStyle.getFillForegroundColor());
                    poiCellStyle.setFillPattern(cellStyle.getFillPattern());
                }
                this.setStyle(poiCellStyle, cellStyle);
                poiCell.setCellStyle(poiCellStyle);
                this.conStyleMap.put(key, poiCellStyle);
            }
        }
    }

    private boolean isNullStyle(CellStyle cellStyle) {
        return cellStyle.getBorderLeft() == BorderStyle.NONE && cellStyle.getBorderRight() == BorderStyle.NONE && cellStyle.getBorderTop() == BorderStyle.NONE && cellStyle.getBorderBottom() == BorderStyle.NONE && cellStyle.getFillPattern() == FillPatternType.NO_FILL;
    }

    private static int reduce(double num, float var) {
        return (int)(num *= (double)var);
    }

    private static short getRowHeight(double height, float var) {
        double num = 0.1 * KDPrinterUtils.printPointToLom(height);
        num = num * 72.0 * 20.0 / 25.39999918;
        return (short)XlsHelper.reduce(num, var);
    }

    private static short getRowHeight(double height) {
        return XlsHelper.getRowHeight(height, 1.0f);
    }

    private static int getColWidth(double width, float var) {
        double num = 0.1 * KDPrinterUtils.printPointToLom(width);
        num = num * 12.0 * 256.0 / 25.39999918;
        return XlsHelper.reduce(num, var);
    }

    private static int getColWidth(double width) {
        return XlsHelper.getColWidth(width, 1.0f);
    }

    public Map getImageCache() {
        if (this._imageCache == null) {
            this._imageCache = new HashMap();
        }
        return this._imageCache;
    }

    public MessageDigest getDigest() {
        if (this._digest == null) {
            try {
                this._digest = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException e) {
                this._log.error((Object)"\u627e\u4e0d\u5230SHAMessageDigest\u2014\u2014\u56fe\u7247\u7f13\u5b58");
            }
        }
        return this._digest;
    }

    private Image scaleImage(Image image, Rectangle cellRect, int mode) {
        if (mode == 1) {
            image = image.getScaledInstance((int)cellRect.getWidth(), (int)cellRect.getHeight(), 1);
        }
        if (mode == 3) {
            int imageHeight;
            double yRate;
            double rate;
            int imageWidth = image.getWidth(null);
            double xRate = (double)imageWidth / (double)cellRect.width;
            double d = rate = xRate > (yRate = (double)(imageHeight = image.getHeight(null)) / (double)cellRect.height) ? xRate : yRate;
            if (rate == xRate) {
                imageWidth = cellRect.width;
                imageHeight = (int)((double)imageHeight / rate);
            } else {
                imageWidth = (int)((double)imageWidth / rate);
                imageHeight = cellRect.height;
            }
            image = image.getScaledInstance(imageWidth, imageHeight, 1);
            this.waitForImage((Component)new CellImageRender(), image);
        }
        return image;
    }

    private void waitForImage(Component comp, Image image) {
        try {
            MediaTracker tracker = new MediaTracker(comp);
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch (InterruptedException err) {
            err.printStackTrace();
        }
        comp = null;
    }

    private Point caculatePos(Image image, Rectangle cellRect, BasicCell cell) {
        Point pos = new Point(0, 0);
        CellStyle style = cell.getStyle();
        if (image != null) {
            int imageWidth = image.getWidth(null);
            int imageHeight = image.getHeight(null);
            if (style == null) {
                pos.x = 0;
                pos.y = 0;
                return pos;
            }
            if (style.getAlignment() == HorizontalAlignment.CENTER) {
                pos.x += (cellRect.width - imageWidth) / 2;
            } else if (style.getAlignment() == HorizontalAlignment.RIGHT) {
                pos.x += cellRect.width - imageWidth;
            }
            if (style.getVerticalAlignment() == VerticalAlignment.CENTER) {
                pos.y += (cellRect.height - imageHeight) / 2;
            } else if (style.getVerticalAlignment() == VerticalAlignment.BOTTOM) {
                pos.y += cellRect.height - imageHeight;
            }
        }
        return pos;
    }
}

