/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.process.dataset.group;

import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.GroupNode;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.GroupTotalDefs;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Stack;

public class GroupTree
extends GroupNode
implements Serializable {
    private transient ResultSet details;
    private transient GroupTotalDefs gtDefs;

    protected GroupTree() {
        super(null);
        this.groupPath = "";
    }

    public final void trim() {
        Stack<GroupNode> nodes = new Stack<GroupNode>();
        nodes.push(this);
        while (!nodes.isEmpty()) {
            GroupNode gn = (GroupNode)nodes.pop();
            ArrayList subGroups = gn.getSubGroups();
            if (subGroups == null) continue;
            subGroups.trimToSize();
            for (int i = 0; i < subGroups.size(); ++i) {
                GroupNode gg = (GroupNode)subGroups.get(i);
                if (gg.getSubGroups() == null) continue;
                nodes.push(gg);
            }
        }
    }

    @Override
    public final int getFirstRecord() {
        return 0;
    }

    public final GroupNode getLastedGroup(int recordIdx) {
        if (recordIdx < 0 || recordIdx >= this.getRecords()) {
            throw new IndexOutOfBoundsException();
        }
        GroupNode group = this;
        ArrayList children;
        block0: while ((children = group.getSubGroups()) != null) {
            int subs = children.size();
            int i = 0;
            while (true) {
                if (i >= subs) continue block0;
                GroupNode sub = (GroupNode)children.get(i);
                int left = recordIdx - sub.getRecords();
                if (left < 0) {
                    group = sub;
                    continue block0;
                }
                recordIdx = left;
                ++i;
            }
            break;
        }
        return group;
    }

    public final void detroy() {
        if (this.details != null) {
            DBUtil.closeResultSet((ResultSet)this.details);
        }
    }

    public final ResultSet getDetails() {
        return this.details;
    }

    public final void setDetails(ResultSet details) {
        this.details = details;
    }

    public final void setGroupTotalDefs(GroupTotalDefs gtDefs) {
        this.gtDefs = gtDefs;
    }

    public final GroupTotalDefs getGroupTotalDefs() {
        return this.gtDefs;
    }

    public GroupNode solveGroupPath(String groupPath) {
        if (groupPath.equals("")) {
            return this;
        }
        groupPath = groupPath.replace('.', ';');
        String[] tagsStr = groupPath.split(";");
        GroupNode groupNode = this;
        for (int i = 0; i < tagsStr.length; ++i) {
            groupNode = (GroupNode)groupNode.getSubGroups().get(Integer.parseInt(tagsStr[i]) - 1);
        }
        return groupNode;
    }
}

