/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.process.dataset.group;

import com.kingdee.bos.ctrl.common.NullValue;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.IPersistent;
import com.kingdee.bos.ctrl.reportone.data.engine.rowsfile.RowsFile;
import com.kingdee.bos.ctrl.reportone.data.engine.rowsfile.RowsFileUtil;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.WrappedResultSet;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.GroupNode;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.GroupTree;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.aggregate.IAggregate;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.GroupTotalDef;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.SimpleGroupsDef;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ResultSetToTree {
    public static final Logger logger = LogUtil.getLogger(ResultSetToTree.class);

    public static final GroupTree makeGroupTree(ResultSet rs, SimpleGroupsDef groupsDef) throws Exception {
        return ResultSetToTree.makeGroupTree(rs, groupsDef, null);
    }

    public static final GroupTree makeGroupTree(ResultSet rs, String[] groupByNames, GroupTotalDef rootTotalDef) throws Exception {
        int[] groupingCols = new int[groupByNames.length];
        for (int i = 0; i < groupingCols.length; ++i) {
            groupingCols[i] = rs.findColumn(groupByNames[i]);
        }
        return ResultSetToTree.makeGroupTree(rs, groupingCols, rootTotalDef);
    }

    public static final GroupTree makeGroupTree(ResultSet rs, SimpleGroupsDef groupsDef, GroupTotalDef rootTotalDef) throws Exception {
        int[] groupingCols = new int[groupsDef.levels()];
        for (int i = 0; i < groupingCols.length; ++i) {
            groupingCols[i] = groupsDef.getColumn(i + 1);
        }
        return ResultSetToTree.makeGroupTree(rs, groupingCols, rootTotalDef);
    }

    public static final GroupTree makeGroupTree(ResultSet resultSet, int[] groupingCols, GroupTotalDef rootTotalDef) throws Exception {
        WrappedResultSet wrappedRS;
        Object tempVal = new Object();
        long l0 = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Start making group tree.");
        }
        if (rootTotalDef != null) {
            rootTotalDef.solveTotalDefColumn(resultSet);
        }
        int[] tags = new int[groupingCols.length];
        Object[] lastVals = new Object[groupingCols.length];
        for (int i = 0; i < groupingCols.length; ++i) {
            lastVals[i] = tempVal;
        }
        GroupTree groupTree = new GroupTree();
        GroupNode node = groupTree;
        IAggregate[] rootTotals = null;
        boolean hasRootTotal = rootTotalDef != null && rootTotalDef.totals() > 0;
        RowsFile rowsFile = null;
        boolean needCache = true;
        if (resultSet instanceof WrappedResultSet && (wrappedRS = (WrappedResultSet)resultSet).getResultSet() instanceof IPersistent) {
            groupTree.setDetails(wrappedRS);
            wrappedRS.absolute(1);
            needCache = false;
        }
        if (needCache) {
            rowsFile = new RowsFile(resultSet.getMetaData());
        }
        Object[] rowData = new Object[resultSet.getMetaData().getColumnCount()];
        while (resultSet.next()) {
            DBUtil.readRow((ResultSet)resultSet, (Object[])rowData);
            if (needCache) {
                rowsFile.addRow(rowData);
            }
            for (int level = 0; level < groupingCols.length; ++level) {
                Object val = rowData[groupingCols[level] - 1];
                if (val == null) {
                    val = NullValue.NULL_OBJECT;
                }
                if (!val.equals(lastVals[level])) {
                    node = node.createSubGroup(val == NullValue.NULL_OBJECT ? null : val);
                    lastVals[level] = val;
                    int n = level;
                    tags[n] = tags[n] + 1;
                    node.setGroupPath(ResultSetToTree.makeGroupPath(tags, level + 1));
                    for (int j = level + 1; j < groupingCols.length; ++j) {
                        lastVals[j] = tempVal;
                        tags[j] = 0;
                    }
                    continue;
                }
                ArrayList subGroups = node.getSubGroups();
                node = (GroupNode)subGroups.get(subGroups.size() - 1);
            }
            node.addMemeber();
            node = groupTree;
            if (!hasRootTotal) continue;
            if (rootTotals == null) {
                rootTotals = rootTotalDef.createAggregates(rowData.length);
            }
            for (int total = 0; total < rootTotalDef.totals(); ++total) {
                int col = rootTotalDef.getTotalDef(total).getTotalCol();
                rootTotals[total].peekData(rowData[col - 1]);
            }
        }
        if (rootTotals != null) {
            Object[] rootTotal = new Object[rootTotals.length];
            for (int total = 0; total < rootTotalDef.totals(); ++total) {
                int col = rootTotalDef.getTotalDef(total).getTotalCol();
                rootTotal[col - 1] = rootTotals[total].getValue();
            }
            groupTree.setTotalResult(rootTotal);
        }
        if (needCache) {
            groupTree.setDetails(RowsFileUtil.asResultSet(rowsFile));
        }
        groupTree.trim();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)((rowsFile == null ? 0 : rowsFile.getRowCount()) + " rows" + (rootTotals != null ? "[with ROOT total]" : "") + ",token " + (System.currentTimeMillis() - l0)));
        }
        return groupTree;
    }

    public static String makeGroupPath(int[] tags, int levels) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < levels; ++i) {
            sb.append(tags[i]);
            sb.append('.');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

