/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.process.dataset.rowset;

import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.ctrl.kdf.expr.Parser;
import com.kingdee.bos.ctrl.kdf.expr.ParserHelperListener;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.BasicResultSet;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.SimpleResultSetMetaData;
import com.kingdee.bos.ctrl.reportone.data.invoke.FormulaParserHelperListener;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.AbstractDataSetProcess;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.BitSet;

public class SimpleAddColumns
extends AbstractDataSetProcess {
    protected ResultSet resultSet;
    protected String[] names;
    protected int[] dtTypes;
    protected String[] exprs;
    private int oldColumnCount;
    protected Parser parser;

    public SimpleAddColumns(ResultSet rs, String[] names, int[] dtTypes, String[] exprs) throws Exception {
        this.resultSet = rs;
        this.names = names;
        this.dtTypes = dtTypes;
        this.exprs = exprs;
    }

    protected void initParser() {
        this.parser = new Parser(null, null);
        this.parser.addParserHelperListener((ParserHelperListener)new FormulaParserHelperListener(this.parameters, this.envProvider, this.resultSet));
    }

    protected Object computeColumn(String expr) throws SQLException {
        this.parser.prepare(null, expr);
        Variant var = this.parser.parse();
        if (var.getVt() != 16) {
            return var.getValue();
        }
        throw new SQLException("This column cotains a invalid formula.'" + expr + "'");
    }

    @Override
    public Object call() throws Exception {
        this.initParser();
        return new _ResultSet();
    }

    class _ResultSet
    extends BasicResultSet
    implements ResultSet {
        private ResultSetMetaData meta;
        private BitSet computed = new BitSet();
        private Object[] newColVals;

        public _ResultSet() throws SQLException {
            this.meta = this.makeTargetMeta();
        }

        private ResultSetMetaData makeTargetMeta() throws SQLException {
            SimpleResultSetMetaData meta = new SimpleResultSetMetaData(SimpleAddColumns.this.resultSet.getMetaData());
            SimpleAddColumns.this.oldColumnCount = meta.getColumnCount();
            for (int i = 0; i < SimpleAddColumns.this.names.length; ++i) {
                meta.addColumn(meta.getColumnCount() + 1, SimpleAddColumns.this.names[i], SimpleAddColumns.this.dtTypes[i]);
            }
            this.newColVals = new Object[SimpleAddColumns.this.names.length];
            return meta;
        }

        @Override
        public ResultSetMetaData getMetaData() throws SQLException {
            this.checkCursor(false);
            return this.meta;
        }

        @Override
        public Object getObject(int columnIndex) throws SQLException {
            super.getObject(columnIndex);
            Object val = null;
            if (columnIndex > SimpleAddColumns.this.oldColumnCount) {
                int col_off = columnIndex - SimpleAddColumns.this.oldColumnCount - 1;
                if (!this.computed.get(col_off)) {
                    this.newColVals[col_off] = SimpleAddColumns.this.computeColumn(SimpleAddColumns.this.exprs[col_off]);
                    this.computed.set(col_off);
                }
                val = this.newColVals[col_off];
            } else {
                val = SimpleAddColumns.this.resultSet.getObject(columnIndex);
            }
            return val;
        }

        @Override
        public boolean next() throws SQLException {
            super.next();
            this.computed.clear();
            boolean b = SimpleAddColumns.this.resultSet.next();
            if (!b) {
                this.cursorStatus = -2;
            }
            return b;
        }

        @Override
        public void close() throws SQLException {
            super.close();
            DBUtil.closeResultSet((ResultSet)SimpleAddColumns.this.resultSet);
        }

        public Object getObject(int columnIndex, Class type) throws SQLException {
            return null;
        }

        public Object getObject(String columnLabel, Class type) throws SQLException {
            return null;
        }
    }
}

