/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.process.dataset.rowset;

import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.IPersistent;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.IRowNode;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.SimpleResultSet;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.SimpleResultSetMetaData;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.SimpleRowNode;
import com.kingdee.bos.ctrl.reportone.data.engine.rowsfile.ResultSet2Reader;
import com.kingdee.bos.ctrl.reportone.data.engine.rowsfile.RowsFile;
import com.kingdee.bos.ctrl.reportone.data.engine.rowsfile.RowsFileUtil;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.AbstractDataSetProcess;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SimpleRowsSplitter
extends AbstractDataSetProcess {
    protected ResultSet resultSet;
    protected int rowFrom = -1;
    protected String[] columns;
    protected ResultSet persitentRS = null;

    public void setNewColumns(String[] columns) {
        this.columns = columns;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public void setSplitFrom(int row) {
        this.rowFrom = row > 0 ? row - 1 : -1;
    }

    private final ResultSetMetaData makeTargetMetaData() throws SQLException {
        ResultSetMetaData oldMeta = this.resultSet.getMetaData();
        SimpleResultSetMetaData metaImpl = new SimpleResultSetMetaData(oldMeta);
        int colEx = oldMeta.getColumnCount();
        for (int i = 0; i < oldMeta.getColumnCount(); ++i) {
            int colIdx = colEx++;
            String colName = this.columns == null || this.columns[colIdx] == null ? "Copied_" + oldMeta.getColumnName(i + 1) : this.columns[colIdx];
            metaImpl.addColumn(colEx, colName, oldMeta.getColumnType(i + 1));
        }
        return metaImpl;
    }

    private static int getRowCount(ResultSet rs) throws SQLException {
        int rowBak = rs.getRow();
        rs.absolute(-1);
        int curRow = rs.getRow();
        rs.absolute(rowBak);
        return curRow;
    }

    @Override
    public Object call() throws SQLException {
        this.persitentRS = null;
        try {
            if (this.resultSet instanceof IPersistent) {
                this.persitentRS = this.resultSet;
            } else {
                RowsFile rowsFile = RowsFileUtil.createByResultSet(this.resultSet);
                rowsFile.setReadMode(true);
                this.persitentRS = RowsFileUtil.asResultSet(rowsFile);
            }
        }
        catch (IOException ex) {
            throw new SQLException("Operate cached file failed,details:" + ex.toString());
        }
        int rowsCount = SimpleRowsSplitter.getRowCount(this.persitentRS);
        if (rowsCount < this.rowFrom) {
            this.rowFrom = -1;
        }
        if (this.rowFrom == -1) {
            this.rowFrom = rowsCount / 2;
        }
        int targetRows = Math.max(this.rowFrom, rowsCount - this.rowFrom);
        ResultSetMetaData metaImpl = this.makeTargetMetaData();
        ResultSet2Reader reader = new ResultSet2Reader(this.persitentRS, rowsCount, this.rowFrom, 128);
        _RowNode firstNode = new _RowNode(reader, metaImpl.getColumnCount());
        _ResultSet rs = new _ResultSet(firstNode, targetRows, metaImpl);
        return rs;
    }

    class _RowNode
    extends SimpleRowNode
    implements IRowNode {
        private int columns;
        private ResultSet2Reader rowsReader;

        _RowNode(ResultSet2Reader rowsReader, int columns) {
            this.rowsReader = rowsReader;
            this.columns = columns;
        }

        @Override
        public Object[] getRowData() {
            if (this.rowData == null) {
                try {
                    Object[] upperRow = this.rowsReader.nextUpperRow();
                    Object[] lowerRow = this.rowsReader.nextLowerRow();
                    this.rowData = new Object[this.columns];
                    if (upperRow != null) {
                        System.arraycopy(upperRow, 0, this.rowData, 0, upperRow.length);
                    }
                    if (lowerRow != null) {
                        System.arraycopy(lowerRow, 0, this.rowData, this.columns / 2, this.columns / 2);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            return super.getRowData();
        }

        @Override
        public IRowNode nextRow() {
            return new _RowNode(this.rowsReader, this.columns);
        }
    }

    class _ResultSet
    extends SimpleResultSet
    implements ResultSet {
        _ResultSet(IRowNode firstRecord, int count, ResultSetMetaData meta) {
            super(firstRecord, count, meta);
        }

        @Override
        public void close() throws SQLException {
            super.close();
            DBUtil.closeResultSet((ResultSet)SimpleRowsSplitter.this.persitentRS);
        }
    }
}

