/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.common;

import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class BasicSelector
extends KDPanel {
    private KDPanel leftPanel;
    private KDPanel rightPanel;
    private JComponent leftCtrl;
    private JComponent rightCtrl;
    protected KDWorkButton btnSelect;
    protected KDWorkButton btnSelectAll;
    protected KDWorkButton btnDelete;
    protected KDWorkButton btnDeleteAll;

    public void enableSelect(boolean is) {
        this.btnSelect.setEnabled(is);
    }

    public void enableSelectAll(boolean is) {
        this.btnSelectAll.setEnabled(is);
    }

    public void enableDelete(boolean is) {
        this.btnDelete.setEnabled(is);
    }

    public void enableDeleteAll(boolean is) {
        this.btnDeleteAll.setEnabled(is);
    }

    public BasicSelector() {
        this.setOpaque(false);
        this.init();
        this.installListener();
    }

    private void init() {
        this.leftPanel = new KDPanel();
        this.rightPanel = new KDPanel();
        this.btnSelect = new KDWorkButton((Icon)Resource.ICON_MOVE_LEFT);
        this.btnSelectAll = new KDWorkButton((Icon)Resource.ICON_MOVEALL_RIGHT);
        this.btnDelete = new KDWorkButton((Icon)Resource.ICON_MOVE_RIGHT);
        this.btnDeleteAll = new KDWorkButton((Icon)Resource.ICON_MOVEALL_LEFT);
        TableLayout tl = TableLayout.split((int)1, (int)3);
        tl.colStyle(0).setWidth(-50);
        tl.colStyle(0).setPriX(1);
        tl.colStyle(1).setMargin(3, 0, 3, 0);
        tl.colStyle(1).setWidth(28);
        tl.colStyle(2).setWidth(-50);
        tl.colStyle(2).setPriX(1);
        Table col0 = tl.cell(0).split(1, 1);
        Table col1 = tl.cell(1).split(7, 1);
        col1.rowStyle(0).setPriY(1);
        for (int i = 1; i < 6; ++i) {
            col1.rowStyle(i).setHeight(21);
            col1.rowStyle(i).setMarginBottom(3);
        }
        col1.rowStyle(6).setPriY(1);
        this.setLayout((LayoutManager)tl);
        this.add((Component)this.leftPanel, col0.cell(0, 0));
        this.add((Component)this.btnSelect, col1.cell(1, 0));
        this.add((Component)this.btnSelectAll, col1.cell(2, 0));
        this.add((Component)this.btnDelete, col1.cell(4, 0));
        this.add((Component)this.btnDeleteAll, col1.cell(5, 0));
        this.add((Component)this.rightPanel, tl.cell(0, 2));
    }

    private void installListener() {
        ActionHandler actionHandler = new ActionHandler();
        this.btnSelect.addActionListener((ActionListener)actionHandler);
        this.btnSelectAll.addActionListener((ActionListener)actionHandler);
        this.btnDelete.addActionListener((ActionListener)actionHandler);
        this.btnDeleteAll.addActionListener((ActionListener)actionHandler);
    }

    protected abstract void onSelect();

    protected abstract void onSelectAll();

    protected abstract void onDelete();

    protected abstract void onDeleteAll();

    public void setCtrl(JComponent comp, boolean left, boolean scrollSupport) {
        KDPanel panel = left ? this.leftPanel : this.rightPanel;
        panel.removeAll();
        panel.setLayout((LayoutManager)new BorderLayout());
        if (scrollSupport) {
            panel.add((Component)new KDScrollPane((Component)comp), (Object)"Center");
        } else {
            panel.add((Component)comp, (Object)"Center");
        }
        if (left) {
            this.leftCtrl = comp;
        } else {
            this.rightCtrl = comp;
        }
    }

    public JComponent getCtrl(boolean left) {
        return left ? this.leftCtrl : this.rightCtrl;
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == BasicSelector.this.btnSelect) {
                BasicSelector.this.onSelect();
            } else if (source == BasicSelector.this.btnSelectAll) {
                BasicSelector.this.onSelectAll();
            } else if (source == BasicSelector.this.btnDelete) {
                BasicSelector.this.onDelete();
            } else if (source == BasicSelector.this.btnDeleteAll) {
                BasicSelector.this.onDeleteAll();
            }
        }
    }
}

