/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.common;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.Parameter;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.CommonResource;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;

public class ParamPanel
extends KDPanel {
    private static final int COL_NAME = 0;
    private static final int COL_ALIAS = 1;
    private static final int COL_DATA_TYPE = 2;
    private static final int COL_VALUE = 3;
    private static final int COL_NULL = 4;
    private static final int COL_DESCRIPTION = 5;
    private static Parameter[] keys = new Parameter[]{Parameter.P_isDataView, Parameter.P_dataURI, Parameter.P_isMainData, Parameter.P_isVisible};
    private static final int COL_NAME_PRO = 0;
    private static final int COL_VALUE_PRO = 1;
    private boolean isChanged = false;
    private boolean isShowProperty = true;
    private KDWorkButton btnUp;
    private KDWorkButton btnDown;
    private KDWorkButton btnInsert;
    private KDWorkButton btnDelete;
    private KDWorkButton btnUpProperty;
    private KDWorkButton btnDownProperty;
    private KDWorkButton btnInsertProperty;
    private KDWorkButton btnDeleteProperty;
    private KDTable table;
    private KDTable tableProperty;
    private KDComboBox cmbType;
    private KDCheckBox cmbNull;
    private KDComboBox cmbPropertykeys;
    private Parameter parameter;
    private DeleteAction delAction = new DeleteAction();
    private DeletePropertyAction delPropertyAction = new DeletePropertyAction();
    List ps = new ArrayList();

    public ParamPanel(boolean isShowTableProperty) {
        this.isShowProperty = isShowTableProperty;
        this.setOpaque(false);
        this.init();
    }

    public ParamPanel() {
        this(false);
    }

    private void init() {
        this.initTable();
        this.btnUp = new KDWorkButton((Icon)Resource.ICON_MOVE_TOP);
        this.btnDown = new KDWorkButton((Icon)Resource.ICON_MOVE_DOWN);
        this.btnInsert = new KDWorkButton((Icon)Resource.ICON_INSERT);
        this.btnDelete = new KDWorkButton((Action)this.delAction);
        this.btnUp.setToolTipText(CommonResource.getString("res_28"));
        this.btnDown.setToolTipText(CommonResource.getString("res_29"));
        this.btnInsert.setToolTipText(CommonResource.getString("res_30"));
        this.btnUp.setMinimumSize(new Dimension(26, 19));
        this.btnDown.setMinimumSize(new Dimension(26, 19));
        this.btnInsert.setMinimumSize(new Dimension(26, 19));
        this.btnDelete.setMinimumSize(new Dimension(26, 19));
        TableLayout tl = TableLayout.split((int)4, (int)1);
        tl.rowStyle(0).setHeight(19);
        tl.rowStyle(0).setMarginBottom(3);
        tl.rowStyle(1).setPriY(1);
        tl.rowStyle(1).setMarginBottom(3);
        Table row0 = tl.cell(0).split(1, 6);
        row0.colStyle(1).setPriX(1);
        row0.colStyle(2).setWidth(26);
        row0.colStyle(2).setMarginRight(3);
        row0.colStyle(3).setWidth(26);
        row0.colStyle(3).setMarginRight(3);
        row0.colStyle(4).setWidth(26);
        row0.colStyle(4).setMarginRight(3);
        row0.colStyle(5).setWidth(26);
        Table row1 = tl.cell(2).split(1, 6);
        if (this.isShowProperty) {
            this.initTableProperty();
            this.btnUpProperty = new KDWorkButton((Icon)Resource.ICON_MOVE_TOP);
            this.btnDownProperty = new KDWorkButton((Icon)Resource.ICON_MOVE_DOWN);
            this.btnInsertProperty = new KDWorkButton((Icon)Resource.ICON_INSERT);
            this.btnDeleteProperty = new KDWorkButton((Action)this.delPropertyAction);
            this.btnUpProperty.setToolTipText(CommonResource.getString("res_28"));
            this.btnDownProperty.setToolTipText(CommonResource.getString("res_29"));
            this.btnInsertProperty.setToolTipText(CommonResource.getString("res_30"));
            this.btnUpProperty.setMinimumSize(new Dimension(26, 19));
            this.btnDownProperty.setMinimumSize(new Dimension(26, 19));
            this.btnInsertProperty.setMinimumSize(new Dimension(26, 19));
            this.btnDeleteProperty.setMinimumSize(new Dimension(26, 19));
            tl.rowStyle(2).setHeight(19);
            tl.rowStyle(2).setMarginTop(8);
            tl.rowStyle(2).setMarginBottom(3);
            tl.rowStyle(3).setHeight(100);
            row1.colStyle(1).setPriX(1);
            row1.colStyle(2).setWidth(26);
            row1.colStyle(2).setMarginRight(3);
            row1.colStyle(3).setWidth(26);
            row1.colStyle(3).setMarginRight(3);
            row1.colStyle(4).setWidth(26);
            row1.colStyle(4).setMarginRight(3);
            row1.colStyle(5).setWidth(26);
        }
        this.setLayout((LayoutManager)tl);
        this.add((Component)new KDLabel(CommonResource.getString("res_5")), row0.cell(0));
        this.add((Component)this.btnUp, row0.cell(2));
        this.add((Component)this.btnDown, row0.cell(3));
        this.add((Component)this.btnInsert, row0.cell(4));
        this.add((Component)this.btnDelete, row0.cell(5));
        this.add((Component)this.table, tl.cell(1));
        if (this.isShowProperty) {
            this.add((Component)new KDLabel(CommonResource.getString("res_31")), row1.cell(0));
            this.add((Component)this.btnUpProperty, row1.cell(2));
            this.add((Component)this.btnDownProperty, row1.cell(3));
            this.add((Component)this.btnInsertProperty, row1.cell(4));
            this.add((Component)this.btnDeleteProperty, row1.cell(5));
            this.add((Component)this.tableProperty, tl.cell(3));
        }
        this.installListener();
    }

    private void initTableProperty() {
        this.tableProperty = new KDTable();
        this.tableProperty.getSelectManager().setSelectMode(2);
        this.tableProperty.addHeadRow();
        this.tableProperty.addColumns(2);
        this.tableProperty.getColumn(0).setWidth(300);
        this.tableProperty.getColumn(1).setWidth(400);
        IRow row = this.tableProperty.getHeadRow(0);
        row.getCell(0).setValue((Object)CommonResource.getString("res_32"));
        row.getCell(1).setValue((Object)CommonResource.getString("res_33"));
        this.cmbPropertykeys = new KDComboBox();
        this.cmbPropertykeys.addItems((Object[])keys);
        KDTDefaultCellEditor ceKEY = new KDTDefaultCellEditor((JComboBox)this.cmbPropertykeys);
        this.tableProperty.getColumn(0).setEditor((ICellEditor)ceKEY);
    }

    private void initTable() {
        this.table = new KDTable();
        this.table.getSelectManager().setSelectMode(10);
        this.table.addHeadRow();
        this.table.addColumns(6);
        this.table.getColumn(0).setWidth(100);
        this.table.getColumn(1).setWidth(100);
        this.table.getColumn(2).setWidth(80);
        this.table.getColumn(3).setWidth(100);
        this.table.getColumn(4).setWidth(60);
        this.table.getColumn(5).setWidth(200);
        IRow row = this.table.getHeadRow(0);
        row.getCell(0).setValue((Object)CommonResource.getString("res_34"));
        row.getCell(1).setValue((Object)CommonResource.getString("res_35"));
        row.getCell(2).setValue((Object)CommonResource.getString("res_2"));
        row.getCell(3).setValue((Object)CommonResource.getString("res_36"));
        row.getCell(4).setValue((Object)CommonResource.getString("res_37"));
        row.getCell(5).setValue((Object)CommonResource.getString("res_38"));
        this.cmbType = new KDComboBox();
        this.cmbType.addItems((Object[])DataType.BASIC_TYPES);
        KDTDefaultCellEditor ceType = new KDTDefaultCellEditor((JComboBox)this.cmbType);
        this.table.getColumn(2).setEditor((ICellEditor)ceType);
        this.cmbNull = new KDCheckBox();
        KDTDefaultCellEditor ceNull = new KDTDefaultCellEditor((JCheckBox)this.cmbNull);
        this.table.getColumn(4).setEditor((ICellEditor)ceNull);
    }

    private void installListener() {
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParamPanel.this.rowUp(ParamPanel.this.table);
            }
        });
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParamPanel.this.rowDown(ParamPanel.this.table);
            }
        });
        this.btnInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParamPanel.this.insertRow(ParamPanel.this.table);
            }
        });
        this.table.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                ParamPanel.this.refreshPropertyTable();
            }
        });
        if (this.isShowProperty) {
            this.btnUpProperty.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParamPanel.this.rowUp(ParamPanel.this.tableProperty);
                }
            });
            this.btnDownProperty.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParamPanel.this.rowDown(ParamPanel.this.tableProperty);
                }
            });
            this.btnInsertProperty.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParamPanel.this.insertRowProperty(ParamPanel.this.tableProperty);
                }
            });
            this.tableProperty.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

                public void editValueChanged(KDTEditEvent e) {
                }

                public void editStopped(KDTEditEvent e) {
                    if (e.getColIndex() == 1 && e.getValue() != null && !StringUtil.isEnglishString((String)e.getValue().toString())) {
                        WindowUtil.msgboxInfo((Object)"\u5c5e\u6027\u503c\u542b\u975e\u6cd5\u5b57\u7b26\uff01\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"\u975e\u6cd5\u5b57\u7b26", (Component)((Object)ParamPanel.this));
                        ParamPanel.this.tableProperty.getCell(e.getRowIndex(), 1).setValue(null);
                    }
                    int rowIndex = ParamPanel.this.table.getSelectManager().get().getBeginRow();
                    ParamPanel.this.parameter = (Parameter)ParamPanel.this.ps.get(rowIndex);
                    if (null != ParamPanel.this.parameter) {
                        Map map = ParamPanel.this.parameter.getProperties();
                        int counts = ParamPanel.this.tableProperty.getRowCount();
                        for (int i = 0; i < counts; ++i) {
                            if (null != ParamPanel.this.tableProperty.getRow(i).getCell(0).getValue()) {
                                String key = ParamPanel.this.tableProperty.getRow(i).getCell(0).getValue().toString();
                                if (ParamPanel.this.tableProperty.getRow(i).getCell(1).getValue() == null) {
                                    return;
                                }
                                for (int j = 0; j < keys.length; ++j) {
                                    if (!keys[j].getAlias().equals(key)) continue;
                                    key = keys[j].getName();
                                    break;
                                }
                                if (!StringUtil.equals((String)key, (String)"alias") && !StringUtil.equals((String)key, (String)"desc")) {
                                    String value = ParamPanel.this.tableProperty.getRow(i).getCell(1).getValue().toString();
                                    map.put(key, value);
                                }
                            }
                            ParamPanel.this.setChanged(true);
                        }
                    }
                }
            });
        }
        this.table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                int i;
                if (e.getValue() != null && !e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() != null) {
                    ParamPanel.this.setChanged(true);
                }
                if (e.getColIndex() == 0 && e.getValue() != null) {
                    if (!StringUtil.isEnglishString((String)e.getValue().toString())) {
                        WindowUtil.msgboxInfo((Object)"\u53c2\u6570\u540d\u5305\u542b\u975e\u6cd5\u5b57\u7b26\uff01\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"\u975e\u6cd5\u5b57\u7b26", (Component)((Object)ParamPanel.this));
                        ParamPanel.this.table.getCell(e.getRowIndex(), 0).setValue(null);
                    }
                    for (i = 0; i < ParamPanel.this.table.getRowCount(); ++i) {
                        String name;
                        if (i == e.getRowIndex() || ParamPanel.this.table.getValueAt(i, 0) == null || !StringUtil.equals((String)(name = ParamPanel.this.table.getValueAt(i, 0).toString()), (String)e.getValue().toString())) continue;
                        WindowUtil.msgboxInfo((Object)"\u53c2\u6570\u540d\u91cd\u590d\uff01\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"\u975e\u6cd5\u5b57\u7b26", (Component)((Object)ParamPanel.this));
                        ParamPanel.this.table.getCell(e.getRowIndex(), 0).setValue(null);
                    }
                }
                for (i = 0; i < ParamPanel.this.table.getRowCount(); ++i) {
                    IRow row = ParamPanel.this.table.getRow(i);
                    ParamPanel.this.getParameter(row, (Parameter)ParamPanel.this.ps.get(i));
                }
                ParamPanel.this.setChanged(true);
            }
        });
        this.table.getActionMap().put("Delete", this.delAction);
        this.table.getActionMap().remove("Copy");
        this.table.getActionMap().remove("Cut");
        this.table.getActionMap().remove("Paste");
    }

    public void refresh() {
        this.table.removeRows();
        int z = this.ps.size();
        if (z == 0) {
            return;
        }
        this.table.addRows(z);
        for (int i = 0; i < z; ++i) {
            this.setParam2Row((Parameter)this.ps.get(i), this.table.getRow(i));
        }
    }

    private void refreshPropertyTable() {
        if (null != this.table.getSelectManager().get() && this.isShowProperty) {
            int index = this.table.getSelectManager().get().getBeginRow();
            IRow row = this.table.getRow(index);
            if (!this.isValidRow(row)) {
                this.tableProperty.removeRows();
                return;
            }
            this.parameter = (Parameter)this.ps.get(index);
            if (this.parameter == null) {
                return;
            }
            Map map = this.parameter.getProperties();
            String value = null;
            this.tableProperty.removeRows();
            Iterator it = map.keySet().iterator();
            block0: while (it.hasNext()) {
                String key = it.next().toString();
                if (StringUtil.equals((String)key, (String)"alias.zh_CN") || StringUtil.equals((String)key, (String)"alias") || StringUtil.equals((String)key, (String)"desc") || StringUtil.equals((String)key, (String)"desc.zh_CN")) continue;
                int newIndex = this.insertRowProperty(this.tableProperty);
                value = map.get(key).toString();
                for (int j = 0; j < keys.length; ++j) {
                    if (!StringUtil.equals((String)keys[j].getName(), (String)key)) continue;
                    this.tableProperty.getRow(newIndex).getCell(0).setValue((Object)keys[j]);
                    this.tableProperty.getRow(newIndex).getCell(1).setValue((Object)value);
                    continue block0;
                }
            }
        }
    }

    private void rowUp(KDTable table) {
        KDTSelectBlock sel = table.getSelectManager().get();
        if (sel == null) {
            return;
        }
        int idx = sel.getBeginRow();
        if (idx == 0) {
            return;
        }
        this.setChanged(true);
        IRow selRow = table.removeRow(idx);
        Parameter temp = (Parameter)this.ps.get(idx);
        this.ps.remove(idx);
        this.ps.add(idx - 1, temp);
        table.addRow(idx - 1, selRow);
        table.getSelectManager().select(idx - 1, 0);
    }

    private void rowDown(KDTable table) {
        KDTSelectBlock sel = table.getSelectManager().get();
        if (sel == null) {
            return;
        }
        int idx = sel.getBeginRow();
        if (idx == table.getRowCount() - 1) {
            return;
        }
        this.setChanged(true);
        IRow selRow = table.removeRow(idx);
        Parameter temp = (Parameter)this.ps.get(idx);
        this.ps.remove(idx);
        this.ps.add(idx + 1, temp);
        table.addRow(idx + 1, selRow);
        table.getSelectManager().select(idx + 1, 0);
    }

    private void insertRow(KDTable table) {
        IRow newRow;
        int idx = 0;
        if (table.getSelectManager().get() == null) {
            newRow = table.addRow();
            idx = table.getRowCount() - 1;
            Parameter param = new Parameter();
            this.ps.add(param);
        } else {
            idx = table.getSelectManager().get().getBeginRow();
            newRow = table.addRow(idx);
            Parameter param = new Parameter();
            this.ps.add(idx, param);
            if (this.isShowProperty) {
                this.tableProperty.removeRows();
            }
        }
        newRow.getCell(2).setValue((Object)DataType.STRING);
        table.getEditManager().editCellAt(idx, 0);
        this.setChanged(true);
    }

    private int insertRowProperty(KDTable table) {
        table.addRow();
        int idx = table.getRowCount() - 1;
        this.setChanged(true);
        return idx;
    }

    private void deleteRow(KDTable table) {
        int selEnd;
        KDTSelectBlock sel = table.getSelectManager().get();
        if (sel == null) {
            return;
        }
        if (!WindowUtil.msgboxYesNo((Component)((Object)this), (Object)CommonResource.getString("res_39"), (String)CommonResource.getString("res_40"))) {
            return;
        }
        int selBegin = sel.getBeginRow();
        for (int i = selEnd = sel.getEndRow(); i >= selBegin; --i) {
            table.removeRow(i);
            this.ps.remove(i);
            if (!this.isShowProperty || this.tableProperty.getRowCount() <= 0) continue;
            this.tableProperty.removeRows();
        }
        table.getSelectManager().setActiveRowIndex(selBegin);
        this.refreshPropertyTable();
        this.setChanged(true);
    }

    private void deleteRowProperty(KDTable table) {
        int selEnd;
        this.setChanged(true);
        if (this.parameter == null) {
            WindowUtil.msgboxInfo((Object)"\u5c5e\u6027\u6240\u5bf9\u5e94\u7684\u53c2\u6570\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u53c2\u6570\u540d!", (String)"\u53c2\u6570\u540d\u7a7a", (Component)((Object)this));
            return;
        }
        KDTSelectBlock sel = table.getSelectManager().get();
        if (sel == null) {
            return;
        }
        if (!WindowUtil.msgboxYesNo((Component)((Object)this), (Object)CommonResource.getString("res_39"), (String)CommonResource.getString("res_40"))) {
            return;
        }
        int selBegin = sel.getBeginRow();
        for (int i = selEnd = sel.getEndRow(); i >= selBegin; --i) {
            String deleteKey;
            Map map;
            if (table.getRow(i).getCell(0).getValue() != null && (map = this.parameter.getProperties()).containsKey(deleteKey = ((Parameter)table.getRow(i).getCell(0).getValue()).getName())) {
                map.remove(deleteKey);
            }
            table.removeRow(i);
        }
        table.getSelectManager().setActiveRowIndex(selBegin);
    }

    private Parameter getParameter(IRow row, Parameter p) {
        if (row.getCell(0).getValue() != null) {
            p.setName(row.getCell(0).getValue().toString());
        } else {
            p.setName(null);
        }
        if (row.getCell(1).getValue() != null) {
            p.setAlias(row.getCell(1).getValue().toString());
        } else {
            p.setAlias(null);
        }
        if (row.getCell(2).getValue() != null) {
            p.setDataType((DataType)row.getCell(2).getValue());
        }
        if (row.getCell(3).getValue() != null) {
            p.setDefaultValue(row.getCell(3).getValue().toString());
        } else {
            p.setDefaultValue(null);
        }
        if (row.getCell(4).getValue() != null) {
            p.setAllowNull(Boolean.valueOf(row.getCell(4).getValue().toString()).booleanValue());
        }
        if (row.getCell(5).getValue() != null) {
            p.setDesc(row.getCell(5).getValue().toString());
        } else {
            p.setDesc(null);
        }
        return p;
    }

    public List getParameters() {
        return this.ps;
    }

    private boolean isValidRow(IRow row) {
        return row.getCell(0).getValue() != null;
    }

    private void setParam2Row(Parameter p, IRow row) {
        row.getCell(0).setValue((Object)p.getName());
        row.getCell(1).setValue((Object)p.getAlias());
        row.getCell(2).setValue((Object)p.getDataType());
        row.getCell(3).setValue((Object)p.getDefaultValue());
        row.getCell(4).setValue((Object)p.isAllowNull());
        row.getCell(5).setValue((Object)p.getDesc());
    }

    public void setParameters2(List params) {
        if (params == null) {
            return;
        }
        this.table.removeRows();
        int z = params.size();
        if (z == 0) {
            return;
        }
        this.table.addRows(z);
        this.ps = new ArrayList();
        this.ps.addAll(params);
        for (int i = 0; i < z; ++i) {
            this.setParam2Row((Parameter)params.get(i), this.table.getRow(i));
        }
    }

    public void setParameters(List params) {
        if (params == null) {
            return;
        }
        this.table.removeRows();
        int z = params.size();
        if (z == 0) {
            return;
        }
        this.table.addRows(z);
        this.ps = new ArrayList();
        ParamPanel.copyParams(params, this.ps);
        for (int i = 0; i < z; ++i) {
            this.setParam2Row((Parameter)params.get(i), this.table.getRow(i));
        }
    }

    private static void copyParams(List ps, List temp) {
        if (ps != null && ps.size() > 0) {
            for (int i = 0; i < ps.size(); ++i) {
                Parameter param = new Parameter();
                param.copy((Parameter)ps.get(i));
                temp.add(param);
            }
        }
    }

    public void addParameter(Parameter p) {
        IRow row = this.table.addRow();
        this.setParam2Row(p, row);
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    class DeletePropertyAction
    extends AbstractAction {
        public DeletePropertyAction() {
            this.putValue("SmallIcon", Resource.ICON_DELETE);
            this.putValue("ShortDescription", CommonResource.getString("res_41"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ParamPanel.this.deleteRowProperty(ParamPanel.this.tableProperty);
        }
    }

    class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            this.putValue("SmallIcon", Resource.ICON_DELETE);
            this.putValue("ShortDescription", CommonResource.getString("res_41"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ParamPanel.this.deleteRow(ParamPanel.this.table);
        }
    }
}

