/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.process.crosstab;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.reportone.data.modal.query.Column;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumn;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.AbstractListViewSelector;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.Process2Resource;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.ProcessWizardStepUIs;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.WizardContext;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.WizardHelper;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.crosstab.CrosstabColumnsPanel;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.crosstab.CrosstabModel;
import com.kingdee.bos.ctrl.swing.KDList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CrosstabUIs
extends ProcessWizardStepUIs {
    private CrosstabColumnsPanel xAxisPanel;
    private CrosstabColumnsPanel yAxisPanel;
    private CrosstabColumnsPanel crossColsPanel;
    private MixedSelector xAxisSelector;
    private MixedSelector yAxisSelector;
    private MixedSelector crossColsSelector;
    protected CrosstabModel model;

    public CrosstabUIs(WizardContext ctx) {
        super(3, ctx);
        OutputColumns lastOutputCols = (OutputColumns)ctx.getOutput();
        this.xAxisSelector = new MixedSelector(lastOutputCols, true);
        this.yAxisSelector = new MixedSelector(lastOutputCols, true);
        this.crossColsSelector = new MixedSelector(lastOutputCols, false);
        this.xAxisPanel = this.xAxisSelector.getRightPanel();
        this.yAxisPanel = this.yAxisSelector.getRightPanel();
        this.crossColsPanel = this.crossColsSelector.getRightPanel();
        super.setUI(0, (JComponent)((Object)this.xAxisSelector));
        super.setUI(1, (JComponent)((Object)this.yAxisSelector));
        super.setUI(2, (JComponent)((Object)this.crossColsSelector));
    }

    @Override
    public JComponent getUI(int index) {
        if (index == 0) {
            this.xAxisSelector.trimUnSelectableColumns(this.yAxisSelector.getRightPanel().getList());
        } else if (index == 1) {
            this.yAxisSelector.trimUnSelectableColumns(this.xAxisSelector.getRightPanel().getList());
        }
        return super.getUI(index);
    }

    private String[] getValues(CrosstabColumnsPanel panel) {
        List values = panel.getValues();
        String[] strValues = new String[values.size()];
        values.toArray(strValues);
        return strValues;
    }

    @Override
    public String checkInputValided(int subStep) {
        KDList list = null;
        if (subStep == 0) {
            list = this.xAxisPanel.getList();
        } else if (subStep == 1) {
            list = this.yAxisPanel.getList();
        } else if (subStep == 2) {
            list = this.crossColsPanel.getList();
        }
        if (list.getElementCount() == 0) {
            return Process2Resource.getString("res_25");
        }
        if (subStep == 2) {
            this.updateModel();
        }
        return null;
    }

    public void updateModel() {
        this.model.setXCols(WizardHelper.getNames(this.xAxisPanel.getList()));
        this.model.setXColOrders(this.getValues(this.xAxisPanel));
        this.model.setYCols(WizardHelper.getNames(this.yAxisPanel.getList()));
        this.model.setYColOrders(this.getValues(this.yAxisPanel));
        this.model.setCrossFields(WizardHelper.getNames(this.crossColsPanel.getList()));
        this.model.setTotalMethods(this.getValues(this.crossColsPanel));
        this.model.setTotalAllX(true);
        this.model.setTotalAllY(true);
        this.model.setPutTotalColsToX(this.crossColsPanel.isPutCrossFieldToX());
    }

    public CrosstabModel getModel() {
        return this.model;
    }

    public void setModel(CrosstabModel model) {
        this.model = model;
    }

    public class MixedSelector
    extends AbstractListViewSelector {
        private List leftColsBackup;

        public MixedSelector(List leftCols, boolean axisMode) {
            WizardHelper.setKDListOutputCols(this.getSupply().getList(), axisMode ? leftCols : this.selectNumColumns(leftCols), false);
            this.setCtrl((JComponent)((Object)new CrosstabColumnsPanel(axisMode)), false, false);
            this.getSupply().setTitle(Process2Resource.getString("res_26"));
            this.getRightPanel().setTitle(Process2Resource.getString("res_27"));
            this.refreshBTs();
            this.getRightPanel().getList().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    MixedSelector.this.refreshBTs();
                }
            });
            if (axisMode) {
                this.leftColsBackup = new ArrayList();
                for (int i = 0; i < leftCols.size(); ++i) {
                    this.leftColsBackup.add(leftCols.get(i));
                }
            }
        }

        private List selectNumColumns(List columns) {
            ArrayList<Column> list = new ArrayList<Column>();
            for (int i = 0; i < columns.size(); ++i) {
                Column c = (Column)((Object)columns.get(i));
                if (!DataType.isNumberType((DataType)c.getDataType())) continue;
                list.add(c);
            }
            return list;
        }

        public void trimUnSelectableColumns(KDList list) {
            Column c;
            int i;
            assert (this.leftColsBackup != null);
            KDList supplyList = this.getSupply().getList();
            for (i = 0; i < this.leftColsBackup.size(); ++i) {
                c = (Column)((Object)this.leftColsBackup.get(i));
                if (WizardHelper.findObject(supplyList, (Object)c) != -1) continue;
                supplyList.insertElement((Object)c, i);
            }
            for (i = 0; i < list.getElementCount(); ++i) {
                c = (Column)((Object)list.getElement(i));
                supplyList.removeElement((Object)c);
            }
            if (supplyList.getElementCount() > 0) {
                supplyList.setSelectedIndex(0);
            }
        }

        public CrosstabColumnsPanel getRightPanel() {
            return (CrosstabColumnsPanel)((Object)this.getCtrl(false));
        }

        @Override
        protected void onSelect() {
            KDList list = this.getSupply().getList();
            int sel = list.getSelectedIndex();
            this.getRightPanel().addColumn((OutputColumn)((Object)list.getElement(sel)));
            list.setSelectedIndex(sel == list.getElementCount() - 1 ? 0 : sel + 1);
            this.refreshBTs();
        }

        @Override
        protected void onSelectAll() {
            int size = this.getSupply().getList().getElementCount();
            for (int i = 0; i < size; ++i) {
                OutputColumn oc = (OutputColumn)((Object)this.getSupply().getList().getElement(i));
                this.getRightPanel().addColumn(oc);
            }
            this.refreshBTs();
        }

        @Override
        protected void onDelete() {
            this.getRightPanel().removeCurrentColumn();
            this.refreshBTs();
        }

        @Override
        protected void onDeleteAll() {
            this.getRightPanel().removeAllColumns();
            this.refreshBTs();
        }

        protected void refreshBTs() {
            boolean enable = this.getSupply().getList().getSelectedIndex() >= 0;
            this.btnSelect.setEnabled(enable);
            this.btnSelectAll.setEnabled(enable);
            enable = this.getRightPanel().getList().getSelectedIndex() >= 0;
            this.btnDelete.setEnabled(enable);
            this.btnDeleteAll.setEnabled(enable);
        }
    }
}

