/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.query;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.editor.styled.ScriptQLStyledEditor;
import com.kingdee.bos.ctrl.reportone.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.reportone.data.modal.query.QueryType;
import com.kingdee.bos.ctrl.reportone.data.modal.query.framework.ksql.KsqlQuery;
import com.kingdee.bos.ctrl.reportone.data.wizard.Wizard2Resource;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.CustomTextEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.formula.FormulaWizardEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.framework.query.AbstractQueryWizardTabbedUI;
import com.kingdee.bos.ctrl.reportone.data.wizard.query.QueryResource;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class SqlTextWizardUI
extends AbstractQueryWizardTabbedUI {
    private ContentPane _contentPane;

    public String getTabbedTitle() {
        return Wizard2Resource.getString("res_36");
    }

    @Override
    protected KDPanel createPanel() {
        this._contentPane = new ContentPane();
        this._contentPane.addUpdateSQLListener(new UpdateSQLHandler());
        return this._contentPane;
    }

    @Override
    public void syncUi2Model() {
        IQuery query = this.getModel().getQuery();
        if (query instanceof KsqlQuery) {
            KsqlQuery ksqlQuery = (KsqlQuery)query;
            ksqlQuery.setRegular(!this._contentPane.isCustom());
            ksqlQuery.setDistinct(this._contentPane.isDistinct());
            if (this._contentPane.isCustom()) {
                ksqlQuery.setContent(this._contentPane.getEditorData());
            }
        }
    }

    @Override
    public void syncModel2Ui() {
        this.updateSQL();
        this._contentPane.showValue(this.getModel().getQuery());
    }

    private void updateSQL() {
        KsqlQuery ksqlQuery;
        IQuery query = this.getModel().getQuery();
        if (query instanceof KsqlQuery && (ksqlQuery = (KsqlQuery)query).isRegular()) {
            String sql = this.getModel().makeSQL();
            this.getModel().getQuery().setContent(sql);
        }
    }

    @Override
    public void postEvent(JComponent parentCtrl) {
        this.updateSQL();
    }

    static class ContentPane
    extends KDPanel {
        private ResultEditor editor;
        private KDCheckBox chkCustom;
        private KDCheckBox chkDistinct;
        private KDWorkButton btnGetFromWizard;
        private KDPanel panCard;
        private CardLayout cardLayout;

        public ContentPane() {
            this.init();
            this.installListener();
        }

        private void init() {
            this.setOpaque(false);
            this.chkCustom = new KDCheckBox(QueryResource.getString("res_7"));
            this.btnGetFromWizard = new KDWorkButton("\u751f\u6210\u67e5\u8be2\u8bed\u53e5");
            this.chkDistinct = new KDCheckBox(QueryResource.getString("res_9"));
            this.cardLayout = new CardLayout();
            this.panCard = new KDPanel((LayoutManager)this.cardLayout);
            this.panCard.setOpaque(false);
            this.panCard.add((Component)this.btnGetFromWizard, (Object)"custom");
            this.panCard.add((Component)this.chkDistinct, (Object)"wizard");
            this.editor = new ResultEditor((JTextComponent)new ScriptQLStyledEditor());
            this.editor.getWizardButton().setVisible(false);
            this.editor.addButton((JComponent)this.panCard);
            TableLayout tl = TableLayout.splitRow((int)2);
            tl.defaultStyle().setHeight(20);
            tl.rowStyle(0).setPriY(1);
            this.setLayout((LayoutManager)tl);
            this.add((Component)((Object)this.editor), tl.cell(0));
            this.add((Component)this.chkCustom, tl.cell(1));
            this.syncSelfDef(false);
        }

        private void installListener() {
            this.chkDistinct.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (chkDistinct.isSelected()) {
                        this.addDistinct();
                    } else {
                        this.removeDistinct();
                    }
                }
            });
            this.btnGetFromWizard.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (WindowUtil.msgboxYesNo((Component)((Object)this), (Object)QueryResource.getString("res_10"), (String)QueryResource.getString("res_7"))) {
                        editor.setContent(this.fireUpdateSQLEvent());
                    }
                }
            });
            this.chkCustom.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!chkCustom.isSelected()) {
                        if (WindowUtil.msgboxYesNo((Component)((Object)this), (Object)QueryResource.getString("res_11"), (String)QueryResource.getString("res_7"))) {
                            editor.setContent(this.fireUpdateSQLEvent());
                        } else {
                            chkCustom.setSelected(true);
                        }
                    }
                    this.syncSelfDef(chkCustom.isSelected());
                }
            });
        }

        private void addDistinct() {
            String sql = this.editor.getContent();
            if (sql.indexOf("SELECT") != 0) {
                return;
            }
            sql = "SELECT DISTINCT" + sql.substring(6);
            this.editor.setContent(sql);
        }

        private void removeDistinct() {
            String sql = this.editor.getContent();
            sql = sql.replaceFirst("DISTINCT", "");
            this.editor.setContent(sql);
        }

        private void syncSelfDef(boolean isSelfDef) {
            if (isSelfDef) {
                this.cardLayout.show((Container)this.panCard, "custom");
            } else {
                this.cardLayout.show((Container)this.panCard, "wizard");
            }
            this.editor.setResultEditable(isSelfDef);
        }

        public void setEditorData(String content) {
            this.editor.setContent(content);
        }

        public String getEditorData() {
            return this.editor.getContent();
        }

        public void showValue(IQuery query) {
            this.editor.setContent(query.getContent());
            this.chkDistinct.setSelected(query.isDistinct());
            this.chkCustom.setSelected(query.getQueryType() == QueryType.SQL_CUSTOM);
            this.syncSelfDef(this.chkCustom.isSelected());
        }

        public boolean isDistinct() {
            return this.chkDistinct.isSelected();
        }

        public boolean isCustom() {
            return this.chkCustom.isSelected();
        }

        public void addUpdateSQLListener(UpdateSQLListener l) {
            this.listenerList.add(UpdateSQLListener.class, l);
        }

        public void removeUpdateSQLListener(UpdateSQLListener l) {
            this.listenerList.remove(UpdateSQLListener.class, l);
        }

        protected String fireUpdateSQLEvent() {
            UpdateSQLEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != UpdateSQLListener.class) continue;
                if (event == null) {
                    event = new UpdateSQLEvent((Object)this);
                }
                return ((UpdateSQLListener)listeners[i + 1]).update(event);
            }
            return "";
        }

        public class UpdateSQLEvent
        extends EventObject {
            public UpdateSQLEvent(Object source) {
                super(source);
            }
        }

        public static interface UpdateSQLListener
        extends EventListener {
            public String update(UpdateSQLEvent var1);
        }

        private class ResultEditor
        extends CustomTextEditor {
            public ResultEditor(JTextComponent txtComp) {
                super(txtComp);
                this.setTitle("KSQL:");
            }

            public ResultEditor() {
                this.setTitle("KSQL:");
            }

            @Override
            public FormulaWizardEditor getFormulaEditor() {
                return this.formula;
            }
        }
    }

    private class UpdateSQLHandler
    implements ContentPane.UpdateSQLListener {
        private UpdateSQLHandler() {
        }

        @Override
        public String update(ContentPane.UpdateSQLEvent event) {
            KsqlQuery ksqlQuery = (KsqlQuery)SqlTextWizardUI.this.getModel().getQuery();
            boolean isRegular = ksqlQuery.isRegular();
            ksqlQuery.setRegular(true);
            String result = SqlTextWizardUI.this.getModel().makeSQL();
            ksqlQuery.setRegular(isRegular);
            return result;
        }
    }
}

