/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.ui;

import com.kingdee.bos.ctrl.common.ui.tree.ATreeController;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUI;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.reportone.data.framework.connection.DataSourceType;
import com.kingdee.bos.ctrl.reportone.data.meta.ui.MetaTreeCtrl;
import com.kingdee.bos.ctrl.reportone.data.meta.ui.res.MetaIcons;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.ClientResource;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.icons.KDRSIcons;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.BizContent_MetaEnv;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.BizContent_MetaLibrary;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.ContentCategory;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.ReportType;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.IBizSecurity;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.StorageCategory;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.tree.TreePath;

public class ClassicBizContentTreeCtrl
extends ATreeController {
    public static final HashMap LIST_ATTRS = new HashMap();
    public static final String[] GET_ATTRS;
    private IBizContent bizCnt;
    private IBizSecurity bizSec;

    public ClassicBizContentTreeCtrl(IBizContent bizRpt) {
        this.bizCnt = bizRpt;
        this.initTreeUI(new TreeUI());
    }

    public IBizContent getBizContent() {
        return this.bizCnt;
    }

    public void initTreeUI(TreeUI treeUI) {
        TreeUINode topNode = this.newTreeNode(StorageCategory.FOLDER, "/", ClientResource.getString("res_1"), true);
        topNode.setCustomIcon((Icon)KDRSIcons.ICN_CONTENT_ROOT);
        treeUI.setRootNode(topNode);
        this.bindTreeUI(treeUI, topNode);
        this.initPopupMenu();
    }

    protected void initPopupMenu() {
    }

    protected boolean initNode(TreePath treePath) throws Exception {
        TreeUINode node = (TreeUINode)treePath.getLastPathComponent();
        String pathText = this.makePathText(treePath);
        this.initFolderNode(pathText, node);
        return true;
    }

    private void initFolderNode(String pathText, TreeUINode node) throws KDRSException {
        boolean isDS = ContentCategory.isDS(node.getCategory());
        HashMap rv = this.bizCnt.list(pathText, LIST_ATTRS);
        String[] names = (String[])rv.get("name");
        String[] alias = (String[])rv.get("alias");
        String[] types = (String[])rv.get("type");
        String[] categories = (String[])rv.get("category");
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (isDS) {
                if ("snapshot".equals(name)) {
                    TreeUINode tcnSub = this.newTreeNode(null, name, ClientResource.getString("res_76"), true);
                    tcnSub.setCustomIcon((Icon)MetaIcons.ICON_LIBRARY);
                    this.getTreeUI().addChildNode(tcnSub, node);
                    BizContent_MetaEnv env = new BizContent_MetaEnv(this.getBizContent(), pathText);
                    BizContent_MetaLibrary ml = new BizContent_MetaLibrary(env);
                    MetaTreeCtrl mtc = new MetaTreeCtrl((DefObj)ml);
                    tcnSub.setUserObject((Object)ml);
                    mtc.bindTreeUI(this.getTreeUI(), tcnSub);
                    continue;
                }
                if ("config".equals(name)) continue;
            }
            Object category = null;
            if (categories[i] != null) {
                category = ContentCategory.fromName(categories[i]);
            }
            String text = TreeUINode.makeText((String)names[i], (String)alias[i]);
            boolean hasChildren = false;
            if (category == null) {
                Object object = category = "Folder".equals(types[i]) ? StorageCategory.FOLDER : StorageCategory.FILE;
                if (!this.isVisible(category, text)) continue;
                hasChildren = category == StorageCategory.FOLDER;
            } else {
                if (!this.isVisible(category, text)) continue;
                hasChildren = category instanceof ReportType || category instanceof DataSourceType;
            }
            TreeUINode tcnSub = this.newTreeNode(category, names[i], alias[i], hasChildren);
            tcnSub.setCustomIcon(this.getCategoryIcon(category));
            this.getTreeUI().addChildNode(tcnSub, node);
        }
    }

    public TreeUINode newTreeNode(Object category, String name, String alias, boolean allowsChildren) {
        TreeUINode tn = super.newTreeNode(category, name, alias, allowsChildren);
        tn.setCustomIcon(this.getCategoryIcon(category));
        return tn;
    }

    protected Icon getCategoryIcon(Object category) {
        return KDRSIcons.getCategoryIcon(category);
    }

    protected void onDoubleClick(MouseEvent evt, TreePath treePath) {
    }

    public final IBizSecurity getBizSecurity() {
        return this.bizSec;
    }

    public final void setBizSecurity(IBizSecurity bizSec) {
        this.bizSec = bizSec;
    }

    static {
        LIST_ATTRS.put("name", null);
        LIST_ATTRS.put("alias", null);
        LIST_ATTRS.put("type", null);
        LIST_ATTRS.put("category", null);
        GET_ATTRS = new String[]{"name", "alias", "category"};
    }
}

