/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz.content;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.ICachedBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class LocalCachedBizContentProxy
implements InvocationHandler {
    private static Logger log = LogUtil.getPackageLogger(LocalCachedBizContentProxy.class);
    public static String ATTR_EX_REMOTE_LASTMODIFIED = "REMOTE_LASTMODIFIED";
    private IBizContent remoteBizSto;
    private IBizStorage localBizSto;
    private IStorage localSto;

    private LocalCachedBizContentProxy(IBizContent remoteBizSto, IStorage localSto) {
        this.remoteBizSto = remoteBizSto;
        this.localSto = localSto;
        this.localBizSto = new BizStorage(this.localSto);
    }

    public IBizStorage getLocalBizStorage() {
        return this.localBizSto;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equalsIgnoreCase("readTemplate")) {
            return this.invoke_ReadTemplate((String)args[0]);
        }
        if (method.getName().equalsIgnoreCase("getLocalBizStorage")) {
            return this.localBizSto;
        }
        try {
            return method.invoke((Object)this.remoteBizSto, args);
        }
        catch (Exception e) {
            Throwable t;
            if (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) instanceof Exception) {
                e = (Exception)t;
            }
            throw e;
        }
    }

    private byte[] invoke_ReadTemplate(String pathText) throws KDRSException {
        String templatePath;
        String localTemplatePath = templatePath = pathText;
        long r_lastModified = this.getTemplateLastModified(false, templatePath);
        long l_lastModified = -1L;
        for (int time = 0; time < 2; ++time) {
            try {
                if (!this.localBizSto.isAtomic(localTemplatePath)) {
                    l_lastModified = this.getTemplateLastModified(true, localTemplatePath + "/template");
                    localTemplatePath = localTemplatePath + "/template";
                    break;
                }
                l_lastModified = this.getTemplateLastModified(true, localTemplatePath);
                break;
            }
            catch (NotFoundException ex) {
                HashMap attrs = (HashMap)BizStorageUtil.SET_FILE_TYPE.clone();
                attrs.put("create_policy", String.valueOf(2));
                try {
                    this.localBizSto.create(templatePath, attrs);
                }
                catch (KDRSException e) {
                    if (time == 1) {
                        throw e;
                    }
                    log.error((Object)("Failed in creating cache for '" + templatePath + ",maybe need sync some resources."));
                    Path path = Path.valueOf(templatePath).getParent();
                    this.localSto.refresh(path, false);
                    log.info((Object)("Have refreshed folder '" + path + "'"));
                }
                continue;
            }
        }
        KDRSException kdrsException = null;
        byte[] data = null;
        if (l_lastModified == r_lastModified && l_lastModified != -1L) {
            log.info((Object)("read note/template[path:'" + localTemplatePath + "'] from local cache"));
            try {
                data = BizStorageUtil.readFile(this.localBizSto, localTemplatePath);
            }
            catch (KDRSException e) {
                kdrsException = e;
            }
        } else {
            data = this.remoteBizSto.readTemplate(pathText);
            try {
                this.localBizSto.writeFile(localTemplatePath, -1, data);
                LocalCachedBizContentProxy.setLocalFileLastModified(this.localBizSto, localTemplatePath, r_lastModified);
            }
            catch (KDRSException e) {
                kdrsException = e;
            }
        }
        if (kdrsException != null) {
            log.error((Object)("Failed in reading cache of template '" + templatePath + ",maybe need sync some resources."));
            Path path = Path.valueOf(templatePath).getParent();
            try {
                this.localSto.refresh(path, false);
                log.info((Object)("Have refreshed folder '" + path + "', pls try agian."));
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
            }
            throw kdrsException;
        }
        return data;
    }

    private long getTemplateLastModified(boolean isLocalFile, String filePath) throws KDRSException {
        String fileVer = (String)BizStorageUtil.getAttribute(isLocalFile ? this.localBizSto : this.remoteBizSto, filePath, isLocalFile ? ATTR_EX_REMOTE_LASTMODIFIED : "last-tpl-modified");
        return fileVer == null ? -1L : Long.parseLong(fileVer);
    }

    public static void setLocalFileLastModified(IBizStorage localBizSto, String filePath, long timestamp) throws KDRSException {
        BizStorageUtil.setAttribute(localBizSto, filePath, ATTR_EX_REMOTE_LASTMODIFIED, String.valueOf(timestamp));
    }

    public static IBizContent create(IBizContent remoteBizSto, IStorage localSto) throws KDRSException {
        LocalCachedBizContentProxy handler = new LocalCachedBizContentProxy(remoteBizSto, localSto);
        return (ICachedBizContent)Proxy.newProxyInstance(LocalCachedBizContentProxy.class.getClassLoader(), new Class[]{ICachedBizContent.class}, (InvocationHandler)handler);
    }
}

