/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz.content.objects;

import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.reportone.data.invoke.IDataExecutor;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.BizContent_ReportConfigLoader;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.objects.IStoredDataX;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.AbstractContainerObject;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.IStoredObject;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.StoredObjectFactory;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.StorageUtil;
import com.kingdee.bos.ctrl.reportone.reportframework.AStreamStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportConfig;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportFactory;
import com.kingdee.bos.ctrl.reportone.reportframework.execute.AbstractLocalReportExecutor;
import com.kingdee.bos.ctrl.reportone.reportframework.execute.IReportExecutor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Element;

public class StoredDataX
extends AbstractContainerObject
implements IStoredDataX {
    public static final String OBJ_TEMPLATE = "template";
    public static final String OBJ_CONFIG = "config";

    public StoredDataX(IStorage storage, Path path, String type, StoredObjectFactory objFactory) {
        super(storage, path, type, objFactory);
    }

    public static void build(IStorage storage, Path path, HashMap attrs, StoredObjectFactory objFactory) throws KDRSException {
        storage.create(path, ResourceType.FOLDER, attrs);
        try {
            storage.create(path.getChild(OBJ_CONFIG), ResourceType.FILE, null);
            storage.create(path.getChild(OBJ_TEMPLATE), ResourceType.FILE, null);
        }
        catch (Exception ex) {
            new BizStorage(storage).delete(path.getPathText());
            throw KDRSException.makeException(ex);
        }
    }

    @Override
    public IStoredObject[] listChildren() throws KDRSException {
        return new IStoredObject[0];
    }

    @Override
    public IReportExecutor getReportExecutor(IDataExecutor dataExecutor) throws ReportException {
        AbstractLocalReportExecutor r = ReportFactory.createExecutor(super.getType());
        r.setDataExecutor(dataExecutor);
        r.setReportStorage(new StoredTemplateStream());
        return r;
    }

    @Override
    public byte[] readTemplate() throws KDRSException {
        return StorageUtil.readFile(this.storage, this.path.getChild(OBJ_TEMPLATE));
    }

    @Override
    public void writeTemplate(byte[] data) throws KDRSException {
        List parameters = this.gatherParameters(data);
        if (parameters != null) {
            ReportConfig objCfg = new ReportConfig();
            objCfg.setParamsters(parameters);
            ReportConfig rptCfg = BizContent_ReportConfigLoader.loadConfig(this.readConfig());
            rptCfg.setImports(objCfg.getImports());
            rptCfg.setParamsters(objCfg.getParamsters());
            try {
                Element xml = ReportConfig.Xml.toXml(rptCfg);
                byte[] confData = XmlUtil.saveXmlBytes((Element)xml);
                this.writeConfig(confData);
            }
            catch (IOException ex) {
                throw KDRSException.makeException("Failed in updating configure.", ex);
            }
        }
        new BizStorage(this.storage).writeFile(this.path.getChild(OBJ_TEMPLATE).getPathText(), -1, data);
    }

    @Override
    public byte[] readConfig() throws KDRSException {
        return StorageUtil.readFile(this.storage, this.path.getChild(OBJ_CONFIG));
    }

    @Override
    public void writeConfig(byte[] data) throws KDRSException {
        StorageUtil.writeFile(this.storage, this.path.getChild(OBJ_CONFIG), data);
    }

    @Override
    public Object getAttribute(String name) throws KDRSException {
        if ("last-tpl-modified".equals(name)) {
            return this.storage.getAttribute(this.path.getChild(OBJ_TEMPLATE), "last-modified");
        }
        return super.getAttribute(name);
    }

    @Override
    public void reset() throws KDRSException {
        throw new UnsupportedOperationException();
    }

    protected List gatherParameters(byte[] template) throws KDRSException {
        return null;
    }

    class StoredTemplateStream
    extends AStreamStorage {
        StoredTemplateStream() {
        }

        @Override
        public InputStream getInputStream() throws ReportException {
            try {
                return new ByteArrayInputStream(StoredDataX.this.readTemplate());
            }
            catch (Exception ex) {
                throw ReportException.makeException("", ex);
            }
        }

        @Override
        public OutputStream getOutputStream() throws ReportException {
            throw new ReportException("Unsupport!");
        }
    }
}

