/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz.content.objects.data;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.reportone.data.engine.script.java.JavaFileExecutor;
import com.kingdee.bos.ctrl.reportone.data.modal.DataDef;
import com.kingdee.bos.ctrl.reportone.data.modal.ProcessScript;
import com.kingdee.bos.ctrl.reportone.data.modal.io.Xml2DataDef;
import com.kingdee.bos.ctrl.reportone.data.modal.types.ScriptType;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.objects.StoredDataX;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.StoredObjectFactory;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import java.util.List;
import org.apache.log4j.Logger;

public class DataX_DataDef
extends StoredDataX {
    public static final Logger log = LogUtil.getPackageLogger(DataX_DataDef.class);
    private DataDef dataDef;

    public DataX_DataDef(IStorage storage, Path path, String type, StoredObjectFactory objFactory) {
        super(storage, path, type, objFactory);
    }

    protected DataDef parseObject(byte[] data) throws KDRSException {
        try {
            return Xml2DataDef.toObject(XmlUtil.loadXmlBytes((byte[])data));
        }
        catch (Exception e) {
            throw KDRSException.makeException("Bad format template.", e);
        }
    }

    @Override
    public void writeTemplate(byte[] data) throws KDRSException {
        ProcessScript ps;
        super.writeTemplate(data);
        if (this.dataDef != null && (ps = this.dataDef.getProcessScript()) != null && ps.getType() == ScriptType.JAVACODE) {
            new ComplieJavaCodeThread(ps.getScript()).start();
        }
    }

    @Override
    protected List gatherParameters(byte[] template) throws KDRSException {
        return this.gatherParameters(this.parseObject(template));
    }

    private List gatherParameters(DataDef data) throws KDRSException {
        if (data != null) {
            return data.getParameters();
        }
        return null;
    }

    class ComplieJavaCodeThread
    extends Thread {
        private String scriptText;

        ComplieJavaCodeThread(String scriptText) {
            this.scriptText = scriptText;
        }

        @Override
        public void run() {
            super.run();
            try {
                new JavaFileExecutor().complieJavaCode(this.scriptText);
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
            }
        }
    }
}

