/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects;

import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.AccessControl;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.refable.IRefableObject;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.refable.IRefableObjectContainer;
import java.util.HashMap;
import java.util.Iterator;

public class AccessControlTable
implements IRefableObjectContainer {
    private HashMap acTable = new HashMap();

    public AccessControlTable() {
        this(null);
    }

    public AccessControlTable(Iterator acls) {
        if (acls != null) {
            while (acls.hasNext()) {
                AccessControl ac = (AccessControl)acls.next();
                this.acTable.put(new Integer(ac.getId()), ac);
            }
        }
    }

    @Override
    public void addObject(IRefableObject r) {
        if (!(r instanceof AccessControl)) {
            throw new UnsupportedOperationException("addObject " + r);
        }
        AccessControl ac = (AccessControl)r;
        this.acTable.put(new Integer(ac.getId()), ac);
    }

    @Override
    public void delObject(IRefableObject r) {
        if (!(r instanceof AccessControl)) {
            throw new UnsupportedOperationException("delObject " + r);
        }
        AccessControl ac = (AccessControl)r;
        this.acTable.remove(new Integer(ac.getId()));
    }

    public AccessControl findPeer(int principal, int[] privileges) {
        AccessControl ac = new AccessControl(-1, principal, privileges);
        for (AccessControl t : this.acTable.values()) {
            if (!t.equals(ac)) continue;
            return t;
        }
        return null;
    }

    public AccessControl getAccessControl(int id) {
        return (AccessControl)this.acTable.get(new Integer(id));
    }

    public Iterator iterator() {
        return this.acTable.values().iterator();
    }
}

