/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects;

import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.SecObject;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.SecurityInfoIO;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.User;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;

public class UserGroup
extends User {
    private BitSet memberBits;
    private ArrayList members;

    public UserGroup(int id, HashMap allUsers) {
        super(id, allUsers);
        this.clearMembers();
    }

    private void refreshBits() {
        this.refreshBits(null);
    }

    private void refreshBits(UserGroup usergroup) {
        if (this.allUsers == null) {
            return;
        }
        Iterator<Object> i_users = usergroup == null ? this.allUsers.values().iterator() : usergroup.getMembersCopy().iterator();
        while (i_users.hasNext()) {
            User user = (User)i_users.next();
            if (!(user instanceof UserGroup)) continue;
            UserGroup t_usergroup = (UserGroup)user;
            t_usergroup.memberBits.clear();
            ArrayList members = t_usergroup.getMembersCopy();
            for (int i = 0; i < members.size(); ++i) {
                User member = (User)members.get(i);
                t_usergroup.memberBits.set(member.getId());
                if (!(member instanceof UserGroup)) continue;
                this.refreshBits((UserGroup)member);
                t_usergroup.memberBits.or(((UserGroup)member).memberBits);
            }
        }
    }

    public boolean containMember(User user, boolean directMember) {
        if (this.memberBits.get(user.getId())) {
            return !directMember || this.members.contains(user);
        }
        return false;
    }

    public boolean addMember(User user) {
        if (!this.members.contains(user)) {
            this.members.add(user);
            if (!SecurityInfoIO.checkUsersCycle(this.allUsers)) {
                this.members.remove(user);
                return false;
            }
            this.refreshBits();
        }
        return true;
    }

    public void removeMember(User user) {
        this.members.remove(user);
        this.refreshBits();
    }

    public void clearMembers() {
        this.memberBits = new BitSet();
        this.members = new ArrayList();
        this.refreshBits();
    }

    public ArrayList getMembersCopy() {
        return (ArrayList)this.members.clone();
    }

    public String getMembers() {
        StringBuffer s = new StringBuffer();
        for (SecObject obj : this.members) {
            s.append(obj.getId());
            s.append(',');
        }
        if (s.length() > 0) {
            s.setLength(s.length() - 1);
        }
        return s.toString();
    }

    public boolean setMembers(ArrayList list) {
        ArrayList bak = this.members;
        this.members = list;
        if (!SecurityInfoIO.checkUsersCycle(this.allUsers)) {
            this.members = bak;
            return false;
        }
        this.refreshBits();
        return true;
    }
}

