/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects;

import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.AccessControl;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.Privilege;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.Rule;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.SecObject;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.User;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.UserGroup;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class Xml2SecObj {
    public static final HashMap loadUsers(Element e) {
        if (e.getName().equals("Users")) {
            HashMap<Integer, User> users = new HashMap<Integer, User>();
            List children = e.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                User user = Xml2SecObj.loadUser((Element)children.get(i), users);
                users.put(new Integer(user.getId()), user);
            }
            return users;
        }
        throw new IllegalArgumentException("expect XML TAG 'Users' or 'UserGroups'");
    }

    public static final User loadUser(Element e, HashMap users) {
        if (e.getName().equals("User") || e.getName().equals("UserGroup")) {
            int id = Integer.parseInt(e.getAttributeValue("id"));
            User user = e.getName().equals("User") ? new User(id, users) : new UserGroup(id, users);
            user.setProperties(Xml2SecObj.attributes2HashMap(e.getAttributes()));
            return user;
        }
        throw new IllegalArgumentException("expect XML TAG 'User' or 'UserGroup'");
    }

    public static final HashMap loadPrivileges(Element e) {
        if (e.getName().equals("Privileges")) {
            HashMap<Integer, Privilege> privileges = new HashMap<Integer, Privilege>();
            List children = e.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Privilege o = Xml2SecObj.loadPrivilege((Element)children.get(i));
                privileges.put(new Integer(o.getId()), o);
            }
            return privileges;
        }
        throw new IllegalArgumentException("expect XML TAG 'Privileges'.");
    }

    public static final Privilege loadPrivilege(Element e) {
        if (e.getName().equals("Privilege")) {
            Privilege o = new Privilege();
            Xml2SecObj.loadSecObject(o, e);
            return o;
        }
        throw new IllegalArgumentException("expect XML TAG 'Privilege'");
    }

    public static final HashMap loadACTable(Element e) {
        if (e.getName().equals("ACs")) {
            HashMap<Integer, AccessControl> h = new HashMap<Integer, AccessControl>();
            List children = e.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                AccessControl o = Xml2SecObj.loadAccessControl((Element)children.get(i));
                h.put(new Integer(o.getId()), o);
            }
            return h;
        }
        throw new IllegalArgumentException("expect XML TAG 'ACs'");
    }

    public static final AccessControl loadAccessControl(Element e) {
        if (e.getName().equals("AC")) {
            AccessControl o = new AccessControl();
            Xml2SecObj.loadSecObject(o, e);
            o.setPrincipalId(Integer.parseInt(e.getAttributeValue("principal")));
            o.setPrivilegeIds("" + e.getAttributeValue("privileges"));
            o.setProperties(null);
            return o;
        }
        throw new IllegalArgumentException("expect XML TAG 'AC'");
    }

    public static final HashMap loadRules(Element e) {
        if (e.getName().equals("Rules")) {
            HashMap<Integer, Rule> h = new HashMap<Integer, Rule>();
            List children = e.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Rule o = Xml2SecObj.loadRule((Element)children.get(i));
                h.put(new Integer(o.getId()), o);
            }
            return h;
        }
        throw new IllegalArgumentException("expect XML TAG 'Rules'");
    }

    public static final Rule loadRule(Element e) {
        if (e.getName().equals("Rule")) {
            Rule o = new Rule();
            Xml2SecObj.loadSecObject(o, e);
            o.setACIdList((String)o.getProperties().get("acs"));
            String refsStr = e.getAttributeValue("refs");
            if (refsStr != null) {
                for (int i = 1; i < Integer.parseInt(refsStr); ++i) {
                    o.addRef();
                }
            }
            o.setProperties(null);
            return o;
        }
        throw new IllegalArgumentException("expect XML TAG 'Rule'");
    }

    public static final void loadSecObject(SecObject secObj, Element e) {
        int id = Integer.parseInt(e.getAttributeValue("id"));
        secObj.setId(id);
        e.removeAttribute("id");
        if (e.getAttributeValue("builtin") != null) {
            e.removeAttribute("builtin");
            secObj.setBuiltIn();
        }
        secObj.setProperties(Xml2SecObj.attributes2HashMap(e.getAttributes()));
    }

    public static final HashMap attributes2HashMap(List attrs) {
        if (attrs == null || attrs.size() == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = (Attribute)attrs.get(i);
            map.put(attr.getName(), attr.getValue());
        }
        return map;
    }
}

