/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.ReflectUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.IBizSecurity;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.User;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.ISession;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.KdrsConfigure;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.server.IServerSideBizObject;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.server.IServerSideEngine;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.server.IServerSideSession;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.LoginException;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.AbstractKdrsEngine;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.KdrsConfigLoader;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.KdrsServerSideSessionManager;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.Org;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.OrgManager;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.StorageLoaderFactory;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.StoredObjectFactory;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.StorageProxy;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class KdrsServerEngine
extends AbstractKdrsEngine
implements IServerSideEngine {
    private static final String STORAGE_CONFIGURE_FILE = "StorageConfig.xml";
    public static final Logger log = LogUtil.getLogger(KdrsServerEngine.class);
    public static KdrsServerEngine instance;
    protected KdrsServerSideSessionManager sessionManager;
    protected Object storageConfig;
    protected IStorage rootStorage;
    protected OrgManager orgManager;
    protected ReflectUtil.IvkListenerList bizListeners = new ReflectUtil.IvkListenerList();

    public static KdrsServerEngine getInstance() throws KDRSException {
        if (instance == null) {
            instance = new KdrsServerEngine();
        }
        return instance;
    }

    public KdrsServerEngine() throws KDRSException {
        this.storageConfig = KdrsConfigLoader.loadStorageConfigure(CtrlUtil.Stream.loadResource(KdrsServerEngine.class, (String)STORAGE_CONFIGURE_FILE));
        this.sessionManager = new KdrsServerSideSessionManager(1800000L, 600000L);
        this.orgManager = new OrgManager();
    }

    @Override
    public IStorage getStorage(String ais) throws KDRSException {
        if (ais != null && ais.length() != 0) {
            log.warn((Object)"Couldn't support specified data center,replace with default.");
        }
        if (this.rootStorage == null) {
            this.rootStorage = StorageLoaderFactory.createLoader(this.storageConfig, this).loadStorage(ais);
        }
        return this.rootStorage;
    }

    @Override
    protected Object createBizObject(Class objCls, ISession session) throws KDRSException {
        IServerSideBizObject bizObject = null;
        String bizClass = null;
        if (objCls == IBizStorage.class) {
            bizClass = "com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorage";
        } else if (objCls == IBizContent.class) {
            bizClass = "com.kingdee.bos.ctrl.reportone.kdrs.biz.content.BizContent";
        } else if (objCls == IBizSecurity.class) {
            bizClass = "com.kingdee.bos.ctrl.report.biz.security.BizSecurity";
        }
        try {
            bizObject = (IServerSideBizObject)Class.forName(bizClass).newInstance();
        }
        catch (Exception ex) {
            throw KDRSException.makeException("Create bizObject,", ex);
        }
        bizObject.attachToSessoin(session);
        return ReflectUtil.makeMonitableObject((Object)bizObject, (ReflectUtil.IIvkListener)this.getBizListeners());
    }

    public void shutdown() {
    }

    private User checkUser(Org orgObj, String user, String pwd) throws KDRSException {
        User userObj = orgObj.getSecurityInfo().getUserByName(user);
        if (userObj == null) {
            throw new LoginException("Not found user:" + user);
        }
        Object realPwd = null;
        HashMap props = userObj.getProperties();
        if (props != null) {
            realPwd = props.get("password");
        }
        if (!CtrlUtil.Obj.equals((Object)pwd, realPwd)) {
            throw new LoginException("Error password.");
        }
        return userObj;
    }

    @Override
    public ISession login(String org, String user, String pwd, String lang) throws KDRSException {
        Path orgPath;
        IServerSideSession session = this.sessionManager.createSession();
        Org orgObj = this.orgManager.getOrg(org);
        User userObj = this.checkUser(orgObj, user, pwd);
        IStorage gStorage = this.getStorage("");
        if (!gStorage.isExist(orgPath = Path.valueOf(org))) {
            gStorage.create(orgPath, ResourceType.FOLDER, null);
        }
        StorageProxy sto = new StorageProxy(gStorage, orgPath);
        session.setProperty("org", orgObj);
        session.setProperty("lang", lang);
        session.setProperty("user", userObj);
        session.setStorage(sto);
        if (orgObj.getObjFactory() == null) {
            StoredObjectFactory objFactory = new StoredObjectFactory(sto, KdrsConfigure.typesConf, "category");
            orgObj.setObjFactory(objFactory);
        }
        session.setBizObjectFactory(orgObj.getObjFactory());
        return session;
    }

    @Override
    public void logout(ISession session) throws KDRSException {
        if (session != null) {
            this.sessionManager.removeSession(session.getSid());
            super.logout(session);
        }
    }

    @Override
    public IServerSideSession lookupSession(String sid) throws KDRSException {
        return this.sessionManager.getSession(sid);
    }

    @Override
    public ReflectUtil.IvkListenerList getBizListeners() {
        return this.bizListeners;
    }
}

