/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage;

import com.kingdee.bos.ctrl.common.NullValue;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.ObjectUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyExistsException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.DeleteException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.InvalidPathException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.BasicStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IRandomAccessStream;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ISpaceProvider;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.StorageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.FolderMeta;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.IFolderMeta;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.ILazyFolderMeta;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.IMetas;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.IResourceMeta;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.PersistentMetas;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class Storage
extends BasicStorage
implements IStorage {
    private static Logger log = LogUtil.getPackageLogger(Storage.class);
    protected ISpaceProvider space;
    protected IMetas metas;

    public Storage(ISpaceProvider space, IMetas metas) {
        this.space = space;
        this.metas = metas;
    }

    public Storage(ISpaceProvider spaceProvider) throws KDRSException {
        this(spaceProvider, new PersistentMetas(spaceProvider));
    }

    @Override
    public final void copyFile(Path srcFile, Path destFile) throws KDRSException {
        if (!StorageUtil.checkCopyParameters(srcFile, destFile)) {
            return;
        }
        boolean needCopyAttrs = true;
        IResourceMeta srcMeta = this.checkAsFile(srcFile, true);
        IResourceMeta destMeta = null;
        Path destParentPath = destFile.getParent();
        ILazyFolderMeta destParentMeta = this.metas.getFolderMeta(destParentPath);
        if (destParentMeta == null) {
            throw new NotFoundException("Couldn't find resource '" + destParentPath + "'.");
        }
        destMeta = destParentMeta.getChild(destFile.getName());
        if (destMeta != null) {
            if (destMeta.getType() == ResourceType.FOLDER) {
                throw new InvalidPathException("'" + destFile + "' must be a folder.");
            }
        } else {
            needCopyAttrs = false;
            HashMap srcAttrs = srcMeta.getAttributes();
            if (srcAttrs != null) {
                srcAttrs = (HashMap)srcAttrs.clone();
            }
            destMeta = this.internalCreate(destFile, ResourceType.FILE, srcAttrs, true);
        }
        this.copyFile(srcFile, destFile, srcMeta, destMeta, needCopyAttrs);
    }

    private void copyFile(Path file0, Path file1, IResourceMeta meta0, IResourceMeta meta1, boolean needCopyAttrs) throws KDRSException {
        this.space.copyFile(file0, file1);
        if (needCopyAttrs) {
            HashMap attrs = (HashMap)ObjectUtil.cloneObject((Object)meta0.getAttributes());
            if (attrs != null) {
                attrs.remove("name");
            }
            meta1.setAttributes(attrs);
            this.metas.updateMeta(file1, meta1);
        }
    }

    private IResourceMeta internalCreate(Path path, ResourceType type, HashMap attrs, boolean attrsIsCopied) throws KDRSException {
        if (type == null) {
            type = ResourceType.FILE;
        }
        if (attrs != null) {
            attrs.remove("name");
        }
        try {
            this.space.allocate(path, type == ResourceType.FILE);
        }
        catch (AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
        String name = path.getName();
        Path parent = path.getParent();
        ILazyFolderMeta parentMeta = this.metas.getFolderMeta(parent);
        IResourceMeta meta = this.metas.createResourceMeta(name, type);
        meta.setAttributes((HashMap)ObjectUtil.cloneObject((Object)attrs));
        parentMeta.addChild(meta);
        this.metas.updateMeta(path, meta);
        if (type == ResourceType.FOLDER) {
            ((ILazyFolderMeta)meta).setChildrenLoaded();
        }
        return meta;
    }

    @Override
    public final void create(Path path, ResourceType type, HashMap attrs) throws KDRSException {
        StorageUtil.checkIsNotRoot(path);
        this.checkMeta(path.getParent(), true);
        this.checkMeta(path, false);
        StorageUtil.checkAttrsNameLength(attrs);
        this.internalCreate(path, type, attrs, false);
    }

    @Override
    public final void delete(Path path) throws KDRSException {
        StorageUtil.checkIsNotRoot(path);
        IResourceMeta meta = this.checkMeta(path, true);
        if (meta.getType() == ResourceType.FOLDER) {
            IFolderMeta folderMeta = (IFolderMeta)meta;
            if (folderMeta.hasChild()) {
                throw new DeleteException("The folder '" + path + "' is not empty.");
            }
            try {
                this.space.free(path.getChild(".meta"));
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        try {
            this.space.free(path);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        meta.getParent().removeChild(meta.getName());
        this.metas.updateMeta(path, meta);
    }

    @Override
    public final int getFileLength(Path path) throws KDRSException {
        this.checkAsFile(path, true);
        return this.space.getLength(path);
    }

    @Override
    public final IRandomAccessStream getFileStream(Path path, boolean clear, boolean readOnly) throws KDRSException {
        this.checkAsFile(path, true);
        return this.space.openStream(path, clear, false, readOnly);
    }

    @Override
    public final ResourceType getType(Path path) throws KDRSException {
        return this.checkMeta(path, true).getType();
    }

    @Override
    public boolean isExist(Path path) throws KDRSException {
        try {
            this.checkMeta(path, true);
            return true;
        }
        catch (NotFoundException ex) {
            return false;
        }
    }

    @Override
    public final String[] listChildren(Path path) throws KDRSException {
        this.checkAsFile(path, false);
        ILazyFolderMeta meta = this.metas.getFolderMeta(path);
        if (meta == null) {
            log.warn((Object)("Load folder meta failded, path:'" + path + "'"));
            return NullValue.NULL_STRING_ARRAY;
        }
        return meta.listChildren();
    }

    @Override
    public final void rename(Path path, String newName) throws KDRSException {
        StorageUtil.checkIsNotRoot(path);
        if (path.getName().equalsIgnoreCase(newName)) {
            return;
        }
        IResourceMeta meta = this.checkMeta(path, true);
        this.checkMeta(path.getParent().getChild(newName), false);
        this.space.rename(path, newName);
        meta.setName(newName);
        this.metas.updateMeta(path, meta);
    }

    @Override
    public final void move(Path path1, Path path2) throws KDRSException {
        StorageUtil.checkIsNotRoot(path1);
        StorageUtil.checkIsNotRoot(path2);
        if (path1.getParent().equals(path2.getParent())) {
            this.rename(path1, path2.getName());
            return;
        }
        IResourceMeta metaPath1 = this.checkMeta(path1, true);
        IFolderMeta metaPath2Parent = (IFolderMeta)this.checkAsFile(path2.getParent(), false);
        this.checkMeta(path2, false);
        if (path1.isFatherOf(path2, false) || path2.isFatherOf(path1, false)) {
            throw new InvalidPathException("Couldn't move " + path1 + " to " + path2);
        }
        FolderMeta metaPath1Parent = metaPath1.getParent();
        metaPath1Parent.removeChild(path1.getName());
        metaPath2Parent.addChild(metaPath1);
        this.space.move(path1, path2);
        this.metas.updateFolderMeta(path1.getParent(), (ILazyFolderMeta)((Object)metaPath1Parent));
        this.metas.updateFolderMeta(path2.getParent(), (ILazyFolderMeta)metaPath2Parent);
    }

    @Override
    protected void setAttributes(Path path, HashMap attrs, boolean updateNow) throws KDRSException {
        IResourceMeta meta = this.checkMeta(path, true);
        if (attrs != null) {
            attrs.remove("name");
        }
        meta.setAttributes(attrs);
        if (updateNow) {
            this.metas.updateMeta(path, meta);
        }
    }

    @Override
    protected final HashMap getAttributesRef(Path path) throws KDRSException {
        IResourceMeta meta = this.checkMeta(path, true);
        return meta.getAttributes();
    }

    @Override
    public final void refresh(Path path, boolean recursion) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refresh resource:" + path));
        }
        this.checkAsFile(path, false);
        ILazyFolderMeta folderMeta = this.metas.getFolderMeta(path);
        HashMap rawChildren = this.space.list(path);
        Set rawNames = rawChildren.keySet();
        String[] names = folderMeta.listChildren();
        for (int i = 0; i < names.length; ++i) {
            if (rawNames.contains(names[i])) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove redundant meta:" + names[i]));
            }
            folderMeta.removeChild(names[i]);
        }
        for (String rawName : rawNames) {
            IResourceMeta meta;
            Path childPath;
            ResourceType rawType = (ResourceType)rawChildren.get(rawName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Raw node name:" + rawName + ", type:" + rawType));
            }
            if (this.metas.isReservedPath(childPath = path.getChild(rawName))) continue;
            IResourceMeta childMeta = folderMeta.getChild(rawName);
            if (childMeta == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Create meta for raw node.");
                }
                meta = this.metas.createResourceMeta(rawName, rawType);
                folderMeta.addChild(meta);
            } else if (childMeta.getType() != rawType) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Update meta with raw node.");
                }
                folderMeta.removeChild(rawName);
                meta = this.metas.createResourceMeta(rawName, rawType);
                folderMeta.addChild(meta);
            }
            if (rawType != ResourceType.FOLDER || !recursion) continue;
            this.refresh(childPath, true);
        }
        this.metas.updateFolderMeta(path, folderMeta);
    }

    protected IResourceMeta checkMeta(Path resource, boolean checkExist) throws KDRSException {
        IResourceMeta meta = this.metas.getMeta(resource);
        if (checkExist) {
            if (meta == null) {
                throw new NotFoundException("Couldn't found resource '" + resource + "'");
            }
        } else if (meta != null) {
            throw new AlreadyExistsException("The resource '" + resource + "' has already exist.");
        }
        return meta;
    }

    protected IResourceMeta checkAsFile(Path resource, boolean checkAsFile) throws KDRSException {
        IResourceMeta meta = this.checkMeta(resource, true);
        if (checkAsFile) {
            if (meta.getType() != ResourceType.FILE) {
                throw new InvalidPathException("The resource '" + resource + "' must be file type.");
            }
        } else if (meta.getType() != ResourceType.FOLDER) {
            throw new InvalidPathException("The resource '" + resource + "' must be folder type.");
        }
        return meta;
    }

    public String toString() {
        return "Storage2@" + this.hashCode() + " [space=" + this.space + ",metas=" + this.metas + "]";
    }
}

