/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyExistsException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.InvalidParameterException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.InvalidPathException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IRandomAccessStream;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.StorageProxy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class StorageUtil {
    public static void clearFileData(IStorage storage, Path filePath) throws KDRSException {
        IRandomAccessStream stream = null;
        try {
            stream = storage.getFileStream(filePath, true, false);
        }
        finally {
            if (stream != null) {
                StorageUtil.closeStream(stream);
            }
        }
    }

    public static void checkIsNotRoot(Path path) throws KDRSException {
        StorageUtil.checkPath(path, false);
    }

    public static final void checkPath(Path path, boolean canBeRoot) throws KDRSException {
        if (path == null) {
            throw new InvalidParameterException();
        }
        if (path.isRoot() && !canBeRoot) {
            throw new InvalidPathException("Couldn't support this type of operation on ROOT.");
        }
    }

    public static void closeStream(IRandomAccessStream stream) {
        try {
            stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean checkCopyParameters(Path srcPath, Path destPath) throws KDRSException {
        if (destPath.isFatherOf(srcPath, true)) {
            return false;
        }
        if (srcPath.isFatherOf(destPath, false)) {
            throw new InvalidPathException("Coudln't copy " + srcPath + " to " + destPath);
        }
        if (srcPath.equals(destPath)) {
            throw new InvalidParameterException("Coludn't copy it to self.");
        }
        return true;
    }

    public static final Path checkPathText(String pathText) throws KDRSException {
        Path path = Path.valueOf(pathText);
        if (path == null) {
            throw new InvalidPathException(pathText);
        }
        return path;
    }

    public static final void checkAttrsNameLength(HashMap attrs) throws KDRSException {
        if (attrs == null) {
            return;
        }
        for (String name : attrs.keySet()) {
            if (name.length() <= 32) continue;
            throw new InvalidParameterException("Attribute name '" + name + "' is too long,max length is " + 32);
        }
    }

    public static void checkAttrsForSet(Path path, ResourceType resType, HashMap attrs) throws KDRSException {
        if (attrs != null) {
            Object attr = attrs.get("name");
            if (attr != null && !attr.equals(path.getName())) {
                throw new KDRSException("Can't assign name attribute to resource,you can use rename function!");
            }
            attr = attrs.get("type");
            if (attr != null && !attr.equals(resType.getName())) {
                throw new KDRSException("Can't assign type attribute to resource!");
            }
        }
    }

    public static void checkResourceName(String name) throws KDRSException {
        if (name == null) {
            return;
        }
        if (name.length() > 128) {
            throw new InvalidParameterException("Resource name '" + name + "' is too long,max length is " + 128);
        }
    }

    public static void writeFile(IStorage sto, Path path, byte[] data) throws KDRSException {
        OutputStream stream = null;
        try {
            stream = sto.getFileStream(path, true, false).getOutputStream();
            CtrlUtil.Stream.copy((InputStream)new ByteArrayInputStream(data), (OutputStream)stream, (int)16384);
        }
        catch (IOException ex) {
            try {
                throw KDRSException.makeException("Read file error,path=" + path, ex);
            }
            catch (Throwable throwable) {
                CtrlUtil.Stream.closeStream(stream);
                throw throwable;
            }
        }
        CtrlUtil.Stream.closeStream((OutputStream)stream);
    }

    public static void copyFile(IStorage srcSto, Path srcPath, IStorage targetSto, Path targetPath) throws KDRSException {
        HashMap srcAttrs = srcSto.getAttributes(srcPath);
        try {
            targetSto.create(targetPath, ResourceType.FILE, srcAttrs);
        }
        catch (AlreadyExistsException e) {
            targetSto.setAttributes(targetPath, srcAttrs);
        }
        IRandomAccessStream src_stream = srcSto.getFileStream(srcPath, false, true);
        IRandomAccessStream target_stream = targetSto.getFileStream(targetPath, true, false);
        try {
            CtrlUtil.Stream.copy((InputStream)src_stream.getInputStream(), (OutputStream)target_stream.getOutputStream(), (int)16384);
        }
        catch (IOException ex) {
            throw KDRSException.makeException("copy file error.", ex);
        }
        finally {
            StorageUtil.closeStream(src_stream);
            StorageUtil.closeStream(target_stream);
        }
    }

    public static byte[] readFile(IStorage sto, Path path) throws KDRSException {
        byte[] byArray;
        InputStream stream = null;
        try {
            stream = sto.getFileStream(path, false, true).getInputStream();
            byArray = CtrlUtil.Stream.readInputStream((InputStream)stream);
        }
        catch (IOException ex) {
            try {
                throw KDRSException.makeException("Read file error,path=" + path, ex);
            }
            catch (Throwable throwable) {
                CtrlUtil.Stream.closeStream(stream);
                throw throwable;
            }
        }
        CtrlUtil.Stream.closeStream((InputStream)stream);
        return byArray;
    }

    public static void copyStorage(IStorage srcSto, Path srcPath, IStorage targetSto, Path targetPath) throws KDRSException {
        StorageUtil.copyStorage(new StorageProxy(srcSto, srcPath), new StorageProxy(targetSto, targetPath));
    }

    public static void copyStorage(IStorage srcSto, IStorage targetSto) throws KDRSException {
        StorageUtil.cloneStyleCopyFolder(srcSto, Path.ROOT, targetSto, Path.ROOT);
    }

    private static void cloneStyleCopyFolder(IStorage provider0, Path path0, IStorage provider1, Path path1) throws KDRSException {
        HashMap attributes = null;
        if (!path1.isRoot()) {
            try {
                attributes = provider0.getAttributes(path0);
                provider1.create(path1, ResourceType.FOLDER, attributes);
            }
            catch (AlreadyExistsException ex) {
                provider1.setAttributes(path1, attributes);
            }
        }
        String[] children = provider0.listChildren(path0);
        for (int i = 0; i < children.length; ++i) {
            String name = children[i];
            ResourceType type = provider0.getType(path0.getChild(name));
            if (type == ResourceType.FILE) {
                StorageUtil.copyFile(provider0, path0.getChild(name), provider1, path1.getChild(name));
                continue;
            }
            StorageUtil.cloneStyleCopyFolder(provider0, path0.getChild(name), provider1, path1.getChild(name));
        }
    }

    public static void walk(IStorage storage, Path path, IStorageWalk walker) throws KDRSException {
        ResourceType type = storage.getType(path);
        if (!walker.walk(storage, path, type == ResourceType.FOLDER)) {
            return;
        }
        if (type == ResourceType.FOLDER) {
            String[] children = storage.listChildren(path);
            for (int i = 0; i < children.length; ++i) {
                StorageUtil.walk(storage, path.getChild(children[i]), walker);
            }
        }
    }

    public static interface IStorageWalk {
        public boolean walk(IStorage var1, Path var2, boolean var3) throws KDRSException;
    }
}

