/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.data;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.reportone.data.modal.ParamUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.check.ErrorInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.EventListenerList;

public abstract class AbstractR1DataManager
implements IR1DataManager {
    private ArrayList _listExts;
    private HashMap _cacheDatas;
    private MetaClass _systemParams;
    private EventListenerList _listenerList = new EventListenerList();
    private boolean _isListenerUseful = true;

    public AbstractR1DataManager() {
        this._listExts = new ArrayList();
        this._cacheDatas = new HashMap();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this._listenerList.add(PropertyChangeListener.class, l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this._listenerList.remove(PropertyChangeListener.class, l);
    }

    protected void firePropertyChangeEvent(String key, Object oldValue, Object newValue) {
        if (!this._isListenerUseful) {
            return;
        }
        Object[] list = this._listenerList.getListenerList();
        PropertyChangeEvent evt = null;
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != PropertyChangeListener.class) continue;
            if (evt == null) {
                evt = new PropertyChangeEvent(this, key, oldValue, newValue);
            }
            ((PropertyChangeListener)list[i + 1]).propertyChange(evt);
        }
    }

    @Override
    public void setListenerUseful(boolean isUseful) {
        this._isListenerUseful = isUseful;
    }

    @Override
    public boolean isSupportSystemParams() {
        return true;
    }

    @Override
    public void setSystemParams(MetaClass systemParams) {
        this._systemParams = new MetaClass();
        if (systemParams != null) {
            this._systemParams.copy((IDefObj)systemParams);
        }
        this._systemParams.setName("context");
        this._systemParams.setType("param.context");
        if (systemParams != null) {
            this._systemParams.setFields(systemParams.getFields());
        }
    }

    @Override
    public MetaClass getSystemParams() {
        return this._systemParams;
    }

    @Override
    public boolean isNameExist(String name, DataExtend self) {
        for (DataExtend ext : this._listExts) {
            if (self == ext || !StringUtil.equalsIgnoreCase((String)name, (String)ext.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNameKeyWord(String name) {
        return StringUtil.equalsIgnoreCase((String)name, (String)"report") || StringUtil.equalsIgnoreCase((String)name, (String)"context");
    }

    @Override
    public boolean isAliasExist(String alias, DataExtend self) {
        for (DataExtend ext : this._listExts) {
            if (self == ext || StringUtil.isEmptyString((String)alias) || !StringUtil.equalsIgnoreCase((String)alias, (String)ext.getAlias())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addData(DataExtend ext, Object realData) {
        this._listExts.add(ext);
        this._cacheDatas.put(ext.getName(), realData);
        this.firePropertyChangeEvent("add", null, (Object)ext);
    }

    @Override
    public void insertData(int index, DataExtend ext, Object realData) {
        ext.setProperty("index", new Integer(index));
        this._listExts.add(index, ext);
        this._cacheDatas.put(ext.getName(), realData);
        this.firePropertyChangeEvent("insert", null, (Object)ext);
    }

    @Override
    public void remveData(DataExtend ext) {
        if (this._listExts.remove((Object)ext)) {
            this._cacheDatas.remove((Object)ext);
            this.firePropertyChangeEvent("delete", null, (Object)ext);
        }
    }

    @Override
    public void renameData(DataExtend ext, String oldName, String newName) {
        Object relaData = this._cacheDatas.remove(oldName);
        this._cacheDatas.put(newName, relaData);
        this.firePropertyChangeEvent("rename", oldName, (Object)ext);
    }

    @Override
    public void realiasData(DataExtend ext) {
        this.firePropertyChangeEvent("realias", null, (Object)ext);
    }

    @Override
    public void editDataParam(DataExtend ext) {
        this.firePropertyChangeEvent("report param", null, (Object)ext);
    }

    @Override
    public Object getObject(String name) {
        if (StringUtil.equalsIgnoreCase((String)name, (String)"report")) {
            return this.mcOfReportParam();
        }
        if (StringUtil.equalsIgnoreCase((String)name, (String)"context")) {
            return this.getSystemParams();
        }
        return this._cacheDatas.get(name);
    }

    @Override
    public DataExtend[] getDataExtends() {
        return this._listExts.toArray(new DataExtend[0]);
    }

    @Override
    public DataExtend[] getAllDataExtends(String[] keysIncluded) {
        ArrayList<DataExtend> list = new ArrayList<DataExtend>();
        if (keysIncluded != null) {
            for (int i = 0; i < keysIncluded.length; ++i) {
                DataExtend ext = this.getIncluded(keysIncluded[i]);
                if (ext == null) continue;
                list.add(ext);
            }
        }
        list.addAll(this._listExts);
        return list.toArray(new DataExtend[0]);
    }

    private DataExtend getIncluded(String key) {
        if ("param.context".equals(key) && this.isSupportSystemParams()) {
            return DataExtend.createSysParamDataExt();
        }
        if ("param.report".equals(key) && this.isSupportReportParams()) {
            return DataExtend.createReportParamDataExt();
        }
        return null;
    }

    @Override
    public DataExtend getDataExtend(String name) {
        if (StringUtil.equalsIgnoreCase((String)name, (String)"report")) {
            return DataExtend.createReportParamDataExt();
        }
        if (StringUtil.equalsIgnoreCase((String)name, (String)"context")) {
            return DataExtend.createSysParamDataExt();
        }
        for (DataExtend ext : this._listExts) {
            if (!StringUtil.equalsIgnoreCase((String)name, (String)ext.getName())) continue;
            return ext;
        }
        return null;
    }

    @Override
    public String getNameByObj(Object obj) {
        MetaClass mc;
        if (obj instanceof MetaClass && (StringUtil.equalsIgnoreCase((String)(mc = (MetaClass)obj).getName(), (String)"report") || StringUtil.equalsIgnoreCase((String)mc.getName(), (String)"context"))) {
            return mc.getName();
        }
        for (String key : this._cacheDatas.keySet()) {
            if (!obj.equals(this._cacheDatas.get(key))) continue;
            return key;
        }
        return null;
    }

    private MetaClass mcOfReportParam() {
        List mfs = ParamUtil.params2MetaFields(this.getReportParams());
        MetaClass mc = new MetaClass();
        mc.setType("param.report");
        mc.setName("report");
        mc.setFields(mfs);
        return mc;
    }

    @Override
    public ErrorInfo[] checkError() {
        return null;
    }
}

