/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.AbstractElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.IGridsFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.IPropertyPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import java.util.ArrayList;

public abstract class AbstractRow
extends AbstractElement {
    private ArrayList _cells;
    private int _height;
    private boolean _isFixedHeight = true;
    private int _priY = 0;

    protected abstract IGridsFactory getGridsFactory();

    public AbstractRow(int size) {
        this._cells = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.addCell();
        }
    }

    protected AbstractCell getCreatedCell() {
        return this.getGridsFactory().createCell();
    }

    AbstractCell addCell() {
        AbstractCell cell = this.getCreatedCell();
        return this.addCell(this._cells.size(), cell);
    }

    AbstractCell insertCell(int cellIndex) {
        AbstractCell cell = this.getGridsFactory().createCell();
        return this.addCell(cellIndex, cell);
    }

    private AbstractCell addCell(int cellIndex, AbstractCell cell) {
        if (cellIndex < 0 || cellIndex > this._cells.size()) {
            return null;
        }
        this._cells.add(cellIndex, cell);
        return cell;
    }

    AbstractCell removeCell(int cellIndex) {
        if (cellIndex < 0 || cellIndex >= this._cells.size()) {
            return null;
        }
        return (AbstractCell)this._cells.remove(cellIndex);
    }

    public AbstractCell getCell(int cellIndex) {
        if (cellIndex < 0 || cellIndex >= this._cells.size()) {
            return null;
        }
        return (AbstractCell)this._cells.get(cellIndex);
    }

    public int getCellCount() {
        return this._cells.size();
    }

    ArrayList getCells() {
        return this._cells;
    }

    public void setHeightLom(int h) {
        this._height = h;
    }

    public int getHeightLom() {
        return this._height;
    }

    public void setFixedHeight(boolean isFixedHeight) {
        this._isFixedHeight = isFixedHeight;
    }

    public boolean isFixedHeight() {
        return this._isFixedHeight;
    }

    public int getFeatHeight() {
        int h = Util.lom2Pixel(this._height);
        return h < 2 ? 2 : h;
    }

    public int getPriY() {
        return this._priY;
    }

    public void setPriY(int priY) {
        this._priY = priY;
    }

    @Override
    public String getIdPrefix() {
        return "row";
    }

    @Override
    public IPropertyPanel getExtendPropertyPanel(String key) {
        return null;
    }
}

