/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.IActionExit;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.IActionManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.event.StateChangedEvent;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.event.StateChangedListener;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.IReportUI;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.DataTree;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.PageContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.State;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.Toolbox;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ToolboxLoader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.owner.IR1DesignerOwner;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.wizard.IReportWizard;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.IR1Page;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IDataXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlReader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlReaderWriterFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.ISaver;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.IConfigFileCreator;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.ISimpleStatusBarRenderer;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDStatusBar;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.SimpleStatusBarPart;
import com.kingdee.bos.ctrl.swing.SimpleStatusBarRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JProgressBar;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public abstract class AbstractR1Designer {
    private boolean _isSingleRun = false;
    private IR1DesignerOwner owner;
    private KDMenuBar _menuBar;
    private JProgressBar pgb;
    private KDStatusBar statusBar;
    private KDPanel _topPane;
    protected State _state;
    private EventListenerList eventListenerList = new EventListenerList();
    private ComboPanel _core;
    private IActionManager _actionManager;
    private IObjectSelector _dataSelector;
    private ISaver _saver;
    private IDataXmlTrans _dataXmlTrans;
    private MetaClass _systemParams;

    public AbstractR1Designer(IR1DesignerOwner owner) {
        this.owner = owner;
    }

    public void setSingleRun(boolean isSingleRun) {
        this._isSingleRun = isSingleRun;
    }

    protected abstract String getTitle();

    protected abstract IConfigFileCreator getMenuConfigCreator();

    protected abstract IConfigFileCreator getToolboxConfigCreator();

    protected abstract IConfigFileCreator getPopupMenuConfigCreator();

    protected abstract IActionManager createActionManager(AbstractR1Designer var1, Element var2);

    protected abstract IDataXmlTrans createDataXmlTrans();

    protected State getState() {
        if (this._state == null) {
            this._state = new State();
        }
        return this._state;
    }

    protected KDMenuBar getMenuBar() {
        if (this._menuBar == null) {
            this._menuBar = new KDMenuBar();
            this._menuBar.setLogo(null);
        }
        return this._menuBar;
    }

    protected Container getTopPane() {
        if (this._topPane == null) {
            this._topPane = new KDPanel((LayoutManager)new BorderLayout());
        }
        return this._topPane;
    }

    public ComboPanel getCore() {
        return this._core;
    }

    public IR1DesignerOwner getOwner() {
        return this.owner;
    }

    public void init() {
        this.getOwner().setTitle(this.getTitle());
        this.initFrame();
        this.initComponents();
    }

    private void initFrame() {
        this.getOwner().setJMenuBar((JMenuBar)this.getMenuBar());
        this.initStatusBar();
        this.getOwner().getContentPane().setLayout(new BorderLayout());
        this.getOwner().getContentPane().add((Component)this.getTopPane(), "Center");
        this.getOwner().setSize(800, 600);
        this.getOwner().setLocationRelativeTo(null);
    }

    public void addStateChangedListener(StateChangedListener l) {
        this.eventListenerList.add(StateChangedListener.class, l);
    }

    public void removeStateChangedListener(StateChangedListener l) {
        this.eventListenerList.remove(StateChangedListener.class, l);
    }

    protected void fireStateChangedEvent(State state) {
        Object[] listeners = this.eventListenerList.getListenerList();
        StateChangedEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != StateChangedListener.class) continue;
            if (evt == null) {
                evt = new StateChangedEvent(this, state);
            }
            ((StateChangedListener)listeners[i + 1]).stateChanged(evt);
        }
    }

    protected void fireStateChangedEvent(ChangeEvent evt) {
        Object[] listeners = this.eventListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != StateChangedListener.class) continue;
            ((StateChangedListener)listeners[i + 1]).selectionChanged(evt);
        }
    }

    private void initStatusBar() {
        this.statusBar = new KDStatusBar();
        SimpleStatusBarPart part0 = new SimpleStatusBarPart();
        SimpleStatusBarPart part1 = new SimpleStatusBarPart();
        SimpleStatusBarPart part2 = new SimpleStatusBarPart();
        SimpleStatusBarPart part3 = new SimpleStatusBarPart();
        this.statusBar.addPart(part0);
        this.statusBar.addPart(part1);
        this.statusBar.addPart(part2);
        this.statusBar.addPart(part3);
        part0.setHgrap(0);
        part1.setHgrap(0);
        part2.setHgrap(0);
        part3.setHgrap(0);
        part0.setPreferredSize(new Dimension(500, 30));
        part1.setPreferredSize(new Dimension(100, 30));
        part2.setPreferredSize(new Dimension(100, 30));
        part3.setPreferredSize(new Dimension(100, 30));
        SimpleStatusBarRenderer rdElementPrompt = new SimpleStatusBarRenderer();
        part0.addRenderer((ISimpleStatusBarRenderer)rdElementPrompt, (Object)"elementPrompt");
        this.pgb = new JProgressBar(0, 100);
        this.pgb.setPreferredSize(new Dimension(96, 17));
        SimpleStatusBarRenderer rdProgress = new SimpleStatusBarRenderer((JComponent)this.pgb, "progressBar");
        part1.addRenderer((ISimpleStatusBarRenderer)rdProgress, (Object)"progress");
        SimpleStatusBarRenderer rdMousePosition = new SimpleStatusBarRenderer();
        part2.addRenderer((ISimpleStatusBarRenderer)rdMousePosition, (Object)"mousePosition");
        SimpleStatusBarRenderer rdDeltaMouse = new SimpleStatusBarRenderer();
        part3.addRenderer((ISimpleStatusBarRenderer)rdDeltaMouse, (Object)"deltaMouse");
        ((FlowLayout)part0.getLayout()).setVgap(0);
        ((FlowLayout)part1.getLayout()).setVgap(0);
        ((FlowLayout)part2.getLayout()).setVgap(0);
        ((FlowLayout)part3.getLayout()).setVgap(0);
        ((FlowLayout)part1.getLayout()).setHgap(0);
        this.statusBar.setPreferredSize(new Dimension(800, 25));
        this.getOwner().setStatusBar(this.statusBar);
    }

    private void initComponents() {
        Element configRoot = this.loadConfig();
        this.initMenu(configRoot);
        this.getOwner().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                IActionExit acExit = AbstractR1Designer.this._actionManager.getActoinExit();
                acExit.doActionExit();
            }
        });
        this.getOwner().setDefaultCloseOperation(0);
    }

    private void initMenu(Element configRoot) {
        this._actionManager = this.createActionManager(this, configRoot);
        this._actionManager.buildMenuBar(this.getMenuBar());
        KDToolBar[] bars = this._actionManager.createToolBars();
        for (int i = 0; i < bars.length; ++i) {
            this.getOwner().addToolBar((JToolBar)bars[i]);
        }
    }

    private Element loadConfig() {
        Element root = null;
        try {
            root = XmlUtil.loadXmlStream((InputStream)this.getMenuConfigCreator().create());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        return root;
    }

    public void doExit() {
        this.getOwner().dispose();
        if (this._isSingleRun) {
            System.exit(0);
        }
    }

    protected abstract IR1XmlReaderWriterFactory createXmlReaderWriterFactory();

    protected abstract IR1DataManager createDataManager();

    public IReportUI newReport() {
        IR1Page page = this.createXmlReaderWriterFactory().createXmlReader().createPage();
        IR1DataManager dm = this.createDataManager();
        ReportModel model = ReportModel.createModel(page, dm);
        if (this.getReportWizard() != null) {
            this.getReportWizard().initModel(model, (JComponent)this._topPane);
        }
        ComboPanel ui = this.createReport();
        ui.setModel(model);
        return ui;
    }

    private ComboPanel createReport() {
        this._core = new ComboPanel();
        this._core.setXmlReaderWriterFactory(this.createXmlReaderWriterFactory());
        this._core.setDataSelector(this.getDataSelector());
        this._core.addSelectionChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractR1Designer.this.fireStateChangedEvent(e);
            }
        });
        this._core.setSystemParams(this._systemParams);
        this._core.setPopupMenuConfigCreator(this.getPopupMenuConfigCreator());
        this._core.getUndoHelper().setDataXmlTrans(this.getDataXmlTrans());
        this.initCore(this._core);
        this.initDataTree(this._core.getDataTree());
        Toolbox toolbox = this._core.getToolBox();
        ToolboxLoader.initToolbox(toolbox, this.getToolboxConfigCreator());
        this.getTopPane().add((Component)this._core.getPanel(), "Center");
        this.getTopPane().validate();
        return this._core;
    }

    protected abstract void initCore(ComboPanel var1);

    protected abstract void initDataTree(DataTree var1);

    public void removeReport() {
        this.getTopPane().remove((Component)this._core.getPanel());
        this.getTopPane().validate();
        this._core = null;
    }

    public IReportUI loadReport(Element root) throws R1Exception {
        ComboPanel ui = this.createReport();
        IR1XmlReader reader = ui.createXmlReader();
        String versionTooMordernInfo = reader.checkVersionTooMordern(root);
        if (versionTooMordernInfo != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(MultiLanguageUtil.getMLS("gui.AbstractR1Designer.careVersion", ""));
            sb.append(StringUtil.RETURN);
            sb.append(versionTooMordernInfo);
            WindowUtil.msgboxWarning((Object)sb.toString(), (String)ui.getPromptTitle(), (Component)ui.getPanel());
        }
        ReportModel model = reader.fromXml(root, this.getDataXmlTrans());
        ui.setModel(model);
        if (!StringUtil.isEmptyString((String)reader.getWarning())) {
            StringBuffer sb = new StringBuffer();
            sb.append(MultiLanguageUtil.getMLS("gui.AbstractR1Designer.isClean", ""));
            sb.append(StringUtil.RETURN);
            sb.append(reader.getWarning());
            if (WindowUtil.msgboxYesNo((Component)ui.getPanel(), (Object)sb.toString(), (String)ui.getPromptTitle())) {
                IR1DataManager dm = model.getDataManager();
                DataExtend[] exts = dm.getDataExtends();
                for (int i = 0; i < exts.length; ++i) {
                    if (null != dm.getObject(exts[i].getName())) continue;
                    dm.remveData(exts[i]);
                }
            }
        }
        final PageContainer pageContainer = ui.getPageContainer();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                pageContainer.getGraphicsOfPage().fillRect(0, 0, 1, 1);
            }
        });
        return ui;
    }

    public IReportUI loadReport(ReportModel model) {
        ComboPanel ui = this.createReport();
        ui.setModel(model);
        return ui;
    }

    public void setSaver(ISaver saver) {
        this._saver = saver;
    }

    public ISaver getSaver() {
        return this._saver;
    }

    public abstract IReportWizard getReportWizard();

    public void setDataSelector(IObjectSelector dataSelector) {
        this._dataSelector = dataSelector;
        if (this._dataXmlTrans != null) {
            this._dataXmlTrans.setObjectSelector(this._dataSelector);
        }
    }

    public IObjectSelector getDataSelector() {
        return this._dataSelector;
    }

    public IDataXmlTrans getDataXmlTrans() {
        if (this._dataXmlTrans == null) {
            this._dataXmlTrans = this.createDataXmlTrans();
            this._dataXmlTrans.setObjectSelector(this.getDataSelector());
        }
        return this._dataXmlTrans;
    }

    public void setSystemParams(MetaClass systemParams) {
        this._systemParams = systemParams;
    }
}

