/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.common;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.exception.R1DesignerRuntimeException;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.common.RadioButtonGroup;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import java.util.Enumeration;

public class StatTypeUI {
    private RadioButtonGroup _radioButtonGroup;

    public StatTypeUI() {
        this.init();
    }

    private void init() {
        this._radioButtonGroup = new RadioButtonGroup();
        this.initRadioButton(MultiLanguageUtil.getMLS("common.StatTypeUI.sum", ""), 1);
        this.initRadioButton(MultiLanguageUtil.getMLS("common.StatTypeUI.avg", ""), 2);
        this.initRadioButton(MultiLanguageUtil.getMLS("common.StatTypeUI.max", ""), 3);
        this.initRadioButton(MultiLanguageUtil.getMLS("common.StatTypeUI.min", ""), 4);
        this.initRadioButton(MultiLanguageUtil.getMLS("common.StatTypeUI.count", ""), 5);
    }

    private void initRadioButton(String text, int value) {
        KDRadioButton rad = new KDRadioButton(text);
        rad.setUserObject((Object)new Integer(value));
        this._radioButtonGroup.add(rad);
    }

    private int getValue(KDRadioButton btn) {
        Object value = btn.getUserObject();
        return (Integer)value;
    }

    public int getSelectedStatType() {
        KDRadioButton btn = this._radioButtonGroup.getSelected();
        if (btn == null) {
            return -1;
        }
        return this.getValue(btn);
    }

    public void setSelectedStatType(int statType) {
        if (statType == -1) {
            this._radioButtonGroup.setSelectedValueUnsure();
            return;
        }
        Enumeration enumeration = this._radioButtonGroup.getButtons();
        while (enumeration.hasMoreElements()) {
            KDRadioButton btn = (KDRadioButton)enumeration.nextElement();
            if (this.getValue(btn) != statType) continue;
            btn.setSelected(true);
            return;
        }
        throw new R1DesignerRuntimeException("RadioButton which bound this value is not found. The value is: " + statType);
    }

    public RadioButtonGroup getRadioButtonGroup() {
        return this._radioButtonGroup;
    }

    public KDPanel createTitlePane(boolean isHorizontal) {
        return this._radioButtonGroup.createTitlePane(MultiLanguageUtil.getMLS("common.StatTypeUI.statType", ""), isHorizontal);
    }
}

