/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.restype.def.ActionDef;
import com.kingdee.bos.ctrl.common.restype.def.ActionExecutorDef;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeDef;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeDefs;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeSystem;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeTree;
import com.kingdee.bos.ctrl.common.restype.def.io.Xml2ResTypeDefs;
import com.kingdee.bos.ctrl.common.ui.restree.ItemsHelper;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.IOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.IConfigFileCreator;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class PopupMenuManager {
    private static final Logger log = LogUtil.getLogger(PopupMenuManager.class);
    private ResTypeSystem typeSystem;
    private IConfigFileCreator configCreator;

    public PopupMenuManager(IConfigFileCreator c) {
        this.configCreator = c;
    }

    private ResTypeSystem getResTypeSystem() {
        if (this.typeSystem == null) {
            try {
                InputStream in = this.configCreator.create();
                Element e = XmlUtil.loadXmlStream((InputStream)in);
                ResTypeDefs typeDefs = Xml2ResTypeDefs.toObject((Element)e);
                this.typeSystem = new ResTypeSystem(typeDefs);
            }
            catch (Exception ex) {
                log.error((Object)"\u52a0\u8f7d\u53f3\u952e\u83dc\u5355\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\u3002", (Throwable)ex);
            }
        }
        return this.typeSystem;
    }

    public KDPopupMenu updateMenu(KDPopupMenu menu, ComboPanel core) {
        ElementPath epSelected = core.getSelectionModel().getCurrent();
        if (epSelected == null) {
            return null;
        }
        IElement ele = (IElement)epSelected.getLastPathComponent();
        String resTypeName = ele.getPopupMenuKey();
        ResTypeDef resType = this.getResTypeSystem().findType(resTypeName);
        if (resType != null) {
            if (menu == null) {
                menu = new KDPopupMenu();
            } else {
                menu.removeAll();
            }
            ResTypeTree typeTree = this.getResTypeSystem().getTypeTree(resType);
            ResTypeDef runtimeTypeDef = typeTree.getRuntimeResType();
            String menuItems = (String)runtimeTypeDef.getProperty("menu-items");
            ArrayList rawItems = ItemsHelper.trimMenuItems((String)menuItems, (ResTypeTree)typeTree);
            this.makeMenu((JComponent)menu, rawItems, core, runtimeTypeDef);
            return menu;
        }
        return null;
    }

    private void makeMenu(JComponent menu, ArrayList items, ComboPanel core, ResTypeDef runtimeType) {
        for (Object item : items) {
            if (item instanceof JSeparator) {
                PopupMenuManager.addSepatator(menu);
                continue;
            }
            if (item instanceof ActionDef) {
                PopupMenuManager.addMenuItem(menu, (ActionDef)item, core, runtimeType);
                continue;
            }
            if (!(item instanceof ArrayList)) continue;
            ArrayList subItems = (ArrayList)item;
            String text = (String)subItems.remove(0);
            if (text.startsWith("#key:")) {
                String path = (String)runtimeType.sortProperty("multilanguagePackage");
                text = text.substring(5);
                if (!StringUtil.isEmpty(path)) {
                    text = LanguageManager.getLangMessage((String)("display-label." + text), (String)path, (String)text);
                }
            }
            KDMenu subMenu = new KDMenu(text);
            PopupMenuManager.addMenu(menu, subMenu);
            this.makeMenu((JComponent)subMenu, subItems, core, runtimeType);
        }
    }

    private static void addMenu(JComponent menu, KDMenu subMenu) {
        if (menu instanceof KDMenu) {
            ((KDMenu)menu).add((JMenuItem)subMenu);
        } else if (menu instanceof KDPopupMenu) {
            ((KDPopupMenu)menu).add((JMenuItem)subMenu);
        }
    }

    private static void addSepatator(JComponent menu) {
        if (menu instanceof KDMenu) {
            ((KDMenu)menu).addSeparator();
        } else if (menu instanceof KDPopupMenu) {
            ((KDPopupMenu)menu).addSeparator();
        }
    }

    private static void addMenuItem(JComponent menu, ActionDef actionDef, ComboPanel core, ResTypeDef runtimeType) {
        Object inst = PopupMenuManager.createActionDefInstance(actionDef);
        ActionWrapper action = null;
        IOperate operate = null;
        if (inst instanceof IOperate) {
            operate = (IOperate)inst;
            operate.setCore(core);
            action = new ActionWrapper(operate);
        }
        KDMenuItem menuItem = new KDMenuItem(action);
        menuItem.setIcon(ItemsHelper.loadIcon((String)actionDef.getProperty("display-icon"), (ResTypeDef)runtimeType));
        String display = LanguageManager.getProperty((HashMap)actionDef.getProperties(), (String)"display-label");
        if (StringUtil.isEmpty(display)) {
            display = actionDef.getName();
        } else if (display.startsWith("#key:")) {
            String path = (String)runtimeType.sortProperty("multilanguagePackage");
            display = display.substring(5);
            if (!StringUtil.isEmpty(path)) {
                display = LanguageManager.getLangMessage((String)("display-label." + display), (String)path, (String)display);
            } else {
                log.info((Object)"\u8bbe\u8ba1\u5668\u8bbe\u8ba1\u533a\u53f3\u952e\u83dc\u5355\u591a\u8bed\u8a00\u8def\u5f84\u4fe1\u606f\u672a\u627e\u5230\uff01");
            }
        }
        if (operate == null) {
            display = display + " ( \u9519\u8bef\u7684\u914d\u7f6e\u9879 )";
        } else if (operate.isNeedShowUI()) {
            display = display + "...";
        }
        menuItem.setText(display);
        if (menu instanceof KDMenu) {
            ((KDMenu)menu).add((JMenuItem)menuItem);
        } else if (menu instanceof KDPopupMenu) {
            ((KDPopupMenu)menu).add((JMenuItem)menuItem);
        }
    }

    private static Object createActionDefInstance(ActionDef actionDef) {
        ActionExecutorDef nExecutor = actionDef.getActionExecutorDef();
        Class<?> cls = nExecutor.getJavaClass();
        try {
            if (cls == null) {
                if (nExecutor.getJavaClassName() == null) {
                    throw new UnsupportedOperationException(MultiLanguageUtil.getMLS("core.PopupMenuManager.unSupportted", ""));
                }
                cls = Class.forName(nExecutor.getJavaClassName());
                nExecutor.setJavaClass(cls);
            }
            return cls.newInstance();
        }
        catch (Exception ex) {
            log.error((Object)"\u914d\u7f6e\u6587\u4ef6\u4e2d\u6307\u5b9a\u7684\u7c7b\u5b9e\u4f8b\u5316\u5931\u8d25\u3002", (Throwable)ex);
            return null;
        }
    }

    private static class ActionWrapper
    extends AbstractAction {
        protected IOperate operate;

        public ActionWrapper(IOperate operate) {
            this.operate = operate;
            this.setEnabled(operate.isValid());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.operate.operate();
        }
    }
}

