/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.PopupMenuManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.IR1Page;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class StructureTree {
    private ComboPanel _core;
    private KDTree _tree;
    private KDTreeView _treeView;
    private UpdateUtil updateUtil = new UpdateUtil();
    private boolean fireTreeListener = true;

    public StructureTree(ComboPanel core) {
        this._core = core;
    }

    public static ElementPath node2ElementPath(TreePath path) {
        IElement ele;
        ArrayList<IElement> eles = new ArrayList<IElement>();
        TreePath tempPath = path;
        do {
            Node node = (Node)((Object)tempPath.getLastPathComponent());
            ele = (IElement)node.getUserObject();
            eles.add(0, ele);
            tempPath = tempPath.getParentPath();
        } while (!(ele instanceof IReportObject));
        ElementPath ep = new ElementPath(eles.toArray());
        return ep;
    }

    public JComponent getCtrl() {
        if (this._treeView == null) {
            this._treeView = new KDTreeView(this.getTreeCtrl());
            this._treeView.setShowButton(false);
        }
        return this._treeView;
    }

    public KDTree getTreeCtrl() {
        if (this._tree == null) {
            KDFTreeSelectionModel tsm = new KDFTreeSelectionModel();
            tsm.setSelectionMode(4);
            this._tree = new KDTree((ITreeNode)new Node(null));
            this._tree.setShowCheckBox(false);
            this._tree.setRootVisible(false);
            this._tree.setShowsRootHandles(true);
            this._tree.setSelectionModel((TreeSelectionModel)tsm);
            this._tree.addTreeSelectionListener((TreeSelectionListener)new TreeHandler());
            this._tree.addTreePopupMenu((TreePopupMenuListener)new TreePopupHandler());
            InputMap inputMap = this._tree.getInputMap();
            if (inputMap != null) {
                KeyStroke ctrl_c = KeyStroke.getKeyStroke(67, 128);
                inputMap.put(ctrl_c, "failedCtrlC_registerByAlong");
                KeyStroke ctrl_v = KeyStroke.getKeyStroke(86, 128);
                inputMap.put(ctrl_v, "failedCtrlV_registerByAlong");
                KeyStroke ctrl_x = KeyStroke.getKeyStroke(88, 128);
                inputMap.put(ctrl_x, "failedCtrlX_registerByAlong");
            }
        }
        return this._tree;
    }

    public void update() {
        this.fireTreeListener = false;
        try {
            KDTree tree = this.getTreeCtrl();
            Node root = (Node)((Object)((DefaultTreeModel)tree.getModel()).getRoot());
            tree.removeAllChildrenFromParent((MutableTreeNode)((Object)root));
            this.updateUtil.updateReportObject(tree, root, this._core.getModel().getPage());
            tree.expandAllNodes(true, (TreeNode)((Object)root));
        }
        finally {
            this.fireTreeListener = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectNode() {
        this.fireTreeListener = false;
        try {
            ElementPath[] eles = this._core.getSelectionModel().getAll();
            TreePath[] treePaths = new TreePath[eles.length];
            for (int i = 0; i < eles.length; ++i) {
                treePaths[i] = this.element2TreePath(eles[i]);
            }
            this.getTreeCtrl().setSelectionPaths(treePaths);
            if (treePaths.length > 0) {
                this.getTreeCtrl().scrollPathToVisible(treePaths[0]);
            }
        }
        finally {
            this.fireTreeListener = true;
        }
    }

    public void updateNodeText(ElementPath ep) {
        Node node = this.element2Node(ep);
        ((DefaultTreeModel)this.getTreeCtrl().getModel()).nodeChanged((TreeNode)((Object)node));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNode(IReportObject ro) {
        this.fireTreeListener = false;
        try {
            Node node = this.element2Node(new ElementPath(ro));
            ElementPath epParent = ro.getParent();
            Node nodeParent = this.element2Node(epParent);
            int oriIdx = nodeParent.getIndex((TreeNode)((Object)node));
            this.getTreeCtrl().removeNodeFromParent((MutableTreeNode)((Object)node));
            this.updateUtil.updateReportObject(this.getTreeCtrl(), nodeParent, ro);
            node = this.element2Node(new ElementPath(ro));
            this.getTreeCtrl().removeNodeFromParent((MutableTreeNode)((Object)node));
            this.getTreeCtrl().insertNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)nodeParent), oriIdx);
        }
        finally {
            this.fireTreeListener = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAddNode(ElementPath ep) {
        this.fireTreeListener = false;
        try {
            Object objEle = ep.getLastPathComponent();
            Object objRo = ep.getRootPathComponent();
            if (objRo != objEle) {
                Node node = this.element2Node(new ElementPath(objRo));
                this.getTreeCtrl().removeNodeFromParent((MutableTreeNode)((Object)node));
            }
            IReportObject ro = (IReportObject)objRo;
            ElementPath epParent = ro.getParent();
            Node nodeParent = this.element2Node(epParent);
            this.updateUtil.updateReportObject(this.getTreeCtrl(), nodeParent, ro);
        }
        finally {
            this.fireTreeListener = true;
        }
    }

    public void updateRemoveNode(ElementPath ep) {
        Node node = this.element2Node(ep);
        if (node != null) {
            this.fireTreeListener = false;
            try {
                this.getTreeCtrl().removeNodeFromParent((MutableTreeNode)((Object)node));
            }
            finally {
                this.fireTreeListener = true;
            }
        }
    }

    private Node element2Node(ElementPath elementPath) {
        TreePath path = this.element2TreePath(elementPath);
        if (path == null) {
            return null;
        }
        return (Node)((Object)path.getLastPathComponent());
    }

    private TreePath element2TreePath(ElementPath elementPath) {
        ElementPath ep = elementPath;
        ArrayList<IElement> listEles = new ArrayList<IElement>();
        IElement ele = (IElement)ep.getLastPathComponent();
        listEles.add(ele);
        while (!(ele instanceof IR1Page)) {
            while (!(ele instanceof IReportObject)) {
                ep = ep.getParentPath();
                ele = (IElement)ep.getLastPathComponent();
                listEles.add(0, ele);
            }
            ep = ((IReportObject)ele).getParent();
            ele = (IElement)ep.getLastPathComponent();
            listEles.add(0, ele);
        }
        ArrayList<Node> listNodes = new ArrayList<Node>();
        Node node = (Node)((Object)this.getTreeCtrl().getModel().getRoot());
        listNodes.add(node);
        int c = listEles.size();
        for (int i = 0; i < c; ++i) {
            Object userObj = listEles.get(i);
            boolean isFound = false;
            int n = node.getChildCount();
            for (int k = 0; k < n; ++k) {
                Node childNode = (Node)((Object)node.getChildAt(k));
                if (userObj != childNode.getUserObject()) continue;
                listNodes.add(childNode);
                node = childNode;
                isFound = true;
                break;
            }
            if (isFound) continue;
            return null;
        }
        TreePath treePath = new TreePath(listNodes.toArray());
        return treePath;
    }

    public void addAction(Action action) {
        KDWorkButton btn = new KDWorkButton(action);
        this._treeView.getControlPane().add((Component)btn);
    }

    class TreePopupHandler
    implements TreePopupMenuListener {
        private PopupMenuManager popupMenuManager;

        TreePopupHandler() {
        }

        public boolean popMenu(TreePopupMenuEvent event) {
            KDPopupMenu menu;
            if (this.popupMenuManager == null) {
                this.popupMenuManager = new PopupMenuManager(StructureTree.this._core.getPopupMenuConfigCreator());
            }
            return this.popupMenuManager.updateMenu(menu = (KDPopupMenu)event.getMenu(), StructureTree.this._core) != null;
        }
    }

    static class KDFTreeSelectionModel
    extends DefaultTreeSelectionModel {
        KDFTreeSelectionModel() {
        }

        @Override
        public void setSelectionPaths(TreePath[] pPaths) {
            TreePath[] newPaths = null;
            if (pPaths != null && pPaths.length > 0) {
                newPaths = this.filterSelected(pPaths);
            }
            super.setSelectionPaths(newPaths);
        }

        private TreePath[] filterSelected(TreePath[] paths) {
            TreePath path_0 = paths[0];
            ElementPath ep_0 = StructureTree.node2ElementPath(path_0);
            int length_0 = ep_0.getPathCount();
            IReportObject ro_0 = (IReportObject)ep_0.getRootPathComponent();
            ArrayList<TreePath> filtered = new ArrayList<TreePath>();
            filtered.add(path_0);
            for (int i = 1; i < paths.length; ++i) {
                ElementPath ep = StructureTree.node2ElementPath(paths[i]);
                IReportObject ro = (IReportObject)ep.getRootPathComponent();
                int length = ep.getPathCount();
                if (length == 1) {
                    if (length != length_0 || ro.getParent() == null || !ro.getParent().equals(ro_0.getParent())) continue;
                    filtered.add(paths[i]);
                    continue;
                }
                if (ro != ro_0 || length != length_0) continue;
                filtered.add(paths[i]);
            }
            return filtered.toArray(new TreePath[0]);
        }

        private TreePath[] arrayCopy(TreePath[] oldPaths, TreePath[] pPaths) {
            int i;
            TreePath[] newPaths = new TreePath[oldPaths.length + pPaths.length];
            for (i = 0; i < oldPaths.length; ++i) {
                newPaths[i] = oldPaths[i];
            }
            for (i = 0; i < pPaths.length; ++i) {
                newPaths[i + oldPaths.length] = pPaths[i];
            }
            return newPaths;
        }

        @Override
        public void addSelectionPaths(TreePath[] paths) {
            int oldCount = this.selection == null ? 0 : this.selection.length;
            TreePath[] newpaths = null;
            if (oldCount > 0) {
                if (paths != null && paths.length > 0) {
                    newpaths = this.arrayCopy(this.selection, paths);
                    this.setSelectionPaths(newpaths);
                }
            } else {
                this.setSelectionPaths(paths);
            }
        }
    }

    public static class Node
    extends DefaultKingdeeTreeNode {
        private String prompt;

        public Node(Object userObject) {
            super(userObject);
        }

        public void setPrompt(String str) {
            this.prompt = str;
        }

        public String getPrompt() {
            return this.prompt;
        }

        public String getText() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getPrompt());
            sb.append("\uff1a");
            if (this.getUserObject() != null) {
                sb.append(((IElement)this.getUserObject()).getId());
            }
            return sb.toString();
        }

        public String toString() {
            return this.getText();
        }
    }

    class TreeHandler
    implements TreeSelectionListener {
        TreeHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (!StructureTree.this.fireTreeListener) {
                return;
            }
            TreePath[] paths = StructureTree.this.getTreeCtrl().getSelectionPaths();
            if (paths == null || paths.length == 0) {
                return;
            }
            ArrayList<ElementPath> eps = new ArrayList<ElementPath>();
            for (int i = 0; i < paths.length; ++i) {
                eps.add(StructureTree.node2ElementPath(paths[i]));
            }
            StructureTree.this._core.getSelectionModel().set(eps.toArray(new ElementPath[0]));
            if (eps.size() > 0) {
                ElementPath ep = (ElementPath)eps.get(0);
                IReportObject ro = (IReportObject)ep.getRootPathComponent();
                IElement ele = (IElement)ep.getLastPathComponent();
                Rectangle rect = ro.getRectAtPage();
                StructureTree.this._core.getPageContainer().translate(rect);
                if (ro instanceof ICompositeObject) {
                    ICompositeObject co = (ICompositeObject)((Object)ro);
                    Rectangle rectEle = co.getSubElementRectangle(ele);
                    rectEle.translate(rect.x, rect.y);
                    rect = rectEle;
                }
                rect.x -= 5;
                rect.y -= 5;
                rect.width += 10;
                rect.height += 10;
                StructureTree.this._core.getPageContainer().scrollRectToVisible(rect);
            }
            StructureTree.this._core.fireSelectionChangeListener();
            StructureTree.this._core.getPageContainer().repaint();
        }
    }

    static class UpdateUtil
    implements Updater {
        private KDTree treeCtrl;

        UpdateUtil() {
        }

        @Override
        public KDTree getTree() {
            return this.treeCtrl;
        }

        public void updateReportObject(KDTree tree, Node parentNode, IReportObject ro) {
            this.treeCtrl = tree;
            Node node = this.createNode(ro, null);
            tree.addNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)parentNode));
            if (ro instanceof IContainer) {
                this.updateContainer(node, (IContainer)((Object)ro));
            } else if (ro instanceof ICompositeObject) {
                ((ICompositeObject)((Object)ro)).updateStructureTree(this, node);
            }
        }

        @Override
        public Node createNode(IElement ele, String specialPrompt) {
            Node node = new Node(ele);
            ele.initTreeNode(node);
            if (StringUtil.isEmptyString((String)specialPrompt)) {
                node.setPrompt(ele.getTypePrompt());
            } else {
                node.setPrompt(specialPrompt);
            }
            return node;
        }

        @Override
        public void updateContainer(Node nodeCtn, IContainer ctn) {
            if (ctn.getChildrenCount() > 0) {
                for (IReportObject child : ctn.getChildren()) {
                    this.updateReportObject(this.getTree(), nodeCtn, child);
                }
            }
        }
    }

    public static interface Updater {
        public Node createNode(IElement var1, String var2);

        public void updateContainer(Node var1, IContainer var2);

        public KDTree getTree();
    }
}

