/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.icon.R1DesignerIcons;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.IMouseOperateState;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.MouseOperateState;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.icon.Icons;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;

public class CursorManager {
    private static Cursor gridHorizontalAdjust;
    private static Cursor gridVerticalAdjust;
    private static Cursor gridSelectRow;
    private static Cursor gridSelectColumn;

    public static Cursor getCursor(MouseOperateState state) {
        if (state.isMove()) {
            return CursorManager.getMove();
        }
        if (state.isResize()) {
            return CursorManager.getResize(state.getResizeDirection());
        }
        if (state.isToCreate()) {
            return CursorManager.getForbid();
        }
        if (state.isCanCreate()) {
            return CursorManager.getCreate();
        }
        return CursorManager.getDefault();
    }

    private static Cursor getResize(int direction) {
        switch (direction) {
            case 10: {
                return Cursor.getPredefinedCursor(6);
            }
            case 5: {
                return Cursor.getPredefinedCursor(5);
            }
            case 1: {
                return Cursor.getPredefinedCursor(11);
            }
            case 4: {
                return Cursor.getPredefinedCursor(9);
            }
            case 6: {
                return Cursor.getPredefinedCursor(4);
            }
            case 2: {
                return Cursor.getPredefinedCursor(10);
            }
            case 8: {
                return Cursor.getPredefinedCursor(8);
            }
            case 9: {
                return Cursor.getPredefinedCursor(7);
            }
        }
        return CursorManager.getDefault();
    }

    private static Cursor getMove() {
        return Cursor.getPredefinedCursor(13);
    }

    private static Cursor getCreate() {
        return Cursor.getPredefinedCursor(1);
    }

    private static Cursor getCursorHorizontalAdjust() {
        if (gridHorizontalAdjust == null) {
            Image img = Icons.createImage("cursors/cursor_vsplit.gif");
            gridHorizontalAdjust = Toolkit.getDefaultToolkit().createCustomCursor(img, new Point(16, 16), "VSPLIT");
        }
        return gridHorizontalAdjust;
    }

    private static Cursor getCursorVerticalAdjust() {
        if (gridVerticalAdjust == null) {
            Image img = Icons.createImage("cursors/cursor_hsplit.gif");
            gridVerticalAdjust = Toolkit.getDefaultToolkit().createCustomCursor(img, new Point(16, 16), "HSPLIT");
        }
        return gridVerticalAdjust;
    }

    public static Cursor getExtCursor_SplitPane(IMouseOperateState state) {
        switch (state.getOperate()) {
            case 1: {
                return CursorManager.getCursorHorizontalAdjust();
            }
            case 2: {
                return CursorManager.getCursorVerticalAdjust();
            }
        }
        return CursorManager.getDefault();
    }

    public static Cursor getExtCursor_LabelContainer(IMouseOperateState state) {
        return CursorManager.getCursorHorizontalAdjust();
    }

    public static Cursor getExtCursor_Grid(IMouseOperateState state) {
        switch (state.getOperate()) {
            case 16: {
                return CursorManager.getCursorHorizontalAdjust();
            }
            case 32: {
                return CursorManager.getCursorVerticalAdjust();
            }
            case 48: {
                if (gridSelectRow == null) {
                    Image img = Icons.createImage("cursors/cursor_arrowright.gif");
                    gridSelectRow = Toolkit.getDefaultToolkit().createCustomCursor(img, new Point(16, 8), "ARROWRIGHT");
                }
                return gridSelectRow;
            }
            case 64: {
                if (gridSelectColumn == null) {
                    Image img = Icons.createImage("cursors/cursor_arrowdown.gif");
                    gridSelectColumn = Toolkit.getDefaultToolkit().createCustomCursor(img, new Point(8, 16), "ARROWDOWN");
                }
                return gridSelectColumn;
            }
        }
        return CursorManager.getDefault();
    }

    private static Cursor getForbid() {
        return R1DesignerIcons.CURSOR_FORBID;
    }

    public static Cursor getDefault() {
        return Cursor.getDefaultCursor();
    }

    public static Cursor getDragDrop() {
        return R1DesignerIcons.CURSOR_MOVEDDROP;
    }
}

