/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io;

import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.io.Def2Xml;
import com.kingdee.bos.ctrl.data.modal.io.Xml2Def;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataParamSource;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.exception.InvalidDataException;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IDataXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class DataXmlTrans
implements IDataXmlTrans {
    private IObjectSelector _objectSelector;

    @Override
    public void setObjectSelector(IObjectSelector objectSelector) {
        this._objectSelector = objectSelector;
    }

    @Override
    public void toXml(IR1DataManager dm, Element datasNode) {
        DataExtend[] allExts = dm.getDataExtends();
        for (int i = 0; i < allExts.length; ++i) {
            Element dataNode = new Element("Reference");
            datasNode.addContent((Content)dataNode);
            DataExtend ext = allExts[i];
            Def2Xml.makeDefObj((IDefObj)ext, (Element)dataNode);
            String info = ext.getInfo();
            dataNode.setAttribute("info", info);
            this.paramToXml(allExts[i].getParamSources(), dataNode);
        }
    }

    private void paramToXml(List paramList, Element nodeData) {
        Element nodeParams = new Element("Params");
        for (DataParamSource paramSource : paramList) {
            Element nodeParam = new Element("Param");
            nodeParams.addContent((Content)nodeParam);
            Element nodeAssociate = new Element("Associate");
            nodeParam.addContent((Content)nodeAssociate);
            nodeParam.setAttribute("name", paramSource.getParamName());
            if (paramSource.getReferenceDataName() != null) {
                nodeAssociate.setAttribute("dataSourceID", paramSource.getReferenceDataName());
            }
            nodeAssociate.addContent(paramSource.getValue());
        }
        if (paramList.size() > 0) {
            nodeData.addContent((Content)nodeParams);
        }
    }

    @Override
    public void fromXml(Element datasNode, IR1DataManager dm) throws InvalidDataException {
        StringBuffer invalidData = new StringBuffer();
        for (Element node : datasNode.getChildren("Reference")) {
            DataExtend ext = new DataExtend();
            Xml2Def.parseDefObj((IDefObj)ext, (Element)node);
            String info = node.getAttributeValue("info");
            ext.setInfo(info);
            Object dataObj = null;
            if (this._objectSelector != null) {
                dataObj = this._objectSelector.getObject(info);
                if (dataObj == null) {
                    invalidData.append(StringUtil.RETURN);
                    invalidData.append(ext.getName());
                    invalidData.append(" (");
                    invalidData.append(ext.getInfo());
                    invalidData.append(")");
                } else if (dataObj instanceof MetaClass) {
                    List params = ((MetaClass)dataObj).getParameters();
                    List paramSources = DataExtend.params2ParamSources(params);
                    ext.setParamSources(paramSources);
                }
            }
            this.paramFromXml(ext, node);
            dm.setListenerUseful(false);
            dm.addData(ext, dataObj);
            dm.setListenerUseful(true);
        }
        if (invalidData.length() != 0) {
            invalidData.insert(0, MultiLanguageUtil.getMLS("io.DataXmlTrans.careFindDatasource", ""));
            throw new InvalidDataException(invalidData.toString());
        }
    }

    private void paramFromXml(DataExtend ext, Element nodeData) {
        Element nodeParams = nodeData.getChild("Params");
        if (nodeParams == null) {
            return;
        }
        List paramSourceList = ext.getParamSources();
        for (Element nodeParam : nodeParams.getChildren("Param")) {
            String paramName = nodeParam.getAttributeValue("name");
            if (StringUtil.isEmptyString((String)paramName)) continue;
            DataParamSource paramSource = DataXmlTrans.getParamSourceFromList(paramSourceList, paramName);
            if (paramSource == null) {
                paramSource = new DataParamSource();
                paramSourceList.add(paramSource);
                paramSource.setParamName(paramName);
            }
            Element nodeAssociate = nodeParam.getChild("Associate");
            String dsName = nodeAssociate.getAttributeValue("dataSourceID");
            paramSource.setReferenceDataName(dsName);
            paramSource.setValue(nodeAssociate.getText());
        }
    }

    private static DataParamSource getParamSourceFromList(List list, String name) {
        for (DataParamSource dps : list) {
            if (!StringUtil.equals((String)dps.getName(), (String)name)) continue;
            return dps;
        }
        return null;
    }
}

