/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.xmltrans;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlRecursiveReader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlRecursiveWriter;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.StyleCache;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.xmltrans.IObjectXmlTrans;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

public abstract class AbstractObjectXmlTrans
implements IObjectXmlTrans {
    protected IR1XmlRecursiveReader _r1Reader;
    protected IR1XmlRecursiveWriter _r1Writer;
    protected StyleCache _styleCache;
    protected IAnObjectFactory _objFactory;

    public AbstractObjectXmlTrans(IAnObjectFactory factory) {
        this._objFactory = factory;
    }

    protected IAnObjectFactory getFactory() {
        return this._objFactory;
    }

    @Override
    public IReportObject fromXml(IR1XmlRecursiveReader reader, Element node, StyleCache styleCache) throws R1Exception {
        if (this.isMatch(node)) {
            this._r1Reader = reader;
            this._styleCache = styleCache;
            return this.fromXml(node);
        }
        return null;
    }

    protected abstract boolean isMatch(Element var1);

    protected abstract IReportObject fromXml(Element var1) throws R1Exception;

    protected void loadElementCommon(Element nodeElement, IElement ele) {
        ele.setId(nodeElement.getAttributeValue("id"));
        String styleKey = nodeElement.getAttributeValue("styleId");
        StyleAttributes sa = this._styleCache.getStyle(styleKey);
        if (sa != null) {
            ele.setStyleAttribute(Styles.getSA((StyleAttributes)sa));
        }
        String hide = nodeElement.getAttributeValue("hide");
        ele.setHide(StringUtil.equals((String)hide, (String)"true"));
    }

    protected void loadObjectCommon(Element nodeRo, IReportObject ro) {
        this.loadObjectLocation(nodeRo, ro);
        this.loadObjectOther(nodeRo, ro);
        this.loadElementCommon(nodeRo, ro);
    }

    protected void loadObjectLocation(Element nodeRo, IReportObject ro) {
        String rotateAttrValue;
        ro.setXLom(Integer.parseInt(nodeRo.getAttributeValue("x")));
        ro.setYLom(Integer.parseInt(nodeRo.getAttributeValue("y")));
        ro.setWidthLom(Integer.parseInt(nodeRo.getAttributeValue("width")));
        ro.setHeightLom(Integer.parseInt(nodeRo.getAttributeValue("height")));
        String zIndexAttrValue = nodeRo.getAttributeValue("z-index");
        if (zIndexAttrValue != null && !zIndexAttrValue.isEmpty()) {
            ro.setZIndex(Integer.parseInt(zIndexAttrValue));
        }
        if ((rotateAttrValue = nodeRo.getAttributeValue("rotate")) != null && !rotateAttrValue.isEmpty()) {
            ro.setRotate(Integer.parseInt(rotateAttrValue));
        }
    }

    protected abstract void loadObjectOther(Element var1, IReportObject var2);

    @Override
    public Element toXml(IR1XmlRecursiveWriter writer, IReportObject ro, StyleCache styleCache) {
        if (this.isMatch(ro)) {
            this._r1Writer = writer;
            this._styleCache = styleCache;
            return this.toXml(ro);
        }
        return null;
    }

    protected abstract boolean isMatch(IReportObject var1);

    protected abstract Element toXml(IReportObject var1);

    protected void saveObjectCommon(IReportObject ro, Element node) {
        this.saveElementCommon(ro, node);
        this.saveObjectLocation(ro, node);
        this.saveObjectOther(ro, node);
    }

    protected void saveObjectLocation(IReportObject ro, Element node) {
        node.setAttribute("x", Integer.toString(ro.getXLom()));
        node.setAttribute("y", Integer.toString(ro.getYLom()));
        node.setAttribute("width", Integer.toString(ro.getWidthLom()));
        node.setAttribute("height", Integer.toString(ro.getHeightLom()));
        node.setAttribute("z-index", Integer.toString(ro.getZIndex()));
        node.setAttribute("rotate", Integer.toString(ro.getRotate()));
    }

    protected abstract void saveObjectOther(IReportObject var1, Element var2);

    protected void saveElementCommon(IElement ele, Element node) {
        node.setAttribute("id", ele.getId());
        if (ele.getStyleAttribute() != null) {
            String styleId = this._styleCache.cacheStyle(ele.getStyleAttribute());
            node.setAttribute("styleId", styleId);
        }
        if (ele.isHide()) {
            node.setAttribute("hide", "true");
        }
    }

    protected static void setIntAttr(Element node, String key, int value) {
        node.setAttribute(key, String.valueOf(value));
    }

    protected static int getIntAttr(Element node, String key) {
        String strValue = node.getAttributeValue(key);
        if (strValue != null) {
            return Integer.parseInt(strValue);
        }
        return Integer.MIN_VALUE;
    }

    protected static void saveScript(IElement ele, Element node) {
        if (!StringUtil.isEmptyString((String)ele.getScript())) {
            Element nodeScript = new Element("Script");
            node.addContent((Content)nodeScript);
            CDATA cdScript = new CDATA(ele.getScript());
            nodeScript.addContent((Content)cdScript);
        }
    }

    protected static void loadScript(Element node, IElement ele) {
        Element nodeScript = node.getChild("Script");
        if (nodeScript != null) {
            ele.setScript(nodeScript.getText());
        }
    }
}

