/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.selection;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.selection.ICompositeSelectionRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class GridElementSelectionRenderer
implements ICompositeSelectionRenderer {
    protected AbstractGrid _grid;
    private static Color ColorNotCurrent = new Color(153, 153, 255);

    @Override
    public void setCompositeObject(ICompositeObject co) {
        this._grid = (AbstractGrid)co;
    }

    @Override
    public void drawSelected(Graphics g, ElementPath elePath, boolean isCurrent) {
        Graphics gra = this.clip(g);
        IElement ele = (IElement)elePath.getLastPathComponent();
        this.drawCell(gra, ele, isCurrent);
    }

    protected Graphics clip(Graphics g) {
        Rectangle clipRect = this._grid.getRectAtPage();
        return g.create(clipRect.x - this.ext(), clipRect.y - this.ext(), clipRect.width + this.ext() * 2 + 1, clipRect.height + this.ext() * 2 + 1);
    }

    protected int ext() {
        return 1;
    }

    private void drawCell(Graphics g, IElement cell, boolean isCurrent) {
        Rectangle rect = this._grid.getSubElementRectangle(cell);
        Color oriColor = g.getColor();
        if (isCurrent) {
            g.setColor(Color.BLUE);
        } else {
            g.setColor(ColorNotCurrent);
        }
        g.drawRect(rect.x + this.ext() - 1, rect.y + this.ext() - 1, rect.width + 2, rect.height + 2);
        g.setColor(oriColor);
    }
}

