/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.util;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class ActiveTabbedUI {
    private ArrayList _groups = new ArrayList();
    private TableLayout _layout;
    private int _currentIdx;
    private PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport(this);

    public void addGroup(IActiveTabbedGroup group) {
        this._groups.add(group);
    }

    public IActiveTabbedGroup getCurrentGroup() {
        return (IActiveTabbedGroup)this._groups.get(this._currentIdx);
    }

    public List getGroups() {
        return this._groups;
    }

    public KDPanel createPanel() {
        this._layout = TableLayout.splitRow((int)(this._groups.size() * 2));
        KDPanel panToolbox = new KDPanel((LayoutManager)this._layout);
        panToolbox.setBorder(BorderFactory.createEtchedBorder());
        ButtonHandler buttonHandler = new ButtonHandler(panToolbox);
        for (int i = 0; i < this._groups.size(); ++i) {
            this._layout.rowStyle(i * 2).setHeight(20);
            this._layout.rowStyle(i * 2).setMargin(0, 0, 1, 0);
            IActiveTabbedGroup group = (IActiveTabbedGroup)this._groups.get(i);
            KDWorkButton btn = new KDWorkButton(group.getTitle());
            btn.setToolTipText(group.getTitle());
            btn.setUserObject((Object)new Integer(i));
            btn.addActionListener((ActionListener)buttonHandler);
            btn.setMinimumSize(new Dimension(0, 0));
            JComponent ctrl = group.getCtrl();
            ctrl.setMinimumSize(new Dimension(0, 0));
            panToolbox.add((Component)btn, (Object)this._layout.cell(i * 2));
            panToolbox.add((Component)ctrl, (Object)this._layout.cell(i * 2 + 1));
        }
        this._currentIdx = 0;
        this.showGroup(panToolbox);
        return panToolbox;
    }

    private void showGroup(KDPanel panToolbox) {
        for (int i = 0; i < panToolbox.getComponentCount(); i += 2) {
            if (i / 2 == this._currentIdx) {
                this._layout.rowStyle(i + 1).setPriY(1);
                this._layout.rowStyle(i + 1).setMargin(2, 2, 2, 2);
                continue;
            }
            this._layout.rowStyle(i + 1).setPriY(0);
            this._layout.rowStyle(i + 1).setHeight(0);
            this._layout.rowStyle(i + 1).setMargin(0);
        }
        panToolbox.revalidate();
    }

    public void addGroupChangedListener(PropertyChangeListener l) {
        this._propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removeGroupChangedListener(PropertyChangeListener l) {
        this._propertyChangeSupport.removePropertyChangeListener(l);
    }

    public static interface IActiveTabbedGroup {
        public JComponent getCtrl();

        public String getTitle();
    }

    class ButtonHandler
    implements ActionListener {
        private KDPanel panToolbox;

        public ButtonHandler(KDPanel toolbox) {
            this.panToolbox = toolbox;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDWorkButton btn = (KDWorkButton)e.getSource();
            Integer integer = (Integer)btn.getUserObject();
            if (ActiveTabbedUI.this._currentIdx != integer) {
                IActiveTabbedGroup oldGroup = ActiveTabbedUI.this.getCurrentGroup();
                ActiveTabbedUI.this._currentIdx = integer;
                ActiveTabbedUI.this.showGroup(this.panToolbox);
                IActiveTabbedGroup newGroup = ActiveTabbedUI.this.getCurrentGroup();
                ActiveTabbedUI.this._propertyChangeSupport.firePropertyChange("Group", oldGroup, newGroup);
            }
        }
    }
}

