/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.datagrid;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.BindDataSource;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IBind;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.IGridsFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.editor.IScroll;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.editor.ScrollBar;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.CursorManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.IReportObjectRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ContainerUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.AbstractR1FormObjectWithData;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.AbstractR1FormDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.IHeadRow;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.datagrid.FormDataFactory;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.icon.Icons;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.toolbox.ToolboxDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.renderer.DataGridRenderer;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import javax.swing.Icon;

public class FormDataGrid
extends AbstractR1FormDataGrid
implements IScroll,
IHeadRow {
    private int _headRows = 1;
    private int _numFreezeColumn = 0;
    private ScrollBar _hScrollBar;
    private ScrollBar _vScrollBar;
    public static final int SCROLLBAR_WIDTH = 18;
    private int _offsetX = 0;
    private int _offsetY = 0;
    private static final int SCROLL_MORE = 50;
    private IGridsFactory _formRowFactory;

    @Override
    public String getType() {
        return "Table";
    }

    public int get_numFreezeColumn() {
        return this._numFreezeColumn;
    }

    public void set_numFreezeColumn(int freezeColumn) {
        this._numFreezeColumn = freezeColumn;
    }

    @Override
    protected IReportObjectRenderer createRenderer() {
        return new DataGridRenderer();
    }

    public void setHeadRowCount(int row) {
        this._headRows = row;
    }

    @Override
    public String getIdPrefix() {
        return "dataGrid";
    }

    @Override
    public void initTreeNode(DefaultKingdeeTreeNode node) {
        node.setCustomIcon((Icon)Icons.SEC_DATAGRID);
    }

    @Override
    public String getTypePrompt() {
        return MultiLanguageUtil.getMLS("dataGrid", "");
    }

    @Override
    public int getOffsetX() {
        return this._offsetX;
    }

    @Override
    public int getOffsetY() {
        return this._offsetY;
    }

    @Override
    public IScroll.IScrollBar getHScrollBar() {
        if (this._hScrollBar == null) {
            this._hScrollBar = new ScrollBar(true, this);
            this._hScrollBar.getCtrl().setUnitIncrement(20);
            this._hScrollBar.getCtrl().setCursor(CursorManager.getDefault());
            this._hScrollBar.getCtrl().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    FormDataGrid.this._hScrollBar.getCtrl().requestFocus();
                    FormDataGrid.this._offsetX = -e.getValue();
                    KDScrollBar sb = (KDScrollBar)e.getSource();
                    if (sb.getParent() != null) {
                        sb.getParent().repaint();
                    }
                }
            });
        }
        return this._hScrollBar;
    }

    @Override
    public IScroll.IScrollBar getVScrollBar() {
        if (this._vScrollBar == null) {
            this._vScrollBar = new ScrollBar(false, this);
            this._vScrollBar.getCtrl().setUnitIncrement(10);
            this._vScrollBar.getCtrl().setCursor(CursorManager.getDefault());
            this._vScrollBar.getCtrl().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    FormDataGrid.this._vScrollBar.getCtrl().requestFocus();
                    FormDataGrid.this._offsetY = -e.getValue();
                    KDScrollBar sb = (KDScrollBar)e.getSource();
                    if (sb.getParent() != null) {
                        sb.getParent().repaint();
                    }
                }
            });
        }
        return this._vScrollBar;
    }

    @Override
    public void afterAdjusted() {
        int max = this.getFeatWidth() + 50;
        int amount = this.getWidth() - 18;
        if (this.getHScrollBar().getCtrl().getMaximum() < max || this.getHScrollBar().getCtrl().getVisibleAmount() != amount) {
            this.getHScrollBar().getCtrl().setMinimum(0);
            this.getHScrollBar().getCtrl().setMaximum(max);
            this.getHScrollBar().getCtrl().setValue(-this.getOffsetX());
            this.getHScrollBar().getCtrl().setVisibleAmount(amount);
            this.getHScrollBar().getCtrl().setBlockIncrement(amount / 2);
        }
        max = this.getFeatHeight() + 50;
        amount = this.getHeight() - 18;
        if (this.getVScrollBar().getCtrl().getMaximum() < max || this.getVScrollBar().getCtrl().getVisibleAmount() != amount) {
            this.getVScrollBar().getCtrl().setMinimum(0);
            this.getVScrollBar().getCtrl().setMaximum(max);
            this.getVScrollBar().getCtrl().setValue(-this.getOffsetY());
            this.getVScrollBar().getCtrl().setVisibleAmount(amount);
            this.getVScrollBar().getCtrl().setBlockIncrement(amount / 2);
        }
    }

    @Override
    public boolean mouseMoved(MouseEvent evt, Point ptAtPage) {
        boolean result = super.mouseMoved(evt, ptAtPage);
        if (result) {
            Point gridAtPage = ContainerUtil.getPointAtPage(this);
            Point ptAtGrid = new Point(ptAtPage);
            ptAtGrid.translate(-gridAtPage.x, -gridAtPage.y);
            if (this._gridMouseOperateState.isHorizontalAdjust() && ptAtGrid.x > this.getWidth() - 18) {
                this._gridMouseOperateState.setOperate(0);
                return false;
            }
            if (this._gridMouseOperateState.isVerticalAdjust() && ptAtGrid.y > this.getHeight() - 18) {
                this._gridMouseOperateState.setOperate(0);
                return false;
            }
        }
        return result;
    }

    private boolean isAtSrollBar(Point ptAtGrid) {
        return ptAtGrid.y > this.getHeight() - 18 || ptAtGrid.x > this.getWidth() - 18;
    }

    @Override
    public boolean isPointInSubElement(IElement ele, Point ptAtPage) {
        boolean result = super.isPointInSubElement(ele, ptAtPage);
        if (result) {
            Point ptAtObj = new Point(ptAtPage);
            Point ptThisAtPage = ContainerUtil.getPointAtPage(this);
            ptAtObj.translate(-ptThisAtPage.x, -ptThisAtPage.y);
            return !this.isAtSrollBar(ptAtObj);
        }
        return false;
    }

    @Override
    protected IGridsFactory getGridsFactory() {
        if (this._formRowFactory == null) {
            this._formRowFactory = new FormDataFactory();
        }
        return this._formRowFactory;
    }

    @Override
    public void doInitHeadRowStyle() {
        for (int i = 0; i < this.getRowsCount(); ++i) {
            ToolboxDataGrid.initStyle(this, this.getRow(i), i < this.getHeadRowCount());
        }
    }

    @Override
    public String[] getPropertyPanelKeys(ICompositeObject co) {
        String[] panels = new String[]{"dataGrid", "general", "bound"};
        return panels;
    }

    @Override
    public int getHeadRowCount() {
        return this._headRows;
    }

    @Override
    public IBind.IBindDataSource getDataSource() {
        if (this._bindDs == null) {
            this._bindDs = new BindDataSource(AbstractR1FormObjectWithData.createNormalDataType());
        }
        return this._bindDs;
    }
}

