/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property;

import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.editor.styled.MiniScriptEditor;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.AbstractElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractColumn;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.AbstractPropertyPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;

public class PanelDataRowAndCol
extends AbstractPropertyPanel {
    private KDSpinner spnW;
    private KDSpinner spnH;
    private Object tempObj;
    private KDCheckBox ckAdjustRowHight;
    private KDCheckBox ckAdjustColumnWidth;
    private MiniScriptEditor scriptEditor;
    private KDLabel label;

    public PanelDataRowAndCol() {
        this.init();
        this.installListener();
    }

    private void init() {
        this.scriptEditor = new MiniScriptEditor();
        this.label = new KDLabel("\u811a\u672c: ");
        this.ckAdjustRowHight = new KDCheckBox("\u884c\u9ad8\u81ea\u9002\u5e94");
        this.ckAdjustRowHight.setVisible(false);
        this.ckAdjustColumnWidth = new KDCheckBox("\u5217\u5bbd\u81ea\u9002\u5e94");
        this.spnW = new KDSpinner((SpinnerModel)new SpinnerNumberModel(0, 0, Short.MAX_VALUE, 1));
        this.spnH = new KDSpinner((SpinnerModel)new SpinnerNumberModel(0, 0, Short.MAX_VALUE, 1));
        KDLabelContainer lbcW = CtrlSwingUtilities.createLabelContainer((JComponent)this.spnW, (String)MultiLanguageUtil.getMLS("width", ""), (int)120);
        KDLabelContainer lbcH = CtrlSwingUtilities.createLabelContainer((JComponent)this.spnH, (String)MultiLanguageUtil.getMLS("height", ""), (int)120);
        TableLayout tlSize = TableLayout.split((int)3, (int)2);
        tlSize.style().setMargin(12, 18, 10, 8);
        tlSize.colStyle(0).setWidth(200);
        tlSize.colStyle(0).setMargin(0, 0, 20, 3);
        tlSize.rowStyle(2).setPriY(1);
        KDPanel panSize = new KDPanel((LayoutManager)tlSize);
        panSize.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("size", "")));
        panSize.add((Component)lbcW, (Object)tlSize.cell(0, 0));
        panSize.add((Component)this.ckAdjustColumnWidth, (Object)tlSize.cell(0, 1));
        panSize.add((Component)lbcH, (Object)tlSize.cell(1, 0));
        panSize.add((Component)this.ckAdjustRowHight, (Object)tlSize.cell(1, 1));
        TableLayout tl = TableLayout.split((int)3, (int)1);
        tl.style().setMargin(8, 4, 8, 8);
        tl.rowStyle(0).setHeight(80);
        tl.rowStyle(0).setMarginBottom(6);
        tl.rowStyle(1).setHeight(200);
        Table tb = tl.cell(1, 0).split(3, 1);
        tb.rowStyle(0).setMarginBottom(4);
        tb.rowStyle(1).setHeight(280);
        tb.rowStyle(2).setPriY(1);
        this.setLayout((LayoutManager)tl);
        this.add((Component)panSize, tl.cell(0, 0));
        this.add((Component)this.label, tb.cell(0, 0));
        this.add((Component)this.scriptEditor, tb.cell(1, 0));
        this.setScriptsVisible(true);
    }

    private void setScriptsVisible(boolean b) {
        this.label.setVisible(b);
        this.scriptEditor.setVisible(b);
    }

    private void installListener() {
    }

    @Override
    public String getTitle() {
        if (this.tempObj instanceof AbstractRow) {
            return MultiLanguageUtil.getMLS("row", "");
        }
        if (this.tempObj instanceof AbstractColumn) {
            return MultiLanguageUtil.getMLS("column", "");
        }
        return MultiLanguageUtil.getMLS("set", "");
    }

    @Override
    protected void updateElementValue(ElementPath elePath) {
        AbstractElement ro = (AbstractElement)elePath.getLastPathComponent();
        if (ro instanceof AbstractRow) {
            AbstractRow row = (AbstractRow)ro;
            row.setHeightLom(Util.pixel2Lom(this.spnH.getIntegerVlaue()));
            if (!StringUtil.isEmptyString((String)this.scriptEditor.getText())) {
                row.setScript(this.scriptEditor.getText());
            }
        } else if (ro instanceof AbstractColumn) {
            AbstractColumn column = (AbstractColumn)ro;
            column.setWidthLom(Util.pixel2Lom(this.spnW.getIntegerVlaue()));
            column.setFixedWidth(!this.ckAdjustColumnWidth.isSelected());
        }
    }

    @Override
    public void prepareCtrlValue(ElementPath[] eles) {
        Object ro = eles[0].getLastPathComponent();
        if (ro instanceof AbstractRow) {
            this.spnW.setEnabled(false);
            this.spnH.setEnabled(true);
            AbstractRow row = (AbstractRow)ro;
            if (!StringUtil.isEmptyString((String)row.getScript())) {
                this.scriptEditor.setText(row.getScript());
            }
            this.spnH.setValue((Object)new Integer(Util.lom2Pixel(row.getHeightLom())));
            this.spnW.setValue((Object)new Integer(0));
        } else if (ro instanceof AbstractColumn) {
            this.setScriptsVisible(false);
            this.spnW.setEnabled(true);
            this.spnH.setEnabled(false);
            AbstractColumn column = (AbstractColumn)ro;
            this.ckAdjustColumnWidth.setSelected(!column.isFixedWidth());
            this.spnW.setValue((Object)new Integer(Util.lom2Pixel(column.getWidthLom())));
            this.spnH.setValue((Object)new Integer(0));
        }
    }

    @Override
    public void prepareSupplyValue(ComboPanel core, ElementPath[] eles) {
        Object obj;
        this.tempObj = obj = eles[0].getLastPathComponent();
        if (obj instanceof AbstractRow) {
            this.ckAdjustColumnWidth.setVisible(false);
        } else {
            this.ckAdjustColumnWidth.setVisible(true);
        }
        super.prepareSupplyValue(core, eles);
    }
}

