/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans.grid;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractColumn;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.CellField;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.datagrid.FormDataCell;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.datagrid.FormDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans.AbstractR1FormXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans.grid.GridXmlTransUtil;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class FormDataGridXmlTrans
extends AbstractR1FormXmlTrans {
    public FormDataGridXmlTrans(IAnObjectFactory factory) {
        super(factory);
    }

    @Override
    protected boolean isMatch(Element node) {
        return StringUtil.equals((String)"DataGrid", (String)node.getName());
    }

    @Override
    protected IReportObject fromXml(Element node) throws R1Exception {
        String strFreezeColumn;
        FormDataGrid grid = new FormDataGrid();
        this.loadObjectCommon(node, grid);
        String headRowCount = node.getAttributeValue("headRowCount");
        if (!StringUtil.isEmptyString((String)headRowCount)) {
            grid.setHeadRowCount(Integer.parseInt(headRowCount));
        }
        if (!StringUtil.isEmptyString((String)(strFreezeColumn = node.getAttributeValue("freezeColumn")))) {
            grid.set_numFreezeColumn(Integer.parseInt(strFreezeColumn));
        }
        List listCol = node.getChildren("Col");
        for (Element nodeCol : listCol) {
            this.loadColumn(nodeCol, grid);
        }
        GridXmlTransUtil.GroupsLoader groupsLoader = new GridXmlTransUtil.GroupsLoader();
        groupsLoader.loadGroups(node);
        List listRow = node.getChildren("TR");
        for (Element nodeRow : listRow) {
            this.loadRow(nodeRow, grid, node, groupsLoader);
        }
        GridXmlTransUtil.MergeBlocksLoader.loadMergeBlock(node, grid);
        grid.afterAdjusted();
        return grid;
    }

    private void loadColumn(Element nodeCol, AbstractGrid grid) {
        AbstractColumn column = grid.addColumn();
        this.loadElementCommon(nodeCol, column);
        column.setWidthLom(FormDataGridXmlTrans.getIntAttr(nodeCol, "width"));
        if (StringUtil.equals((String)nodeCol.getAttributeValue("autoAdjustColumn"), (String)"true")) {
            column.setFixedWidth(false);
        }
    }

    private void loadRow(Element nodeRow, AbstractGrid grid, Element nodeGrid, GridXmlTransUtil.GroupsLoader groupsLoader) throws R1Exception {
        AbstractRow row;
        String rowType = nodeRow.getAttributeValue("type");
        if (StringUtil.equals((String)"detail", (String)rowType)) {
            row = grid.addRow(2);
        } else if (StringUtil.equals((String)"group", (String)rowType)) {
            row = grid.addRow(3);
            groupsLoader.supplyGroup(nodeRow, (AbstractGroupRow)row);
        } else {
            row = grid.addRow(1);
        }
        this.loadElementCommon(nodeRow, row);
        row.setHeightLom(FormDataGridXmlTrans.getIntAttr(nodeRow, "height"));
        FormDataGridXmlTrans.loadScript(nodeRow, row);
        List listCell = nodeRow.getChildren("TD");
        int c = listCell.size();
        for (int i = 0; i < c; ++i) {
            Element nodeCell = (Element)listCell.get(i);
            FormDataCell cell = (FormDataCell)row.getCell(i);
            this.loadCell(nodeCell, grid, cell);
        }
    }

    private void loadCell(Element nodeCell, AbstractGrid grid, FormDataCell cell) throws R1Exception {
        this.loadElementCommon(nodeCell, cell);
        if ("true".equals(nodeCell.getAttributeValue("isExecutedMerge"))) {
            cell.setExectuedMerge(true);
            cell.setExectuedMergeRange(nodeCell.getAttributeValue("executedMergeRange"));
        }
        FormDataGridXmlTrans.loadScript(nodeCell, cell);
        Element nodeExpand = nodeCell.getChild("Expand");
        if (nodeExpand != null) {
            cell.setVirtualField(true);
            String atrSource = nodeExpand.getAttributeValue("source");
            String atrSeparator = nodeExpand.getAttributeValue("separator");
            if (!StringUtil.isEmptyString((String)atrSource)) {
                CellField cellValue = CellField.create(atrSource, null);
                cell.setVirtualField(cellValue);
            }
            if (!StringUtil.isEmptyString((String)atrSeparator)) {
                cell.setVirtualOption(atrSeparator);
            }
        }
        GridXmlTransUtil.loadCellValue(nodeCell, cell);
    }

    @Override
    protected boolean isMatch(IReportObject ro) {
        return ro instanceof FormDataGrid;
    }

    @Override
    protected Element toXml(IReportObject ro) {
        Element nodeGrid = new Element("DataGrid");
        this.saveObjectCommon(ro, nodeGrid);
        FormDataGrid grid = (FormDataGrid)ro;
        if (grid.getHeadRowCount() != 0) {
            FormDataGridXmlTrans.setIntAttr(nodeGrid, "headRowCount", grid.getHeadRowCount());
        }
        if (grid.get_numFreezeColumn() != 0) {
            FormDataGridXmlTrans.setIntAttr(nodeGrid, "freezeColumn", grid.get_numFreezeColumn());
        }
        int c = grid.getColumnsCount();
        for (int j = 0; j < c; ++j) {
            nodeGrid.addContent((Content)this.saveColumn(grid.getColumn(j)));
        }
        GridXmlTransUtil.MergeBlocksSaver mergeBlocksSaver = new GridXmlTransUtil.MergeBlocksSaver();
        GridXmlTransUtil.GroupsSaver groupsSaver = new GridXmlTransUtil.GroupsSaver();
        int c2 = grid.getRowsCount();
        for (int i = 0; i < c2; ++i) {
            nodeGrid.addContent((Content)this.saveRow(grid.getRow(i), grid, mergeBlocksSaver, groupsSaver));
        }
        mergeBlocksSaver.saveMergeBlocks(nodeGrid);
        groupsSaver.saveGroups(nodeGrid);
        return nodeGrid;
    }

    private Element saveColumn(AbstractColumn column) {
        Element nodeColumn = new Element("Col");
        FormDataGridXmlTrans.setIntAttr(nodeColumn, "width", column.getWidthLom());
        this.saveElementCommon(column, nodeColumn);
        if (!column.isFixedWidth()) {
            nodeColumn.setAttribute("autoAdjustColumn", "true");
        }
        return nodeColumn;
    }

    private Element saveRow(AbstractRow row, AbstractGrid grid, GridXmlTransUtil.MergeBlocksSaver mergeBlocksSaver, GridXmlTransUtil.GroupsSaver groupsSaver) {
        Element nodeRow = new Element("TR");
        FormDataGridXmlTrans.setIntAttr(nodeRow, "height", row.getHeightLom());
        if (row instanceof AbstractDetailRow) {
            nodeRow.setAttribute("type", "detail");
        } else if (row instanceof AbstractGroupRow) {
            nodeRow.setAttribute("type", "group");
            groupsSaver.storeGroup((AbstractGroupRow)row, nodeRow);
        }
        this.saveElementCommon(row, nodeRow);
        FormDataGridXmlTrans.saveScript(row, nodeRow);
        int c = row.getCellCount();
        for (int i = 0; i < c; ++i) {
            FormDataCell cell = (FormDataCell)row.getCell(i);
            nodeRow.addContent((Content)this.saveCell(grid, cell));
            mergeBlocksSaver.storeMergeBlock(grid, cell);
        }
        return nodeRow;
    }

    private Element saveCell(AbstractGrid grid, FormDataCell cell) {
        Element nodeCell = new Element("TD");
        this.saveElementCommon(cell, nodeCell);
        FormDataGridXmlTrans.saveScript(cell, nodeCell);
        if (cell.isExectuedMerge()) {
            nodeCell.setAttribute("isExecutedMerge", "true");
            if (cell.getExectuedMergeRange() != null) {
                nodeCell.setAttribute("executedMergeRange", cell.getExectuedMergeRange());
            }
        }
        if (cell.isVirtualField()) {
            Element nodeExpand = new Element("Expand");
            nodeCell.addContent((Content)nodeExpand);
            if (cell.getVirtualField() != null) {
                Field field = (Field)((Object)cell.getVirtualField());
                nodeExpand.setAttribute("source", field.getName());
                nodeCell.setAttribute("separator", cell.getVirtualOption());
            }
        }
        GridXmlTransUtil.saveCellValue(cell, nodeCell);
        return nodeCell;
    }
}

