/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.form.view;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.form.view.R1FTreeNode;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.NameIndex;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.AModel;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.MvcEvent;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.ASwingView;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.SwingViewUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import java.awt.Component;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class R1FTreeView
extends ASwingView {
    private static final Logger log = LogUtil.getPackageLogger(R1FTreeView.class);
    protected KDTree mainView;
    private NameIndex treeCol;
    private String rootText;
    private String lastLevels;
    private int lastLevel;
    private int[] lastLengths;
    private R1FTreeNode[] lastNodes;
    private int rowIndex;
    private String colLevels;
    private Object colValue;
    private String colText;

    public R1FTreeView() {
        super((JComponent)new KDTree());
    }

    @Override
    protected JComponent init(JComponent c) {
        this.mainView = (KDTree)c;
        this.mainView.addTreeSelectionListener((TreeSelectionListener)new Ctrl());
        return new KDScrollPane((Component)this.mainView);
    }

    public final KDTree getMainView() {
        return this.mainView;
    }

    public final TreeModel getViewModel() {
        return this.getMainView().getModel();
    }

    public final void setViewModel(TreeModel x) {
        this.getMainView().setModel(x);
    }

    @Override
    public void setModel(AModel model) {
        super.setModel(model);
    }

    public final String getRootText() {
        return this.rootText;
    }

    public final void setRootText(String rootText) {
        this.rootText = rootText;
    }

    public final NameIndex getTreeCol() {
        return this.treeCol;
    }

    public final void setTreeCol(NameIndex treeCol) {
        this.treeCol = treeCol;
    }

    private void initRootNode() {
        R1FTreeNode rootNode = new R1FTreeNode();
        rootNode.setRowIndex(0);
        rootNode.setLevels(null);
        rootNode.setValue(null);
        rootNode.setText(this.rootText);
        this.lastLevel = 0;
        this.lastLevels = null;
        this.lastLengths[0] = 0;
        this.lastNodes[0] = rootNode;
    }

    private void addTreeNode() throws SQLException {
        int level = this.findLevel(this.colLevels);
        R1FTreeNode treeNode = new R1FTreeNode();
        treeNode.setRowIndex(this.rowIndex);
        treeNode.setLevels(this.colLevels);
        treeNode.setValue(this.colValue);
        treeNode.setText(this.colText);
        this.lastNodes[level] = treeNode;
        this.lastNodes[level - 1].add((MutableTreeNode)((Object)treeNode));
        this.lastLevel = level;
        this.lastLevels = this.colLevels;
        this.lastLengths[level] = this.colLevels.length();
    }

    private int findLevel(String levels) {
        int equalLength = StringUtil.findEqualsLength(levels, this.lastLevels);
        if (equalLength == 0) {
            return 1;
        }
        int lastLength = this.lastLevels.length();
        if (equalLength < lastLength) {
            for (int i = this.lastLevel - 1; i >= 1; --i) {
                int levelLength = this.lastLengths[i];
                if (equalLength > levelLength) {
                    return i + 1;
                }
                if (equalLength != levelLength) continue;
                return i;
            }
            return 1;
        }
        if (levels.length() == lastLength) {
            return this.lastLevel;
        }
        return this.lastLevel + 1;
    }

    @Override
    protected void update(MvcEvent mvc) {
        AModel model = (AModel)mvc.getSource();
        ResultSet rows = (ResultSet)model.getResult();
        if (mvc.isMessage(1)) {
            this.lastLengths = new int[8];
            this.lastNodes = new R1FTreeNode[8];
            this.initRootNode();
            try {
                int idxLevels = this.treeCol.locate(rows);
                int idxText = SwingViewUtil.locateCols(this.getBinding(), rows);
                int idxValue = this.getBinding().getCol().getIndex();
                this.rowIndex = 0;
                rows.beforeFirst();
                while (rows.next()) {
                    ++this.rowIndex;
                    this.colLevels = rows.getString(idxLevels);
                    this.colValue = rows.getObject(idxValue);
                    this.colText = rows.getString(idxText);
                    this.addTreeNode();
                }
            }
            catch (SQLException ex) {
                log.error((Object)("Exception row-index: " + this.rowIndex), (Throwable)ex);
            }
            this.setViewModel(new DefaultTreeModel((TreeNode)((Object)this.lastNodes[0])));
        }
    }

    protected class Ctrl
    implements TreeSelectionListener {
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (R1FTreeView.this.isUpdating()) {
                return;
            }
            R1FTreeNode tn = (R1FTreeNode)((Object)e.getPath().getLastPathComponent());
            R1FTreeView.this.fireValueChanged(1 + tn.getRowIndex(), null);
        }
    }
}

