/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.AEnum;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.exception.UnsupportedException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

public final class DataType
extends AEnum {
    public static final DataType BYTE = new DataType("i1");
    public static final DataType SHORT = new DataType("i2");
    public static final DataType INTEGER = new DataType("i4");
    public static final DataType LONG = new DataType("i8");
    public static final DataType FLOAT = new DataType("r4");
    public static final DataType DOUBLE = new DataType("r8");
    public static final DataType DECIMAL = new DataType("d");
    public static final DataType CHARACTER = new DataType("c");
    public static final DataType STRING = new DataType("ca");
    public static final DataType BOOLEAN = new DataType("b");
    public static final DataType DATE = new DataType("t");
    public static final DataType BYTEARRAY = new DataType("ba");
    public static final DataType STREAM = new DataType("bs");
    public static final DataType OBJECT = new DataType("o");
    public static final DataType NULL = new DataType("n");
    public static final DataType ARRAY = new DataType("n");
    public static final DataType URL = new DataType("url");
    public static final DataType REF = new DataType("ref");
    public static final DataType BLOB = new DataType("blob");
    public static final DataType CLOB = new DataType("clob");

    private DataType(String name) {
        super(name);
    }

    public static final DataType fromName(String name) {
        return (DataType)AEnum.getEnumMap(DataType.class).get(name);
    }

    public static final Map getEnumMap() {
        return AEnum.getEnumMap(DataType.class);
    }

    public static final DataType[] getAllEnums() {
        return (DataType[])DataType.getAllEnum(DataType.class);
    }

    public static final String[] getAllNames() {
        return DataType.getEnumMap().values().toArray(new String[0]);
    }

    public static DataType formJavaType(Class javaType) {
        if (javaType == null) {
            return NULL;
        }
        if (String.class == javaType) {
            return STRING;
        }
        if (Integer.class == javaType) {
            return INTEGER;
        }
        if (Long.class == javaType) {
            return LONG;
        }
        if (Double.class == javaType) {
            return DOUBLE;
        }
        if (Short.class == javaType) {
            return SHORT;
        }
        if (Byte.class == javaType) {
            return BYTE;
        }
        if (Float.class == javaType) {
            return FLOAT;
        }
        if (Character.class == javaType) {
            return CHARACTER;
        }
        if (Boolean.class == javaType) {
            return BOOLEAN;
        }
        if (Date.class == javaType) {
            return DATE;
        }
        if (BigDecimal.class == javaType) {
            return DECIMAL;
        }
        if (InputStream.class == javaType) {
            return STREAM;
        }
        if (javaType.isArray()) {
            return ARRAY;
        }
        return OBJECT;
    }

    public static DataType formJdbcType(int jdbcType) {
        switch (jdbcType) {
            case -7: {
                return BOOLEAN;
            }
            case -6: {
                return BYTE;
            }
            case 5: {
                return SHORT;
            }
            case 4: {
                return INTEGER;
            }
            case -5: {
                return LONG;
            }
            case 6: {
                return FLOAT;
            }
            case 7: 
            case 8: {
                return DOUBLE;
            }
            case 2: 
            case 3: {
                return DECIMAL;
            }
            case 1: {
                return CHARACTER;
            }
            case 12: {
                return STRING;
            }
            case -1: {
                return STREAM;
            }
            case 91: 
            case 92: 
            case 93: {
                return DATE;
            }
            case -3: 
            case -2: {
                return BYTEARRAY;
            }
            case -4: {
                return STREAM;
            }
            case 0: {
                return NULL;
            }
            case 16: {
                return BOOLEAN;
            }
            case 2004: 
            case 2005: {
                return STREAM;
            }
            case 2003: {
                return ARRAY;
            }
            case 2000: {
                return OBJECT;
            }
        }
        throw new UnsupportedException("Unsuppoted JDBC-type:" + jdbcType);
    }
}

