/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.Constant;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.ValueType;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.ValueException;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.ObjectUtil;
import java.math.BigDecimal;

public final class SimpleValue
extends Number {
    public static final SimpleValue INT_1 = new SimpleValue(ValueType.INTEGER);
    ValueType type;
    int intValue;
    long longValue;
    double dblValue;
    Object objValue;

    public SimpleValue() {
    }

    public SimpleValue(ValueType type) {
        this.type = type;
    }

    private ValueException makeTypeException() {
        return new ValueException("Value type=" + this.type);
    }

    public final ValueType getType() {
        return this.type;
    }

    public final void setValue(int x) {
        this.intValue = x;
    }

    public final void setValue(long x) {
        this.longValue = x;
    }

    public final void setValue(double x) {
        this.dblValue = x;
    }

    public final void setValue(Object x) {
        this.objValue = x;
    }

    @Override
    public final int intValue() {
        if (ValueType.INTEGER == this.type) {
            return this.intValue;
        }
        if (ValueType.LONG == this.type) {
            return (int)this.longValue;
        }
        if (ValueType.DOUBLE == this.type) {
            return (int)this.dblValue;
        }
        if (this.objValue instanceof Number) {
            return ((Number)this.objValue).intValue();
        }
        throw this.makeTypeException();
    }

    @Override
    public final float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public final long longValue() {
        if (ValueType.LONG == this.type) {
            return this.longValue;
        }
        if (ValueType.INTEGER == this.type) {
            return this.intValue;
        }
        if (ValueType.DOUBLE == this.type) {
            return (long)this.dblValue;
        }
        if (this.objValue instanceof Number) {
            return ((Number)this.objValue).longValue();
        }
        throw this.makeTypeException();
    }

    @Override
    public final double doubleValue() {
        if (ValueType.DOUBLE == this.type) {
            return this.dblValue;
        }
        if (ValueType.INTEGER == this.type) {
            return this.intValue;
        }
        if (ValueType.LONG == this.type) {
            return this.longValue;
        }
        if (this.objValue instanceof Number) {
            return ((Number)this.objValue).doubleValue();
        }
        throw this.makeTypeException();
    }

    public final BigDecimal decimalValue() {
        if (ValueType.DECIMAL == this.type) {
            return (BigDecimal)this.objValue;
        }
        if (ValueType.INTEGER == this.type) {
            return new BigDecimal((double)this.intValue);
        }
        if (ValueType.LONG == this.type) {
            return new BigDecimal(this.longValue);
        }
        if (ValueType.DOUBLE == this.type) {
            return new BigDecimal(this.dblValue);
        }
        if (ValueType.DECIMAL == this.type) {
            return (BigDecimal)this.objValue;
        }
        if (this.objValue instanceof Number) {
            return new BigDecimal(this.objValue.toString());
        }
        throw this.makeTypeException();
    }

    public final Object objectValue() {
        if (ValueType.INTEGER == this.type) {
            return new Integer(this.intValue);
        }
        if (ValueType.LONG == this.type) {
            return new Long(this.longValue);
        }
        if (ValueType.DOUBLE == this.type) {
            return new Double(this.dblValue);
        }
        return this.objValue;
    }

    public final void toDecimal() {
        if (this.type != ValueType.DECIMAL) {
            this.objValue = this.decimalValue();
            this.type = ValueType.DECIMAL;
        }
    }

    public final void setAs(SimpleValue v) {
        this.type = v.type;
        if (ValueType.INTEGER == this.type) {
            this.intValue = v.intValue;
        } else if (ValueType.LONG == this.type) {
            this.longValue = v.intValue;
        } else if (ValueType.DOUBLE == this.type) {
            this.intValue = v.intValue;
        } else {
            this.objValue = v.objValue;
        }
    }

    public final void zero() {
        if (ValueType.INTEGER == this.type) {
            this.intValue = 0;
        } else if (ValueType.LONG == this.type) {
            this.longValue = 0L;
        } else if (ValueType.DOUBLE == this.type) {
            this.intValue = 0;
        } else if (ValueType.DECIMAL == this.type) {
            this.objValue = this.objValue != null ? BigDecimal.valueOf(0L, ((BigDecimal)this.objValue).scale()) : Constant.DECIMAL_0;
        } else {
            throw this.makeTypeException();
        }
    }

    public final void add1() {
        ++this.intValue;
    }

    public final void add(SimpleValue v) {
        if (ValueType.INTEGER == this.type) {
            this.intValue += v.intValue;
        } else if (ValueType.LONG == this.type) {
            this.longValue += v.longValue;
        } else if (ValueType.DOUBLE == this.type) {
            this.dblValue += v.dblValue;
        } else if (ValueType.DECIMAL == this.type) {
            if (v.objValue != null) {
                this.objValue = this.objValue == null ? v.objValue : ((BigDecimal)this.objValue).add((BigDecimal)v.objValue);
            }
        } else {
            throw this.makeTypeException();
        }
    }

    public final void min(SimpleValue v) {
        if (ValueType.INTEGER == this.type) {
            if (this.intValue > v.intValue) {
                this.intValue = v.intValue;
            }
        } else if (ValueType.LONG == this.type) {
            if (this.longValue > v.longValue) {
                this.longValue = v.longValue;
            }
        } else if (ValueType.DOUBLE == this.type) {
            if (this.dblValue > v.dblValue) {
                this.dblValue = v.dblValue;
            }
        } else if (ValueType.DECIMAL == this.type) {
            if (v.objValue != null && (this.objValue == null || ((BigDecimal)this.objValue).compareTo((BigDecimal)v.objValue) > 0)) {
                this.objValue = v.objValue;
            }
        } else {
            throw this.makeTypeException();
        }
    }

    public final void max(SimpleValue v) {
        if (ValueType.INTEGER == this.type) {
            if (this.intValue < v.intValue) {
                this.intValue = v.intValue;
            }
        } else if (ValueType.LONG == this.type) {
            if (this.longValue < v.longValue) {
                this.longValue = v.longValue;
            }
        } else if (ValueType.DOUBLE == this.type) {
            if (this.dblValue < v.dblValue) {
                this.dblValue = v.dblValue;
            }
        } else if (ValueType.DECIMAL == this.type) {
            if (v.objValue != null && (this.objValue == null || ((BigDecimal)this.objValue).compareTo((BigDecimal)v.objValue) < 0)) {
                this.objValue = v.objValue;
            }
        } else {
            throw this.makeTypeException();
        }
    }

    public final void divide(SimpleValue v) {
        BigDecimal dec;
        this.toDecimal();
        if (this.objValue != null && (dec = v.decimalValue()) != null) {
            this.objValue = ((BigDecimal)this.objValue).divide(dec, 2);
        }
    }

    public final boolean equals(SimpleValue v) {
        if (this.type != v.type) {
            return false;
        }
        if (ValueType.INTEGER == this.type) {
            return this.intValue == v.intValue;
        }
        if (ValueType.LONG == this.type) {
            return this.longValue == (long)v.intValue;
        }
        if (ValueType.DOUBLE == this.type) {
            return this.dblValue == v.dblValue;
        }
        return ObjectUtil.equals(this.objValue, v.objValue);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof SimpleValue) {
            SimpleValue v = (SimpleValue)obj;
            if (ValueType.OBJECT == this.type) {
                if (ValueType.OBJECT != v.type) {
                    return false;
                }
                if (this.objValue == null) {
                    return v.objValue == null;
                }
                return this.objValue.equals(v.objValue);
            }
            return this.equals((SimpleValue)obj);
        }
        return false;
    }

    public final String stringValue() {
        if (ValueType.INTEGER == this.type) {
            return String.valueOf(this.intValue);
        }
        if (ValueType.LONG == this.type) {
            return String.valueOf(this.intValue);
        }
        if (ValueType.DOUBLE == this.type) {
            return String.valueOf(this.dblValue);
        }
        return this.objValue != null ? this.objValue.toString() : null;
    }

    public final String toString() {
        if (ValueType.INTEGER == this.type) {
            return "int: " + this.intValue;
        }
        if (ValueType.LONG == this.type) {
            return "long: " + this.intValue;
        }
        if (ValueType.DOUBLE == this.type) {
            return "double: " + this.dblValue;
        }
        if (ValueType.DECIMAL == this.type) {
            return "decimal: " + this.objValue;
        }
        return "object: " + this.objValue;
    }

    static {
        SimpleValue.INT_1.intValue = 1;
    }
}

