/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.node.ExportException;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.GGFlatEngine;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.IFlatBuilder;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.RowContext;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GGCell;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GroupingGrid;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class AGGExporter {
    protected int colCount;
    protected GGFlatEngine engine;

    protected void init(GroupingGrid grid, ResultSet rows) throws SQLException {
        this.colCount = grid.getColCount();
        this.engine = new GGFlatEngine();
        this.engine.init(rows, grid);
        this.engine.setFlatBuilder(new IFlatBuilder(){

            @Override
            public Object buildRow(RowContext ctx) throws ExportException {
                try {
                    AGGExporter.this.exportARow(ctx);
                }
                catch (Exception ex) {
                    throw ExportException.makeException(ex);
                }
                return null;
            }
        });
    }

    public final boolean exportARow() throws ExportException, SQLException {
        return this.engine.nextRow();
    }

    public final void exportAll() throws ExportException, SQLException {
        while (this.engine.nextRow()) {
        }
    }

    protected abstract void exportARow(RowContext var1) throws Exception;

    protected final int findColIndex(GGCell ggCell, RowContext ctx) throws SQLException {
        int dataCol = ggCell.getDataCol().getIndex();
        if (ctx.isDetailRow()) {
            return this.engine.findDetailCol(dataCol);
        }
        return this.engine.findGroupCol(ctx.getGroupLevel(), ggCell.getStatType(), dataCol);
    }
}

