/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.rs;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.rs.AResultSet;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SimpleResultSet
extends AResultSet {
    private ResultSetMetaData rsmd;
    private int colCount = 0;
    private Object[] datas;
    private int rowCount;
    private int rowIndex;
    private boolean updateInsert;

    public SimpleResultSet(ResultSetMetaData rsmd) throws SQLException {
        this.init(rsmd);
    }

    protected SimpleResultSet() {
    }

    protected void init(ResultSetMetaData rsmd) throws SQLException {
        this.rsmd = rsmd;
        this.colCount = rsmd.getColumnCount();
        this.deleteRows();
    }

    public void deleteRows() {
        this.datas = new Object[8 * this.colCount];
        this.rowCount = 0;
        this.rowIndex = 0;
    }

    protected final int getColCount() {
        return this.colCount;
    }

    protected final int getRowCount() {
        return this.rowCount;
    }

    protected final Object[] getDatas() {
        return this.datas;
    }

    protected final int getLastDataIndex() {
        return (this.rowCount + 1) * this.colCount;
    }

    public void checkColumnIndex(int colIdx) throws SQLException {
        if (colIdx < 1 || colIdx > this.colCount) {
            throw new SQLException("Invalid column index: " + colIdx + ", count: " + this.colCount);
        }
    }

    private void throwInvalidCursorException() throws SQLException {
        throw new SQLException("Invalid cursor index: " + this.rowIndex + ", count: " + this.rowCount);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rsmd;
    }

    @Override
    public int getType() throws SQLException {
        return 1004;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (row < 0) {
            row = this.rowCount + 1 + row;
        }
        if (row < 1) {
            throw new SQLException("Invalid row index: " + row + ", count: " + this.rowCount);
        }
        this.rowIndex = row;
        return true;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.rowIndex < 1;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.rowIndex = 0;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.rowIndex >= this.rowCount) {
            return false;
        }
        return super.next();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.rowIndex > this.rowCount;
    }

    @Override
    public void afterLast() throws SQLException {
        this.rowIndex = this.rowCount + 1;
    }

    @Override
    public int getRow() throws SQLException {
        return this.rowIndex;
    }

    protected void resize(int rowCount, int ahead) {
        this.rowCount = rowCount;
        int z = this.getLastDataIndex();
        if (z > this.datas.length) {
            Object[] datas2 = new Object[z + ahead * this.colCount];
            System.arraycopy(this.datas, 0, datas2, 0, this.datas.length);
            this.datas = datas2;
        }
    }

    @Override
    public void updateRow() throws SQLException {
        int rowIdx = this.updateInsert ? this.rowCount : this.rowIndex;
        int j = rowIdx * this.colCount;
        int i = 0;
        while (i < this.colCount) {
            this.datas[j] = this.datas[i];
            ++i;
            ++j;
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.updateInsert = true;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.updateInsert = false;
    }

    @Override
    public void insertRow() throws SQLException {
        int rowIdx = this.rowCount + 1;
        this.resize(rowIdx, 100);
        int j = rowIdx * this.colCount;
        int i = 0;
        while (i < this.colCount) {
            this.datas[j] = this.datas[i];
            ++i;
            ++j;
        }
    }

    @Override
    public Object getObject(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        if (this.rowIndex < 1 || this.rowIndex > this.rowCount) {
            this.throwInvalidCursorException();
        }
        return this.datas[this.rowIndex * this.colCount + colIndex - 1];
    }

    @Override
    public short getShort(int colIndex) throws SQLException {
        Object data = this.getObject(colIndex);
        if (data instanceof Number) {
            return ((Number)data).shortValue();
        }
        throw new SQLException("Dismatch data " + data + " to type " + Number.class);
    }

    @Override
    public int getInt(int colIndex) throws SQLException {
        Object data = this.getObject(colIndex);
        if (data instanceof Number) {
            return ((Number)data).intValue();
        }
        throw new SQLException("Dismatch data " + data + " to type " + Number.class);
    }

    @Override
    public long getLong(int colIndex) throws SQLException {
        Object data = this.getObject(colIndex);
        if (data instanceof Number) {
            return ((Number)data).longValue();
        }
        throw new SQLException("Dismatch data " + data + " to type " + Number.class);
    }

    @Override
    public float getFloat(int colIndex) throws SQLException {
        Object data = this.getObject(colIndex);
        if (data instanceof Number) {
            return ((Number)data).floatValue();
        }
        throw new SQLException("Dismatch data " + data + " to type " + Number.class);
    }

    @Override
    public double getDouble(int colIndex) throws SQLException {
        Object data = this.getObject(colIndex);
        if (data instanceof Number) {
            return ((Number)data).doubleValue();
        }
        throw new SQLException("Dismatch data " + data + " to type " + Number.class);
    }

    @Override
    public String getString(int colIndex) throws SQLException {
        Object data = this.getObject(colIndex);
        return data != null ? data.toString() : null;
    }

    @Override
    public BigDecimal getBigDecimal(int colIndex) throws SQLException {
        Object data = this.getObject(colIndex);
        return data instanceof BigDecimal ? (BigDecimal)data : null;
    }

    @Override
    public void updateObject(int colIndex, Object x) throws SQLException {
        this.checkColumnIndex(colIndex);
        if (this.updateInsert) {
            this.datas[colIndex - 1] = x;
        } else {
            if (this.rowIndex < 1) {
                this.throwInvalidCursorException();
            }
            this.datas[this.rowIndex * this.colCount + colIndex - 1] = x;
        }
    }

    @Override
    public void updateInt(int colIndex, int x) throws SQLException {
        this.updateObject(colIndex, (Object)new Integer(x));
    }

    @Override
    public void updateString(int colIndex, String x) throws SQLException {
        this.updateObject(colIndex, (Object)x);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.rowIndex);
        sb.append("/");
        sb.append(this.rowCount);
        sb.append("{");
        sb.append(this.rsmd);
        sb.append("}");
        return sb.toString();
    }

    public Object getObject(int columnIndex, Class type) throws SQLException {
        return null;
    }

    public Object getObject(String columnLabel, Class type) throws SQLException {
        return null;
    }
}

