/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.formats.csv;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.formats.csv.CsvFormat;
import java.io.IOException;
import java.io.Writer;

public class CsvWriter {
    private Writer writer;
    private CsvFormat format;

    public CsvWriter(Writer writer) {
        this(writer, CsvFormat.DEFAULT);
    }

    public CsvWriter(Writer writer, CsvFormat format) {
        this.writer = writer;
        this.format = format;
    }

    public final void writeRow(String[] cells) throws IOException {
        int i;
        if (cells == null || cells.length == 0) {
            this.writer.write(10);
        }
        int z = cells.length - 1;
        for (i = 0; i < z; ++i) {
            this.writeData(cells[i]);
            this.writer.write(this.format.cellSplit);
        }
        this.writeData(cells[i]);
        this.writer.write(10);
    }

    public final void writeCell(String data, boolean rowEnd) throws IOException {
        this.writeData(data);
        this.writer.write(rowEnd ? 10 : this.format.cellSplit);
    }

    public final void writeData(String s) throws IOException {
        if (s == null) {
            return;
        }
        boolean bracket = false;
        int z = s.length();
        for (int i = 0; i < z; ++i) {
            char c = s.charAt(i);
            if (this.format.cellSplit == c || '\n' == c || c < ' ') {
                if (!bracket) {
                    bracket = true;
                    this.writer.write(this.format.dataBracket);
                }
            } else if (this.format.dataBracket == c) {
                if (!bracket) {
                    bracket = true;
                    this.writer.write(this.format.dataBracket);
                }
                this.writer.write(this.format.dataBracket);
            }
            this.writer.write(c);
        }
        if (bracket) {
            this.writer.write(this.format.dataBracket);
        }
    }
}

