/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.NameIndex;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.AModel;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.MvcEvent;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.ASwingView;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.SwingViewUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.tree.ATreeBuilder;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.tree.NormalTreeBuilder;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.tree.VTreeNode;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class VTree
extends ASwingView {
    private static final Logger log = CommonLogger.getLogger(VTree.class);
    protected JTree mainView;
    private NameIndex treeCol;
    private String rootText;

    public VTree() {
        super(new JTree());
    }

    @Override
    protected JComponent init(JComponent mainComp) {
        this.mainView = (JTree)mainComp;
        this.mainView.addTreeSelectionListener(new Ctrl());
        return new JScrollPane(this.mainView);
    }

    public final JTree getMainView() {
        return this.mainView;
    }

    public final TreeModel getViewModel() {
        return this.getMainView().getModel();
    }

    public final void setViewModel(TreeModel x) {
        this.getMainView().setModel(x);
    }

    @Override
    public void setModel(AModel model) {
        super.setModel(model);
    }

    public final String getRootText() {
        return this.rootText;
    }

    public final void setRootText(String rootText) {
        this.rootText = rootText;
    }

    public final NameIndex getTreeCol() {
        return this.treeCol;
    }

    public final void setTreeCol(NameIndex treeCol) {
        this.treeCol = treeCol;
    }

    @Override
    protected void update(MvcEvent mvc) {
        AModel model = (AModel)mvc.getSource();
        ResultSet rows = (ResultSet)model.getResult();
        if (mvc.isMessage(1)) {
            VTreeNode rootNode = new VTreeNode();
            rootNode.setRowIndex(0);
            rootNode.setLevels(null);
            rootNode.setValue(null);
            rootNode.setText(this.rootText);
            NormalTreeBuilder treeBuilder = new NormalTreeBuilder('.');
            ((ATreeBuilder)treeBuilder).setRootNode(rootNode);
            try {
                int idxLevels = this.treeCol.locate(rows);
                int idxText = SwingViewUtil.locateCols(this.getBinding(), rows);
                int idxValue = this.getBinding().getCol().getIndex();
                treeBuilder.rowIndex = 0;
                rows.beforeFirst();
                while (rows.next()) {
                    ++treeBuilder.rowIndex;
                    treeBuilder.colLevels = rows.getString(idxLevels);
                    treeBuilder.colValue = rows.getObject(idxValue);
                    treeBuilder.colText = rows.getString(idxText);
                    ((ATreeBuilder)treeBuilder).addTreeNode();
                }
            }
            catch (SQLException ex) {
                log.error((Object)("Exception row-index: " + treeBuilder.rowIndex), (Throwable)ex);
            }
            this.setViewModel(new DefaultTreeModel(rootNode));
        }
    }

    protected class Ctrl
    implements TreeSelectionListener {
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (VTree.this.isUpdating()) {
                return;
            }
            VTreeNode tn = (VTreeNode)e.getPath().getLastPathComponent();
            VTree.this.fireValueChanged(1 + tn.getRowIndex(), null);
        }
    }
}

